/*
 * Decompiled with CFR 0.152.
 */
package rst.pdfbox.layout.util;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import rst.pdfbox.layout.util.WordBreaker;
import rst.pdfbox.layout.util.WordBreakers;

public class WordBreakerFactory {
    public static final String WORD_BREAKER_CLASS_PROPERTY = "pdfbox.layout.word.breaker";
    public static final String DEFAULT_WORD_BREAKER_CLASS_NAME = WordBreakers.DefaultWordBreaker.class.getName();
    public static final String LEGACY_WORD_BREAKER_CLASS_NAME = WordBreakers.NonBreakingWordBreaker.class.getName();
    private static final WordBreaker DEFAULT_WORD_BREAKER = new WordBreakers.DefaultWordBreaker();
    private static final Map<String, WordBreaker> WORD_BREAKERS = new ConcurrentHashMap<String, WordBreaker>();

    public static WordBreaker getWorkBreaker() {
        return WordBreakerFactory.getWorkBreaker(System.getProperty(WORD_BREAKER_CLASS_PROPERTY));
    }

    private static WordBreaker getWorkBreaker(String className) {
        if (className == null) {
            return DEFAULT_WORD_BREAKER;
        }
        WordBreaker wordBreaker = WORD_BREAKERS.get(className);
        if (wordBreaker == null) {
            wordBreaker = WordBreakerFactory.createWordBreakerInstance(className);
            WORD_BREAKERS.put(className, wordBreaker);
        }
        return wordBreaker;
    }

    private static WordBreaker createWordBreakerInstance(String className) {
        try {
            return (WordBreaker)Class.forName(className).newInstance();
        }
        catch (Exception e2) {
            throw new RuntimeException(String.format("failed to create word breaker '%s'", className), e2);
        }
    }
}

