/*
 * Decompiled with CFR 0.152.
 */
package rst.pdfbox.layout.util;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import rst.pdfbox.layout.util.Enumerator;
import rst.pdfbox.layout.util.Enumerators;

public class EnumeratorFactory {
    private static final Map<String, Class<? extends Enumerator>> ENUMERATORS = new ConcurrentHashMap<String, Class<? extends Enumerator>>();

    public static void register(String key, Class<? extends Enumerator> enumeratorClass) {
        ENUMERATORS.put(key, enumeratorClass);
    }

    public static Enumerator createEnumerator(String key) {
        Class<? extends Enumerator> enumeratorClass = ENUMERATORS.get(key);
        if (enumeratorClass == null) {
            throw new IllegalArgumentException("no enumerator found for '" + key + "'");
        }
        try {
            return enumeratorClass.newInstance();
        }
        catch (Exception e2) {
            throw new RuntimeException("failed to create enumerator", e2);
        }
    }

    static {
        EnumeratorFactory.register("1", Enumerators.ArabicEnumerator.class);
        EnumeratorFactory.register("I", Enumerators.RomanEnumerator.class);
        EnumeratorFactory.register("i", Enumerators.LowerCaseRomanEnumerator.class);
        EnumeratorFactory.register("A", Enumerators.AlphabeticEnumerator.class);
        EnumeratorFactory.register("a", Enumerators.LowerCaseAlphabeticEnumerator.class);
    }
}

