/*
 * Decompiled with CFR 0.152.
 */
package rst.pdfbox.layout.util;

import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.graphics.color.PDColor;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceRGB;
import org.apache.pdfbox.pdmodel.graphics.image.LosslessFactory;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionGoTo;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionURI;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationLink;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDBorderStyleDictionary;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDDestination;
import org.apache.pdfbox.rendering.ImageType;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.apache.pdfbox.util.Matrix;
import rst.pdfbox.layout.text.Position;
import rst.pdfbox.layout.text.annotations.Annotations;

public class CompatibilityHelper {
    private static final String BULLET = "\u2022";
    private static final String DOUBLE_ANGLE = "\u00bb";
    private static final String IMAGE_CACHE = "IMAGE_CACHE";
    private static Map<PDDocument, Map<String, Map<?, ?>>> documentCaches = new WeakHashMap();
    private static PDBorderStyleDictionary noBorder;

    public static String getBulletCharacter(int level) {
        if (level % 2 == 1) {
            return System.getProperty("pdfbox.layout.bullet.odd", BULLET);
        }
        return System.getProperty("pdfbox.layout.bullet.even", DOUBLE_ANGLE);
    }

    public static void clip(PDPageContentStream contentStream) throws IOException {
        contentStream.clip();
    }

    public static void transform(PDPageContentStream contentStream, float a2, float b2, float c2, float d2, float e2, float f2) throws IOException {
        contentStream.transform(new Matrix(a2, b2, c2, d2, e2, f2));
    }

    public static void curveTo(PDPageContentStream contentStream, float x1, float y1, float x2, float y2, float x3, float y3) throws IOException {
        contentStream.curveTo(x1, y1, x2, y2, x3, y3);
    }

    public static void curveTo1(PDPageContentStream contentStream, float x1, float y1, float x3, float y3) throws IOException {
        contentStream.curveTo1(x1, y1, x3, y3);
    }

    public static void fillNonZero(PDPageContentStream contentStream) throws IOException {
        contentStream.fill();
    }

    public static void showText(PDPageContentStream contentStream, String text) throws IOException {
        contentStream.showText(text);
    }

    public static void setTextTranslation(PDPageContentStream contentStream, float x, float y) throws IOException {
        contentStream.setTextMatrix(Matrix.getTranslateInstance(x, y));
    }

    public static void moveTextPosition(PDPageContentStream contentStream, float x, float y) throws IOException {
        contentStream.transform(new Matrix(1.0f, 0.0f, 0.0f, 1.0f, x, y));
    }

    public static PDPageContentStream createAppendablePDPageContentStream(PDDocument pdDocument, PDPage page) throws IOException {
        return new PDPageContentStream(pdDocument, page, true, true);
    }

    public static void drawImage(BufferedImage image, PDDocument document, PDPageContentStream contentStream, Position upperLeft, float width, float height) throws IOException {
        PDImageXObject cachedImage = CompatibilityHelper.getCachedImage(document, image);
        float x = upperLeft.getX();
        float y = upperLeft.getY() - height;
        contentStream.drawImage(cachedImage, x, y, width, height);
    }

    public static int getPageRotation(PDPage page) {
        return page.getRotation();
    }

    public static BufferedImage createImageFromPage(PDDocument document, int pageIndex, int resolution) throws IOException {
        PDFRenderer pdfRenderer = new PDFRenderer(document);
        return pdfRenderer.renderImageWithDPI(pageIndex, resolution, ImageType.RGB);
    }

    public static PDAnnotationLink createLink(PDPage page, PDRectangle rect, Color color, Annotations.HyperlinkAnnotation.LinkStyle linkStyle, String uri) {
        PDAnnotationLink pdLink = CompatibilityHelper.createLink(page, rect, color, linkStyle);
        PDActionURI actionUri = new PDActionURI();
        actionUri.setURI(uri);
        pdLink.setAction(actionUri);
        return pdLink;
    }

    public static PDAnnotationLink createLink(PDPage page, PDRectangle rect, Color color, Annotations.HyperlinkAnnotation.LinkStyle linkStyle, PDDestination destination) {
        PDAnnotationLink pdLink = CompatibilityHelper.createLink(page, rect, color, linkStyle);
        PDActionGoTo gotoAction = new PDActionGoTo();
        gotoAction.setDestination(destination);
        pdLink.setAction(gotoAction);
        return pdLink;
    }

    public static void setAnnotationColor(PDAnnotation annotation, Color color) {
        annotation.setColor(CompatibilityHelper.toPDColor(color));
    }

    private static PDAnnotationLink createLink(PDPage page, PDRectangle rect, Color color, Annotations.HyperlinkAnnotation.LinkStyle linkStyle) {
        PDAnnotationLink pdLink = new PDAnnotationLink();
        pdLink.setBorderStyle(CompatibilityHelper.toBorderStyle(linkStyle));
        PDRectangle rotatedRect = CompatibilityHelper.transformToPageRotation(rect, page);
        pdLink.setRectangle(rotatedRect);
        CompatibilityHelper.setAnnotationColor(pdLink, color);
        return pdLink;
    }

    private static PDBorderStyleDictionary toBorderStyle(Annotations.HyperlinkAnnotation.LinkStyle linkStyle) {
        if (linkStyle == Annotations.HyperlinkAnnotation.LinkStyle.none) {
            return CompatibilityHelper.getNoBorder();
        }
        PDBorderStyleDictionary borderStyle = new PDBorderStyleDictionary();
        borderStyle.setStyle("U");
        return borderStyle;
    }

    private static PDColor toPDColor(Color color) {
        float[] components = new float[]{(float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f};
        return new PDColor(components, (PDColorSpace)PDDeviceRGB.INSTANCE);
    }

    public static float[] toQuadPoints(PDRectangle rect) {
        return CompatibilityHelper.toQuadPoints(rect, 0.0f, 0.0f);
    }

    public static float[] toQuadPoints(PDRectangle rect, float xOffset, float yOffset) {
        float[] quads;
        quads = new float[]{rect.getLowerLeftX() + xOffset, rect.getUpperRightY() + yOffset, rect.getUpperRightX() + xOffset, quads[1], quads[0], rect.getLowerLeftY() + yOffset, quads[2], quads[5]};
        return quads;
    }

    public static float[] transformToPageRotation(float[] quadPoints, PDPage page) {
        AffineTransform transform = CompatibilityHelper.transformToPageRotation(page);
        if (transform == null) {
            return quadPoints;
        }
        float[] rotatedPoints = new float[quadPoints.length];
        transform.transform(quadPoints, 0, rotatedPoints, 0, 4);
        return rotatedPoints;
    }

    public static PDRectangle transformToPageRotation(PDRectangle rect, PDPage page) {
        AffineTransform transform = CompatibilityHelper.transformToPageRotation(page);
        if (transform == null) {
            return rect;
        }
        float[] points = new float[]{rect.getLowerLeftX(), rect.getLowerLeftY(), rect.getUpperRightX(), rect.getUpperRightY()};
        float[] rotatedPoints = new float[4];
        transform.transform(points, 0, rotatedPoints, 0, 2);
        PDRectangle rotated = new PDRectangle();
        rotated.setLowerLeftX(rotatedPoints[0]);
        rotated.setLowerLeftY(rotatedPoints[1]);
        rotated.setUpperRightX(rotatedPoints[2]);
        rotated.setUpperRightY(rotatedPoints[3]);
        return rotated;
    }

    private static AffineTransform transformToPageRotation(PDPage page) {
        int pageRotation = CompatibilityHelper.getPageRotation(page);
        if (pageRotation == 0) {
            return null;
        }
        float pageWidth = page.getMediaBox().getHeight();
        float pageHeight = page.getMediaBox().getWidth();
        AffineTransform transform = new AffineTransform();
        transform.rotate((double)pageRotation * Math.PI / 180.0, pageHeight / 2.0f, pageWidth / 2.0f);
        double offset = Math.abs(pageHeight - pageWidth) / 2.0f;
        transform.translate(-offset, offset);
        return transform;
    }

    private static PDBorderStyleDictionary getNoBorder() {
        if (noBorder == null) {
            noBorder = new PDBorderStyleDictionary();
            noBorder.setWidth(0.0f);
        }
        return noBorder;
    }

    private static synchronized Map<String, Map<?, ?>> getDocumentCache(PDDocument document) {
        Map<String, Map<?, ?>> cache = documentCaches.get(document);
        if (cache == null) {
            cache = new HashMap();
            documentCaches.put(document, cache);
        }
        return cache;
    }

    private static synchronized Map<BufferedImage, PDImageXObject> getImageCache(PDDocument document) {
        Map<String, Map<?, ?>> documentCache = CompatibilityHelper.getDocumentCache(document);
        Map<BufferedImage, PDImageXObject> imageCache = documentCache.get(IMAGE_CACHE);
        if (imageCache == null) {
            imageCache = new HashMap<BufferedImage, PDImageXObject>();
            documentCache.put(IMAGE_CACHE, imageCache);
        }
        return imageCache;
    }

    private static synchronized PDImageXObject getCachedImage(PDDocument document, BufferedImage image) throws IOException {
        Map<BufferedImage, PDImageXObject> imageCache = CompatibilityHelper.getImageCache(document);
        PDImageXObject pdxObjectImage = imageCache.get(image);
        if (pdxObjectImage == null) {
            pdxObjectImage = LosslessFactory.createFromImage(document, image);
            imageCache.put(image, pdxObjectImage);
        }
        return pdxObjectImage;
    }
}

