/*
 * Decompiled with CFR 0.152.
 */
package rst.pdfbox.layout.text.annotations;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import rst.pdfbox.layout.text.annotations.AnnotationProcessor;
import rst.pdfbox.layout.text.annotations.HyperlinkAnnotationProcessor;
import rst.pdfbox.layout.text.annotations.UnderlineAnnotationProcessor;

public class AnnotationProcessorFactory {
    private static final List<Class<? extends AnnotationProcessor>> ANNOTATION_PROCESSORS = new CopyOnWriteArrayList<Class<? extends AnnotationProcessor>>();

    public static void register(Class<? extends AnnotationProcessor> annotationProcessor) {
        ANNOTATION_PROCESSORS.add(annotationProcessor);
    }

    public static Iterable<AnnotationProcessor> createAnnotationProcessors() {
        ArrayList<AnnotationProcessor> annotationProcessors = new ArrayList<AnnotationProcessor>();
        for (Class<? extends AnnotationProcessor> annotationProcessorClass : ANNOTATION_PROCESSORS) {
            try {
                annotationProcessors.add(annotationProcessorClass.newInstance());
            }
            catch (Exception e2) {
                throw new RuntimeException("failed to create AnnotationProcessor", e2);
            }
        }
        return annotationProcessors;
    }

    static {
        AnnotationProcessorFactory.register(HyperlinkAnnotationProcessor.class);
        AnnotationProcessorFactory.register(UnderlineAnnotationProcessor.class);
    }
}

