/*
 * Decompiled with CFR 0.152.
 */
package rst.pdfbox.layout.text;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import rst.pdfbox.layout.elements.Dividable;
import rst.pdfbox.layout.elements.Paragraph;
import rst.pdfbox.layout.text.Alignment;
import rst.pdfbox.layout.text.DrawListener;
import rst.pdfbox.layout.text.FontDescriptor;
import rst.pdfbox.layout.text.Indent;
import rst.pdfbox.layout.text.NewLine;
import rst.pdfbox.layout.text.Position;
import rst.pdfbox.layout.text.ReplacedWhitespace;
import rst.pdfbox.layout.text.StyledText;
import rst.pdfbox.layout.text.TextFlow;
import rst.pdfbox.layout.text.TextFragment;
import rst.pdfbox.layout.text.TextLine;
import rst.pdfbox.layout.text.TextSequence;
import rst.pdfbox.layout.text.WrappingNewLine;
import rst.pdfbox.layout.util.Pair;
import rst.pdfbox.layout.util.WordBreakerFactory;

public class TextSequenceUtil {
    public static List<TextLine> getLines(TextSequence text) throws IOException {
        ArrayList<TextLine> result = new ArrayList<TextLine>();
        TextLine line = new TextLine();
        for (TextFragment fragment : text) {
            if (fragment instanceof NewLine) {
                line.setNewLine((NewLine)fragment);
                result.add(line);
                line = new TextLine();
                continue;
            }
            if (fragment instanceof ReplacedWhitespace) continue;
            line.add((StyledText)fragment);
        }
        if (!line.isEmpty()) {
            result.add(line);
        }
        return result;
    }

    public static Dividable.Divided divide(TextSequence text, float maxWidth, float maxHeight) throws IOException {
        TextLine line;
        TextFlow wrapped = TextSequenceUtil.wordWrap(text, maxWidth);
        List<TextLine> lines = TextSequenceUtil.getLines(wrapped);
        Paragraph first = new Paragraph();
        Paragraph tail = new Paragraph();
        if (text instanceof TextFlow) {
            TextFlow flow = (TextFlow)text;
            first.setMaxWidth(flow.getMaxWidth());
            first.setLineSpacing(flow.getLineSpacing());
            tail.setMaxWidth(flow.getMaxWidth());
            tail.setLineSpacing(flow.getLineSpacing());
        }
        if (text instanceof Paragraph) {
            Paragraph paragraph = (Paragraph)text;
            first.setAlignment(paragraph.getAlignment());
            first.setApplyLineSpacingToFirstLine(paragraph.isApplyLineSpacingToFirstLine());
            tail.setAlignment(paragraph.getAlignment());
            tail.setApplyLineSpacingToFirstLine(paragraph.isApplyLineSpacingToFirstLine());
        }
        int index = 0;
        do {
            line = lines.get(index);
            first.add(line);
        } while (++index < lines.size() && first.getHeight() < maxHeight);
        if (first.getHeight() > maxHeight) {
            line = lines.get(--index);
            for (TextFragment textFragment : line) {
                first.removeLast();
            }
        }
        for (int i2 = index; i2 < lines.size(); ++i2) {
            tail.add(lines.get(i2));
        }
        return new Dividable.Divided(first, tail);
    }

    public static TextFlow wordWrap(TextSequence text, float maxWidth) throws IOException {
        float indentation = 0.0f;
        TextFlow result = new TextFlow();
        float lineLength = indentation;
        boolean isWrappedLine = false;
        for (TextFragment fragment : text) {
            if (fragment instanceof NewLine) {
                isWrappedLine = fragment instanceof WrappingNewLine;
                result.add(fragment);
                lineLength = indentation;
                if (!(indentation > 0.0f)) continue;
                result.add(new Indent(indentation).toStyledText());
                continue;
            }
            if (fragment instanceof Indent) {
                if (indentation > 0.0f) {
                    result.removeLast();
                    indentation = 0.0f;
                }
                indentation = fragment.getWidth();
                lineLength = fragment.getWidth();
                result.add(((Indent)fragment).toStyledText());
                continue;
            }
            TextFlow words = TextSequenceUtil.splitWords(fragment);
            for (TextFragment word : words) {
                WordWrapContext context = new WordWrapContext(word, lineLength, indentation, isWrappedLine);
                while ((context = TextSequenceUtil.wordWrap(context, maxWidth, result)).isMoreToWrap()) {
                }
                indentation = context.getIndentation();
                lineLength = context.getLineLength();
                isWrappedLine = context.isWrappedLine();
            }
        }
        return result;
    }

    private static WordWrapContext wordWrap(WordWrapContext context, float maxWidth, TextFlow result) throws IOException {
        TextFragment word = context.getWord();
        TextFragment moreToWrap = null;
        float indentation = context.getIndentation();
        float lineLength = context.getLineLength();
        boolean isWrappedLine = context.isWrappedLine();
        if (isWrappedLine && lineLength == indentation) {
            TextFragment[] replaceLeadingBlanks = TextSequenceUtil.replaceLeadingBlanks(word);
            word = replaceLeadingBlanks[0];
            if (replaceLeadingBlanks.length > 1) {
                result.add(replaceLeadingBlanks[1]);
            }
        }
        FontDescriptor fontDescriptor = word.getFontDescriptor();
        float length = word.getWidth();
        if (maxWidth > 0.0f && lineLength + length > maxWidth) {
            boolean breakHard = indentation + length > maxWidth;
            Pair<TextFragment> brokenWord = TextSequenceUtil.breakWord(word, length, maxWidth - lineLength, maxWidth - indentation, breakHard);
            if (brokenWord != null) {
                word = brokenWord.getFirst();
                length = word.getWidth();
                moreToWrap = brokenWord.getSecond();
                result.add(word);
                if (length > 0.0f) {
                    lineLength += length;
                }
            } else if (lineLength == indentation) {
                result.add(word);
                if (length > 0.0f) {
                    lineLength += length;
                }
            } else {
                moreToWrap = word;
                if (result.getLast() != null) {
                    fontDescriptor = result.getLast().getFontDescriptor();
                }
            }
            if (lineLength > indentation) {
                result.add(new WrappingNewLine(fontDescriptor));
                isWrappedLine = true;
                if (indentation > 0.0f) {
                    result.add(new Indent(indentation).toStyledText());
                }
                lineLength = indentation;
            }
        } else {
            result.add(word);
            if (length > 0.0f) {
                lineLength += length;
            }
        }
        return new WordWrapContext(moreToWrap, lineLength, indentation, isWrappedLine);
    }

    private static TextFragment[] replaceLeadingBlanks(TextFragment word) {
        int splitIndex;
        String text = word.getText();
        for (splitIndex = 0; splitIndex < text.length() && Character.isWhitespace(text.charAt(splitIndex)); ++splitIndex) {
        }
        if (splitIndex == 0) {
            return new TextFragment[]{word};
        }
        ReplacedWhitespace whitespace = new ReplacedWhitespace(text.substring(0, splitIndex), word.getFontDescriptor());
        StyledText newWord = null;
        newWord = word instanceof StyledText ? ((StyledText)word).inheritAttributes(text.substring(splitIndex)) : new StyledText(text.substring(splitIndex), word.getFontDescriptor(), word.getColor());
        return new TextFragment[]{newWord, whitespace};
    }

    public static TextFlow deWrap(TextSequence text) throws IOException {
        TextFlow result = new TextFlow();
        for (TextFragment fragment : text) {
            if (fragment instanceof WrappingNewLine) continue;
            if (fragment instanceof ReplacedWhitespace) {
                result.add(((ReplacedWhitespace)fragment).toReplacedFragment());
                continue;
            }
            result.add(fragment);
        }
        if (text instanceof TextFlow) {
            result.setLineSpacing(((TextFlow)text).getLineSpacing());
        }
        return result;
    }

    public static List<TextLine> wordWrapToLines(TextSequence text, float maxWidth) throws IOException {
        TextFlow wrapped = TextSequenceUtil.wordWrap(text, maxWidth);
        List<TextLine> lines = TextSequenceUtil.getLines(wrapped);
        return lines;
    }

    public static TextFlow splitWords(TextFragment text) {
        TextFlow result = new TextFlow();
        if (text instanceof NewLine) {
            result.add(text);
        } else {
            float leftMargin = 0.0f;
            float rightMargin = 0.0f;
            if (text instanceof StyledText && ((StyledText)text).hasMargin()) {
                leftMargin = ((StyledText)text).getLeftMargin();
                rightMargin = ((StyledText)text).getRightMargin();
            }
            String[] words = text.getText().split(" ", -1);
            for (int index = 0; index < words.length; ++index) {
                String newWord = index == 0 ? words[index] : " " + words[index];
                float currentLeftMargin = 0.0f;
                float currentRightMargin = 0.0f;
                if (index == 0) {
                    currentLeftMargin = leftMargin;
                }
                if (index == words.length - 1) {
                    currentRightMargin = rightMargin;
                }
                TextFragment derived = TextSequenceUtil.deriveFromExisting(text, newWord, currentLeftMargin, currentRightMargin);
                result.add(derived);
            }
        }
        return result;
    }

    protected static TextFragment deriveFromExisting(TextFragment toDeriveFrom, String text, float leftMargin, float rightMargin) {
        if (toDeriveFrom instanceof StyledText) {
            return ((StyledText)toDeriveFrom).inheritAttributes(text, leftMargin, rightMargin);
        }
        return new StyledText(text, toDeriveFrom.getFontDescriptor(), toDeriveFrom.getColor(), 0.0f, leftMargin, rightMargin);
    }

    private static Pair<TextFragment> breakWord(TextFragment word, float wordWidth, float remainingLineWidth, float maxWidth, boolean breakHard) throws IOException {
        Pair<String> brokenWord;
        float leftMargin = 0.0f;
        float rightMargin = 0.0f;
        if (word instanceof StyledText) {
            StyledText styledText = (StyledText)word;
            leftMargin = styledText.getLeftMargin();
            rightMargin = styledText.getRightMargin();
        }
        if ((brokenWord = WordBreakerFactory.getWorkBreaker().breakWord(word.getText(), word.getFontDescriptor(), remainingLineWidth - leftMargin, breakHard)) == null) {
            return null;
        }
        TextFragment head = TextSequenceUtil.deriveFromExisting(word, brokenWord.getFirst(), leftMargin, 0.0f);
        TextFragment tail = TextSequenceUtil.deriveFromExisting(word, brokenWord.getSecond(), 0.0f, rightMargin);
        return new Pair<TextFragment>(head, tail);
    }

    public static float getEmWidth(FontDescriptor fontDescriptor) throws IOException {
        return TextSequenceUtil.getStringWidth("M", fontDescriptor);
    }

    public static float getStringWidth(String text, FontDescriptor fontDescriptor) throws IOException {
        return fontDescriptor.getSize() * fontDescriptor.getFont().getStringWidth(text) / 1000.0f;
    }

    public static void drawText(TextSequence text, PDPageContentStream contentStream, Position upperLeft, DrawListener drawListener, Alignment alignment, float maxWidth, float lineSpacing, boolean applyLineSpacingToFirstLine) throws IOException {
        List<TextLine> lines = TextSequenceUtil.wordWrapToLines(text, maxWidth);
        float maxLineWidth = Math.max(maxWidth, TextSequenceUtil.getMaxWidth(lines));
        Position position = upperLeft;
        float lastLineHeight = 0.0f;
        for (int i2 = 0; i2 < lines.size(); ++i2) {
            boolean applyLineSpacing = i2 > 0 || applyLineSpacingToFirstLine;
            TextLine textLine = lines.get(i2);
            float currentLineHeight = textLine.getHeight();
            float lead = lastLineHeight;
            if (applyLineSpacing) {
                lead += currentLineHeight * (lineSpacing - 1.0f);
            }
            lastLineHeight = currentLineHeight;
            position = position.add(0.0f, -lead);
            textLine.drawAligned(contentStream, position, alignment, maxLineWidth, drawListener);
        }
    }

    public static float getOffset(TextSequence textLine, float targetWidth, Alignment alignment) throws IOException {
        switch (alignment) {
            case Right: {
                return targetWidth - textLine.getWidth();
            }
            case Center: {
                return (targetWidth - textLine.getWidth()) / 2.0f;
            }
        }
        return 0.0f;
    }

    public static float getMaxWidth(Iterable<TextLine> lines) throws IOException {
        float max = 0.0f;
        for (TextLine line : lines) {
            max = Math.max(max, line.getWidth());
        }
        return max;
    }

    public static float getWidth(TextSequence textSequence, float maxWidth) throws IOException {
        List<TextLine> lines = TextSequenceUtil.wordWrapToLines(textSequence, maxWidth);
        float max = 0.0f;
        for (TextLine line : lines) {
            max = Math.max(max, line.getWidth());
        }
        return max;
    }

    public static float getHeight(TextSequence textSequence, float maxWidth, float lineSpacing, boolean applyLineSpacingToFirstLine) throws IOException {
        List<TextLine> lines = TextSequenceUtil.wordWrapToLines(textSequence, maxWidth);
        float sum = 0.0f;
        for (int i2 = 0; i2 < lines.size(); ++i2) {
            boolean applyLineSpacing = i2 > 0 || applyLineSpacingToFirstLine;
            TextLine line = lines.get(i2);
            float lineHeight = line.getHeight();
            if (applyLineSpacing) {
                lineHeight *= lineSpacing;
            }
            sum += lineHeight;
        }
        return sum;
    }

    private static class WordWrapContext {
        private TextFragment word;
        private float lineLength;
        private float indentation;
        boolean isWrappedLine;

        public WordWrapContext(TextFragment word, float lineLength, float indentation, boolean isWrappedLine) {
            this.word = word;
            this.lineLength = lineLength;
            this.indentation = indentation;
            this.isWrappedLine = isWrappedLine;
        }

        public TextFragment getWord() {
            return this.word;
        }

        public float getLineLength() {
            return this.lineLength;
        }

        public float getIndentation() {
            return this.indentation;
        }

        public boolean isWrappedLine() {
            return this.isWrappedLine;
        }

        public boolean isMoreToWrap() {
            return this.getWord() != null;
        }
    }
}

