/*
 * Decompiled with CFR 0.152.
 */
package rst.pdfbox.layout.shape;

import java.io.IOException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import rst.pdfbox.layout.shape.AbstractShape;
import rst.pdfbox.layout.text.Position;
import rst.pdfbox.layout.util.CompatibilityHelper;

public class RoundRect
extends AbstractShape {
    private static final float BEZ = 0.55191505f;
    private final float cornerRadiusX;
    private final float cornerRadiusY;

    public RoundRect(float cornerRadius) {
        this(cornerRadius, cornerRadius);
    }

    public RoundRect(float cornerRadiusX, float cornerRadiusY) {
        this.cornerRadiusX = cornerRadiusX;
        this.cornerRadiusY = cornerRadiusY;
    }

    @Override
    public void add(PDDocument pdDocument, PDPageContentStream contentStream, Position upperLeft, float width, float height) throws IOException {
        this.addRoundRect(contentStream, upperLeft, width, height, this.cornerRadiusX, this.cornerRadiusY);
    }

    protected void addRoundRect(PDPageContentStream contentStream, Position upperLeft, float width, float height, float cornerRadiusX, float cornerRadiusY) throws IOException {
        float nettoWidth = width - 2.0f * cornerRadiusX;
        float nettoHeight = height - 2.0f * cornerRadiusY;
        Position a2 = new Position(upperLeft.getX() + cornerRadiusX, upperLeft.getY());
        Position b2 = new Position(a2.getX() + nettoWidth, a2.getY());
        Position c2 = new Position(upperLeft.getX() + width, upperLeft.getY() - cornerRadiusY);
        Position d2 = new Position(c2.getX(), c2.getY() - nettoHeight);
        Position e2 = new Position(upperLeft.getX() + width - cornerRadiusX, upperLeft.getY() - height);
        Position f2 = new Position(e2.getX() - nettoWidth, e2.getY());
        Position g2 = new Position(upperLeft.getX(), upperLeft.getY() - height + cornerRadiusY);
        Position h2 = new Position(g2.getX(), upperLeft.getY() - cornerRadiusY);
        float bezX = cornerRadiusX * 0.55191505f;
        float bezY = cornerRadiusY * 0.55191505f;
        contentStream.moveTo(a2.getX(), a2.getY());
        this.addLine(contentStream, a2.getX(), a2.getY(), b2.getX(), b2.getY());
        CompatibilityHelper.curveTo(contentStream, b2.getX() + bezX, b2.getY(), c2.getX(), c2.getY() + bezY, c2.getX(), c2.getY());
        this.addLine(contentStream, c2.getX(), c2.getY(), d2.getX(), d2.getY());
        CompatibilityHelper.curveTo(contentStream, d2.getX(), d2.getY() - bezY, e2.getX() + bezX, e2.getY(), e2.getX(), e2.getY());
        this.addLine(contentStream, e2.getX(), e2.getY(), f2.getX(), f2.getY());
        CompatibilityHelper.curveTo(contentStream, f2.getX() - bezX, f2.getY(), g2.getX(), g2.getY() - bezY, g2.getX(), g2.getY());
        this.addLine(contentStream, g2.getX(), g2.getY(), h2.getX(), h2.getY());
        CompatibilityHelper.curveTo(contentStream, h2.getX(), h2.getY() + bezY, a2.getX() - bezX, a2.getY(), a2.getX(), a2.getY());
    }

    private void addLine(PDPageContentStream contentStream, float x1, float y1, float x2, float y2) throws IOException {
        float xMid = (x1 + x2) / 2.0f;
        float yMid = (y1 + y2) / 2.0f;
        CompatibilityHelper.curveTo1(contentStream, xMid, yMid, x2, y2);
    }
}

