/*
 * Decompiled with CFR 0.152.
 */
package rst.pdfbox.layout.elements.render;

import java.io.IOException;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import rst.pdfbox.layout.elements.ControlElement;
import rst.pdfbox.layout.elements.Cutter;
import rst.pdfbox.layout.elements.Dividable;
import rst.pdfbox.layout.elements.Drawable;
import rst.pdfbox.layout.elements.Element;
import rst.pdfbox.layout.elements.PageFormat;
import rst.pdfbox.layout.elements.VerticalSpacer;
import rst.pdfbox.layout.elements.render.Layout;
import rst.pdfbox.layout.elements.render.LayoutHint;
import rst.pdfbox.layout.elements.render.RenderContext;
import rst.pdfbox.layout.elements.render.VerticalLayoutHint;
import rst.pdfbox.layout.text.Alignment;
import rst.pdfbox.layout.text.Position;
import rst.pdfbox.layout.text.WidthRespecting;
import rst.pdfbox.layout.util.CompatibilityHelper;

public class VerticalLayout
implements Layout {
    protected boolean removeLeadingEmptyVerticalSpace = true;

    public boolean isRemoveLeadingEmptyVerticalSpace() {
        return this.removeLeadingEmptyVerticalSpace;
    }

    public void setRemoveLeadingEmptyVerticalSpace(boolean removeLeadingEmptyLines) {
        this.removeLeadingEmptyVerticalSpace = removeLeadingEmptyLines;
    }

    protected void turnPage(RenderContext renderContext) throws IOException {
        renderContext.newPage();
    }

    protected float getTargetWidth(RenderContext renderContext) {
        float targetWidth = renderContext.getWidth();
        return targetWidth;
    }

    @Override
    public boolean render(RenderContext renderContext, Element element, LayoutHint layoutHint) throws IOException {
        if (element instanceof Drawable) {
            this.render(renderContext, (Drawable)((Object)element), layoutHint);
            return true;
        }
        if (element == ControlElement.NEWPAGE) {
            this.turnPage(renderContext);
            return true;
        }
        return false;
    }

    public void render(RenderContext renderContext, Drawable drawable, LayoutHint layoutHint) throws IOException {
        if (drawable.getAbsolutePosition() != null) {
            this.renderAbsolute(renderContext, drawable, layoutHint, drawable.getAbsolutePosition());
        } else {
            this.renderReleative(renderContext, drawable, layoutHint);
        }
    }

    protected void renderAbsolute(RenderContext renderContext, Drawable drawable, LayoutHint layoutHint, Position position) throws IOException {
        drawable.draw(renderContext.getPdDocument(), renderContext.getContentStream(), position, renderContext);
    }

    protected void renderReleative(RenderContext renderContext, Drawable drawable, LayoutHint layoutHint) throws IOException {
        VerticalLayoutHint verticalLayoutHint = null;
        if (layoutHint instanceof VerticalLayoutHint && (verticalLayoutHint = (VerticalLayoutHint)layoutHint).getMarginTop() > 0.0f) {
            this.layoutAndDrawReleative(renderContext, new VerticalSpacer(verticalLayoutHint.getMarginTop()), verticalLayoutHint);
        }
        this.layoutAndDrawReleative(renderContext, drawable, verticalLayoutHint);
        if (verticalLayoutHint != null && verticalLayoutHint.getMarginBottom() > 0.0f) {
            this.layoutAndDrawReleative(renderContext, new VerticalSpacer(verticalLayoutHint.getMarginBottom()), verticalLayoutHint);
        }
    }

    protected void layoutAndDrawReleative(RenderContext renderContext, Drawable drawable, LayoutHint layoutHint) throws IOException {
        WidthRespecting flowing;
        float targetWidth = this.getTargetWidth(renderContext);
        boolean movePosition = true;
        VerticalLayoutHint verticalLayoutHint = null;
        if (layoutHint instanceof VerticalLayoutHint) {
            verticalLayoutHint = (VerticalLayoutHint)layoutHint;
            targetWidth -= verticalLayoutHint.getMarginLeft();
            targetWidth -= verticalLayoutHint.getMarginRight();
            movePosition = !verticalLayoutHint.isResetY();
        }
        float oldMaxWidth = -1.0f;
        if (drawable instanceof WidthRespecting && (oldMaxWidth = (flowing = (WidthRespecting)((Object)drawable)).getMaxWidth()) < 0.0f) {
            flowing.setMaxWidth(targetWidth);
        }
        Drawable drawablePart = this.removeLeadingEmptyVerticalSpace(drawable, renderContext);
        while (renderContext.getRemainingHeight() < drawablePart.getHeight()) {
            Dividable dividable = null;
            dividable = drawablePart instanceof Dividable ? (Dividable)((Object)drawablePart) : new Cutter(drawablePart);
            Dividable.Divided divided = dividable.divide(renderContext.getRemainingHeight(), renderContext.getHeight());
            this.drawReletivePartAndMovePosition(renderContext, divided.getFirst(), layoutHint, true);
            this.turnPage(renderContext);
            drawablePart = divided.getTail();
            drawablePart = this.removeLeadingEmptyVerticalSpace(drawablePart, renderContext);
        }
        this.drawReletivePartAndMovePosition(renderContext, drawablePart, layoutHint, movePosition);
        if (drawable instanceof WidthRespecting && oldMaxWidth < 0.0f) {
            ((WidthRespecting)((Object)drawable)).setMaxWidth(oldMaxWidth);
        }
    }

    protected void drawReletivePartAndMovePosition(RenderContext renderContext, Drawable drawable, LayoutHint layoutHint, boolean movePosition) throws IOException {
        PDPageContentStream contentStream = renderContext.getContentStream();
        PageFormat pageFormat = renderContext.getPageFormat();
        float offsetX = 0.0f;
        if (layoutHint instanceof VerticalLayoutHint) {
            VerticalLayoutHint verticalLayoutHint = (VerticalLayoutHint)layoutHint;
            Alignment alignment = verticalLayoutHint.getAlignment();
            float horizontalExtraSpace = this.getTargetWidth(renderContext) - drawable.getWidth();
            switch (alignment) {
                case Right: {
                    offsetX = horizontalExtraSpace - verticalLayoutHint.getMarginRight();
                    break;
                }
                case Center: {
                    offsetX = horizontalExtraSpace / 2.0f;
                    break;
                }
                default: {
                    offsetX = verticalLayoutHint.getMarginLeft();
                }
            }
        }
        contentStream.saveGraphicsState();
        contentStream.addRect(0.0f, pageFormat.getMarginBottom(), renderContext.getPageWidth(), renderContext.getHeight());
        CompatibilityHelper.clip(contentStream);
        drawable.draw(renderContext.getPdDocument(), contentStream, renderContext.getCurrentPosition().add(offsetX, 0.0f), renderContext);
        contentStream.restoreGraphicsState();
        if (movePosition) {
            renderContext.movePositionBy(0.0f, -drawable.getHeight());
        }
    }

    protected boolean isPositionTopOfPage(RenderContext renderContext) {
        return renderContext.getCurrentPosition().getY() == renderContext.getUpperLeft().getY();
    }

    protected Drawable removeLeadingEmptyVerticalSpace(Drawable drawable, RenderContext renderContext) throws IOException {
        if (this.isRemoveLeadingEmptyVerticalSpace() && this.isPositionTopOfPage(renderContext)) {
            return drawable.removeLeadingEmptyVerticalSpace();
        }
        return drawable;
    }
}

