/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.util;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.snmp4j.PDU;
import org.snmp4j.Session;
import org.snmp4j.Target;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.event.ResponseListener;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.Null;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.util.AbstractSnmpUtility;
import org.snmp4j.util.PDUFactory;
import org.snmp4j.util.TreeEvent;
import org.snmp4j.util.TreeListener;

public class TreeUtils
extends AbstractSnmpUtility {
    private static final LogAdapter logger = LogFactory.getLogger(TreeUtils.class);
    private int maxRepetitions = 10;
    private boolean ignoreLexicographicOrder;

    public TreeUtils(Session snmpSession, PDUFactory pduFactory) {
        super(snmpSession, pduFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TreeEvent> getSubtree(Target<?> target, OID rootOID) {
        InternalTreeListener listener;
        LinkedList<TreeEvent> l2 = new LinkedList<TreeEvent>();
        InternalTreeListener internalTreeListener = listener = new InternalTreeListener(l2);
        synchronized (internalTreeListener) {
            OID[] rootOIDs = new OID[]{rootOID};
            this.walk(target, rootOIDs, null, listener);
            try {
                if (!listener.isFinished()) {
                    listener.wait();
                }
            }
            catch (InterruptedException ex) {
                logger.warn((Serializable)((Object)("Tree retrieval interrupted: " + ex.getMessage())));
            }
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TreeEvent> walk(Target<?> target, OID[] rootOIDs) {
        InternalTreeListener listener;
        LinkedList<TreeEvent> l2 = new LinkedList<TreeEvent>();
        InternalTreeListener internalTreeListener = listener = new InternalTreeListener(l2);
        synchronized (internalTreeListener) {
            this.walk(target, rootOIDs, null, listener);
            try {
                if (!listener.isFinished()) {
                    listener.wait();
                }
            }
            catch (InterruptedException ex) {
                logger.warn((Serializable)((Object)("Tree retrieval interrupted: " + ex.getMessage())));
            }
        }
        return l2;
    }

    public void getSubtree(Target<?> target, OID rootOID, Object userObject, TreeListener listener) {
        this.walk(target, new OID[]{rootOID}, userObject, listener);
    }

    public void walk(Target<?> target, OID[] rootOIDs, Object userObject, TreeListener listener) {
        PDU request = this.pduFactory.createPDU(target);
        for (OID oid : rootOIDs) {
            request.add(new VariableBinding(oid));
        }
        if (target.getVersion() == 0) {
            request.setType(-95);
        } else if (request.getType() != -95) {
            request.setType(-91);
            request.setMaxRepetitions(this.maxRepetitions);
        }
        TreeRequest treeRequest = new TreeRequest(listener, rootOIDs, target, userObject, request);
        treeRequest.send();
    }

    public void setMaxRepetitions(int maxRepetitions) {
        this.maxRepetitions = maxRepetitions;
    }

    public void setIgnoreLexicographicOrder(boolean ignoreLexicographicOrder) {
        this.ignoreLexicographicOrder = ignoreLexicographicOrder;
    }

    public int getMaxRepetitions() {
        return this.maxRepetitions;
    }

    public boolean isIgnoreLexicographicOrder() {
        return this.ignoreLexicographicOrder;
    }

    static class InternalTreeListener
    implements TreeListener {
        private final List<TreeEvent> collectedEvents;
        private volatile boolean finished = false;

        public InternalTreeListener(List<TreeEvent> eventList) {
            this.collectedEvents = eventList;
        }

        @Override
        public synchronized boolean next(TreeEvent event) {
            this.collectedEvents.add(event);
            return true;
        }

        @Override
        public synchronized void finished(TreeEvent event) {
            if (!this.finished) {
                this.collectedEvents.add(event);
                this.finished = true;
            }
            this.notify();
        }

        public List<TreeEvent> getCollectedEvents() {
            return this.collectedEvents;
        }

        @Override
        public boolean isFinished() {
            return this.finished;
        }
    }

    class TreeRequest
    implements ResponseListener {
        private final TreeListener listener;
        private final Object userObject;
        private final PDU request;
        private final OID[] rootOIDs;
        private final Target<?> target;

        public TreeRequest(TreeListener listener, OID[] rootOIDs, Target<?> target, Object userObject, PDU request) {
            this.listener = listener;
            this.userObject = userObject;
            this.request = request;
            this.rootOIDs = rootOIDs;
            this.target = target;
        }

        public void send() {
            try {
                TreeUtils.this.session.send(this.request, this.target, null, this);
            }
            catch (IOException iox) {
                this.listener.finished(new TreeEvent(this, this.userObject, iox));
            }
        }

        @Override
        public <A extends Address> void onResponse(ResponseEvent<A> event) {
            TreeUtils.this.session.cancel(event.getRequest(), this);
            PDU respPDU = event.getResponse();
            if (respPDU == null) {
                this.listener.finished(new TreeEvent(this, this.userObject, -1));
            } else if (respPDU.getErrorStatus() != 0) {
                if (this.target.getVersion() == 0 && respPDU.getErrorStatus() == 2) {
                    this.listener.finished(new TreeEvent(this, this.userObject, new VariableBinding[0]));
                } else {
                    this.listener.finished(new TreeEvent(this, this.userObject, respPDU.getErrorStatus()));
                }
            } else if (respPDU.getType() == -88) {
                this.listener.finished(new TreeEvent(this, this.userObject, respPDU));
            } else {
                ArrayList<VariableBinding> l2 = new ArrayList<VariableBinding>(respPDU.size());
                ArrayList<OID> lastOIDs = null;
                if (!TreeUtils.this.ignoreLexicographicOrder) {
                    lastOIDs = new ArrayList<OID>(this.request.size());
                    for (int i2 = 0; i2 < this.request.size(); ++i2) {
                        lastOIDs.add(this.request.get(i2).getOid());
                    }
                }
                boolean finished = false;
                for (int i3 = 0; !(finished && i3 % this.rootOIDs.length <= 0 || i3 >= respPDU.size()); ++i3) {
                    int r2 = i3 % this.rootOIDs.length;
                    VariableBinding vb = respPDU.get(i3);
                    if (vb.getOid() == null || vb.getOid().size() < this.rootOIDs[r2].size() || this.rootOIDs[r2].leftMostCompare(this.rootOIDs[r2].size(), vb.getOid()) != 0) {
                        finished = true;
                    } else if (Null.isExceptionSyntax(vb.getVariable().getSyntax())) {
                        finished = true;
                    } else {
                        if (!TreeUtils.this.ignoreLexicographicOrder && lastOIDs != null && vb.getOid().compareTo((Variable)lastOIDs.get(r2)) <= 0) {
                            this.listener.finished(new TreeEvent(this, this.userObject, -2));
                            finished = true;
                            break;
                        }
                        finished = false;
                        if (lastOIDs != null) {
                            lastOIDs.set(r2, vb.getOid());
                        }
                        l2.add(vb);
                    }
                    if (this.rootOIDs.length <= 1 || (i3 + 1) % this.rootOIDs.length != 0) continue;
                    VariableBinding[] vbs = l2.toArray(new VariableBinding[0]);
                    this.listener.next(new TreeEvent(this, this.userObject, vbs));
                    l2.clear();
                }
                if (respPDU.size() == 0) {
                    finished = true;
                }
                VariableBinding[] vbs = l2.toArray(new VariableBinding[0]);
                if (finished) {
                    this.listener.finished(new TreeEvent(this, this.userObject, vbs));
                } else if (this.listener.next(new TreeEvent(this, this.userObject, vbs))) {
                    int lastRowIndex = (respPDU.size() / this.rootOIDs.length - 1) * this.rootOIDs.length;
                    this.request.clear();
                    for (int i4 = Math.max(0, lastRowIndex); i4 < lastRowIndex + this.rootOIDs.length; ++i4) {
                        VariableBinding next = (VariableBinding)respPDU.get(i4).clone();
                        next.setVariable(new Null());
                        this.request.add(next);
                    }
                    if (this.request.size() > 0) {
                        this.send();
                    } else {
                        this.listener.finished(new TreeEvent(this, this.userObject, new VariableBinding[0]));
                    }
                } else {
                    this.listener.finished(new TreeEvent(this, this.userObject, vbs));
                }
            }
        }
    }
}

