/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.util;

import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.snmp4j.smi.OID;
import org.snmp4j.util.SimpleOIDTextFormat;

public class DictionaryOIDTextFormat
extends SimpleOIDTextFormat {
    private final Map<String, OID> nameToOidMap = new HashMap<String, OID>();
    private final TreeMap<OID, String> oidToNameMap = new TreeMap();

    public DictionaryOIDTextFormat() {
    }

    public DictionaryOIDTextFormat(String ... objectNameToDottedNumbers) {
        for (String mapping : objectNameToDottedNumbers) {
            this.put(mapping);
        }
    }

    public OID put(String objectName, String dottedNumbersOidString) {
        OID oid = null;
        try {
            oid = new OID(SimpleOIDTextFormat.parseOID(dottedNumbersOidString));
            this.nameToOidMap.put(objectName, oid);
            this.oidToNameMap.put(oid, objectName);
            return oid;
        }
        catch (ParseException e2) {
            return null;
        }
    }

    public OID put(String objectNameEqualsDottedNumberString) {
        int equalsPos = objectNameEqualsDottedNumberString.indexOf(61);
        return this.put(objectNameEqualsDottedNumberString.substring(0, equalsPos).trim(), objectNameEqualsDottedNumberString.substring(equalsPos + 1).trim());
    }

    public int size() {
        return this.nameToOidMap.size();
    }

    @Override
    public String format(int[] value) {
        if (value == null) {
            return null;
        }
        OID oid = new OID(value);
        String name = this.oidToNameMap.get(oid);
        if (name != null) {
            return name;
        }
        OID floorKey = this.oidToNameMap.floorKey(oid);
        while (floorKey != null) {
            if (oid.startsWith(floorKey) && (name = this.oidToNameMap.get(floorKey)) != null) {
                return name + "." + SimpleOIDTextFormat.formatOID(oid.subOID(floorKey.size()).getValue());
            }
            floorKey = this.oidToNameMap.floorKey(floorKey.trim());
        }
        return super.format(value);
    }

    @Override
    public int[] parse(String text) throws ParseException {
        if (text == null) {
            return null;
        }
        if (text.length() > 0 && !Character.isDigit(text.charAt(0))) {
            OID oid;
            int dotPos = text.indexOf(46);
            if (dotPos > 0) {
                String name = text.substring(0, dotPos);
                oid = this.nameToOidMap.get(name);
                if (oid != null) {
                    return new OID(oid.getValue(), super.parse(text.substring(dotPos + 1))).getValue();
                }
            } else {
                oid = this.nameToOidMap.get(text);
            }
            if (oid != null) {
                return oid.getValue();
            }
            return null;
        }
        return super.parse(text);
    }
}

