/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.transport.tls;

import java.io.Serializable;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.snmp4j.TransportStateReference;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.transport.tls.SSLEngineConfigurator;
import org.snmp4j.transport.tls.TLSTMTrustManagerFactory;
import org.snmp4j.transport.tls.TLSTMUtil;
import org.snmp4j.transport.tls.TlsTransportMappingConfig;
import org.snmp4j.transport.tls.X509TlsTransportMappingConfig;

public class DefaultSSLEngineConfiguration
implements SSLEngineConfigurator {
    private static final LogAdapter logger = LogFactory.getLogger(DefaultSSLEngineConfiguration.class);
    private final X509TlsTransportMappingConfig tlsTransportMappingConfig;
    private final TLSTMTrustManagerFactory trustManagerFactory;
    private final String defaultProtocolVersion;

    public DefaultSSLEngineConfiguration(X509TlsTransportMappingConfig tlsTransportMappingConfig, TLSTMTrustManagerFactory trustManagerFactory, String defaultProtocolVersion) {
        this.tlsTransportMappingConfig = tlsTransportMappingConfig;
        this.trustManagerFactory = trustManagerFactory;
        this.defaultProtocolVersion = defaultProtocolVersion;
    }

    public String getDefaultProtocolVersion() {
        return this.defaultProtocolVersion;
    }

    public TlsTransportMappingConfig<X509Certificate> getTlsTransportMappingConfig() {
        return this.tlsTransportMappingConfig;
    }

    public TLSTMTrustManagerFactory getTrustManagerFactory() {
        return this.trustManagerFactory;
    }

    @Override
    public void configure(SSLEngine sslEngine) {
        logger.debug((Serializable)((Object)("Configuring SSL engine, supported protocols are " + Arrays.asList(sslEngine.getSupportedProtocols()) + ", supported ciphers are " + Arrays.asList(sslEngine.getSupportedCipherSuites()) + ", https defaults are " + System.getProperty("https.cipherSuites"))));
        String[] supportedCipherSuites = sslEngine.getEnabledCipherSuites();
        ArrayList<String> enabledCipherSuites = new ArrayList<String>(supportedCipherSuites.length);
        for (String cs : supportedCipherSuites) {
            if (cs.contains("_anon_") || cs.contains("_NULL_")) continue;
            enabledCipherSuites.add(cs);
        }
        sslEngine.setEnabledCipherSuites(enabledCipherSuites.toArray(new String[0]));
        sslEngine.setEnabledProtocols(this.tlsTransportMappingConfig.getProtocolVersions());
        if (!sslEngine.getUseClientMode()) {
            sslEngine.setNeedClientAuth(true);
            sslEngine.setWantClientAuth(true);
            logger.info("Need client authentication set to true");
        }
        if (logger.isInfoEnabled()) {
            logger.info("Configured SSL engine, enabled protocols are " + Arrays.asList(sslEngine.getEnabledProtocols()) + ", enabled ciphers are " + Arrays.asList(sslEngine.getEnabledCipherSuites()) + ", supported ciphers are " + Arrays.asList(sslEngine.getSupportedCipherSuites()));
        }
    }

    @Override
    public SSLContext getSSLContext(boolean useClientMode, TransportStateReference transportStateReference) throws GeneralSecurityException {
        try {
            String protocol = this.defaultProtocolVersion;
            if (this.tlsTransportMappingConfig.getProtocolVersions() != null && this.tlsTransportMappingConfig.getProtocolVersions().length > 0) {
                protocol = this.tlsTransportMappingConfig.getProtocolVersions()[0];
            }
            return TLSTMUtil.createSSLContext(protocol, this.tlsTransportMappingConfig.getKeyStore(), this.tlsTransportMappingConfig.getKeyStorePassword(), this.tlsTransportMappingConfig.getTrustStore(), this.tlsTransportMappingConfig.getTrustStorePassword(), transportStateReference, this.trustManagerFactory, useClientMode, this.tlsTransportMappingConfig.getSecurityCallback(), this.tlsTransportMappingConfig.getLocalCertificateAlias(), this.tlsTransportMappingConfig.getPKIXRevocationChecker(), this.tlsTransportMappingConfig.getX509CertificateRevocationListURI());
        }
        catch (NoSuchAlgorithmException e2) {
            logger.error("Failed to initialize SSLContext because of an NoSuchAlgorithmException: " + e2.getMessage(), e2);
            return null;
        }
    }
}

