/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.transport;

import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ProtocolFamily;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.PKIXRevocationChecker;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.LinkedList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.X509TrustManager;
import org.snmp4j.SNMP4JSettings;
import org.snmp4j.TransportStateReference;
import org.snmp4j.asn1.BER;
import org.snmp4j.asn1.BERInputStream;
import org.snmp4j.event.CounterEvent;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.mp.CounterSupport;
import org.snmp4j.mp.SnmpConstants;
import org.snmp4j.security.SecurityLevel;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TcpAddress;
import org.snmp4j.smi.TlsAddress;
import org.snmp4j.transport.AbstractSocketEntry;
import org.snmp4j.transport.AbstractTransportServerThread;
import org.snmp4j.transport.MessageLengthDecoder;
import org.snmp4j.transport.SocketTimeout;
import org.snmp4j.transport.TcpTransportMapping;
import org.snmp4j.transport.TransportStateEvent;
import org.snmp4j.transport.TransportType;
import org.snmp4j.transport.tls.DefaultSSLEngineConfiguration;
import org.snmp4j.transport.tls.SSLEngineConfigurator;
import org.snmp4j.transport.tls.TLSTMExtendedTrustManager;
import org.snmp4j.transport.tls.TLSTMTrustManagerFactory;
import org.snmp4j.transport.tls.TlsTmSecurityCallback;
import org.snmp4j.transport.tls.TlsTmSecurityCallbackProxy;
import org.snmp4j.transport.tls.X509TlsTransportMappingConfig;
import org.snmp4j.util.WorkerTask;

public class TLSTM
extends TcpTransportMapping<SocketEntry>
implements X509TlsTransportMappingConfig {
    private static final LogAdapter logger = LogFactory.getLogger(TLSTM.class);
    public static final int TLS_MAX_FRAGMENT_SIZE = 16384;
    private WorkerTask server;
    private ServerThread serverThread;
    private long nextSessionID = 1L;
    private SSLEngineConfigurator sslEngineConfigurator;
    private final TlsTmSecurityCallbackProxy<X509Certificate> securityCallback = new TlsTmSecurityCallbackProxy();
    private CounterSupport counterSupport;
    public static final String DEFAULT_TLSTM_PROTOCOLS = "TLSv1.2";
    public static final int MAX_TLS_PAYLOAD_SIZE = 32768;
    private String localCertificateAlias;
    private String keyStore;
    private String keyStorePassword;
    private String trustStore;
    private String trustStorePassword;
    private String[] tlsProtocols;
    private TLSTMTrustManagerFactory trustManagerFactory = new DefaultTLSTMTrustManagerFactory();
    private int tlsMaxFragmentSize;
    private PKIXRevocationChecker pkixRevocationChecker;
    private String x509CertificateRevocationListURI;

    public TLSTM() throws UnknownHostException {
        super(new TlsAddress(InetAddress.getLocalHost(), 0));
        this.counterSupport = CounterSupport.getInstance();
        this.maxInboundMessageSize = 32768;
        this.tlsMaxFragmentSize = 16384;
    }

    public TLSTM(TlsAddress address) throws IOException {
        this(address, true);
    }

    public TLSTM(TlsAddress address, boolean serverEnabled) throws IOException {
        super(address);
        this.maxInboundMessageSize = 32768;
        this.serverEnabled = serverEnabled;
        this.counterSupport = CounterSupport.getInstance();
        this.tlsMaxFragmentSize = 16384;
        this.setupTrustManagerFactory();
    }

    private void setupTrustManagerFactory() throws IOException {
        try {
            if (Class.forName("javax.net.ssl.X509ExtendedTrustManager") != null) {
                Class<?> trustManagerFactoryClass = Class.forName("org.snmp4j.transport.tls.TLSTMExtendedTrustManagerFactory");
                Constructor<?> c2 = trustManagerFactoryClass.getConstructors()[0];
                TLSTMTrustManagerFactory trustManagerFactory = (TLSTMTrustManagerFactory)c2.newInstance(CounterSupport.getInstance(), this.securityCallback);
                this.setTrustManagerFactory(trustManagerFactory);
            }
        }
        catch (ClassNotFoundException trustManagerFactoryClass) {
        }
        catch (InvocationTargetException ex) {
            throw new IOException("Failed to init TLSTMTrustManagerFactory: " + ex.getMessage(), ex);
        }
        catch (IllegalArgumentException ex) {
            throw new IOException("Failed to setup TLSTMTrustManagerFactory: " + ex.getMessage(), ex);
        }
        catch (IllegalAccessException ex) {
            throw new IOException("Failed to access TLSTMTrustManagerFactory: " + ex.getMessage(), ex);
        }
        catch (InstantiationException ex) {
            throw new IOException("Failed to instantiate TLSTMTrustManagerFactory: " + ex.getMessage(), ex);
        }
    }

    public TLSTM(TlsTmSecurityCallback<X509Certificate> securityCallback, TlsAddress serverAddress) throws IOException {
        this(securityCallback, serverAddress, CounterSupport.getInstance());
    }

    public TLSTM(TlsTmSecurityCallback<X509Certificate> securityCallback, TlsAddress serverAddress, CounterSupport counterSupport) throws IOException {
        this(securityCallback, serverAddress, counterSupport, true);
    }

    public TLSTM(TlsTmSecurityCallback<X509Certificate> securityCallback, TlsAddress serverAddress, CounterSupport counterSupport, boolean serverEnabled) throws IOException {
        this(serverAddress, serverEnabled);
        this.maxInboundMessageSize = 32768;
        this.securityCallback.setTlsTmSecurityCallback(securityCallback);
        this.counterSupport = counterSupport;
    }

    @Override
    public String getLocalCertificateAlias() {
        if (this.localCertificateAlias == null) {
            return System.getProperty("org.snmp4j.arg.tlsLocalID", null);
        }
        return this.localCertificateAlias;
    }

    @Override
    public TransportType getSupportedTransportType() {
        return this.isServerEnabled() ? TransportType.any : TransportType.sender;
    }

    public int getTlsMaxFragmentSize() {
        return this.tlsMaxFragmentSize;
    }

    public void setTlsMaxFragmentSize(int tlsMaxFragmentSize) {
        this.tlsMaxFragmentSize = tlsMaxFragmentSize;
    }

    @Deprecated
    public String[] getTlsProtocols() {
        return this.getProtocolVersions();
    }

    @Deprecated
    public void setTlsProtocols(String[] tlsProtocols) {
        this.setProtocolVersions(tlsProtocols);
    }

    @Override
    public void setProtocolVersions(String[] protocolVersions) {
        this.tlsProtocols = protocolVersions;
    }

    @Override
    public String[] getProtocolVersions() {
        if (this.tlsProtocols == null) {
            String s2 = System.getProperty(this.getProtocolVersionPropertyName(), DEFAULT_TLSTM_PROTOCOLS);
            return s2.split(",");
        }
        return this.tlsProtocols;
    }

    @Override
    public String getProtocolVersionPropertyName() {
        return "org.snmp4j.arg.tlsVersion";
    }

    @Override
    public String getKeyStore() {
        if (this.keyStore == null) {
            return System.getProperty("javax.net.ssl.keyStore");
        }
        return this.keyStore;
    }

    @Override
    public void setKeyStore(String keyStore) {
        this.keyStore = keyStore;
    }

    @Override
    public String getKeyStorePassword() {
        if (this.keyStorePassword == null) {
            return System.getProperty("javax.net.ssl.keyStorePassword");
        }
        return this.keyStorePassword;
    }

    @Override
    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    @Override
    public String getTrustStore() {
        if (this.trustStore == null) {
            return System.getProperty("javax.net.ssl.trustStore");
        }
        return this.trustStore;
    }

    @Override
    public void setTrustStore(String trustStore) {
        this.trustStore = trustStore;
    }

    @Override
    public String getTrustStorePassword() {
        if (this.trustStorePassword == null) {
            return System.getProperty("javax.net.ssl.trustStorePassword");
        }
        return this.trustStorePassword;
    }

    @Override
    public void setTrustStorePassword(String trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
    }

    @Override
    public void setLocalCertificateAlias(String localCertificateAlias) {
        this.localCertificateAlias = localCertificateAlias;
    }

    public CounterSupport getCounterSupport() {
        return this.counterSupport;
    }

    @Override
    public Class<? extends Address> getSupportedAddressClass() {
        return TlsAddress.class;
    }

    @Override
    public TlsTmSecurityCallback<X509Certificate> getSecurityCallback() {
        return this.securityCallback.getTlsTmSecurityCallback();
    }

    @Override
    public void setSecurityCallback(TlsTmSecurityCallback<X509Certificate> securityCallback) {
        this.securityCallback.setTlsTmSecurityCallback(securityCallback);
    }

    public SSLEngineConfigurator getSslEngineConfigurator() {
        return this.sslEngineConfigurator;
    }

    public void setSslEngineConfigurator(SSLEngineConfigurator sslEngineConfigurator) {
        this.sslEngineConfigurator = sslEngineConfigurator;
    }

    public TLSTMTrustManagerFactory getTrustManagerFactory() {
        return this.trustManagerFactory;
    }

    public void setTrustManagerFactory(TLSTMTrustManagerFactory trustManagerFactory) {
        if (trustManagerFactory == null) {
            throw new NullPointerException();
        }
        this.trustManagerFactory = trustManagerFactory;
    }

    @Override
    public synchronized void listen() throws IOException {
        if (this.server != null) {
            throw new SocketException("Port already listening");
        }
        try {
            this.serverThread = new ServerThread();
            if (logger.isInfoEnabled()) {
                logger.info("TCP address " + this.tcpAddress + " bound successfully");
            }
        }
        catch (NoSuchAlgorithmException e2) {
            throw new IOException("SSL not available: " + e2.getMessage(), e2);
        }
        this.server = SNMP4JSettings.getThreadFactory().createWorkerThread("TLSTM_" + this.getListenAddress(), this.serverThread, true);
        if (this.connectionTimeout > 0L) {
            this.socketCleaner = SNMP4JSettings.getTimerFactory().createTimer();
        }
        this.server.run();
    }

    @Override
    public WorkerTask getListenWorkerTask() {
        return this.server;
    }

    @Override
    public void sendMessage(TcpAddress address, byte[] message, TransportStateReference tmStateReference, long timeoutMillis, int maxRetries) throws IOException {
        if (this.server == null || this.serverThread == null) {
            if (this.isOpenSocketOnSending()) {
                this.listen();
            } else {
                this.handleDroppedMessageToSend(address, message, tmStateReference, timeoutMillis, maxRetries);
            }
        }
        if (this.serverThread != null) {
            if (this.suspendedAddresses.size() > 0 && this.suspendedAddresses.contains(address)) {
                this.handleDroppedMessageToSend(address, message, tmStateReference, timeoutMillis, maxRetries);
            } else {
                this.serverThread.sendMessage(address, message, tmStateReference);
            }
        }
    }

    @Override
    public long getConnectionTimeout() {
        return this.connectionTimeout;
    }

    @Override
    public void setConnectionTimeout(long connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    @Override
    public void wakeupServerSelector() {
        this.serverThread.selector.wakeup();
    }

    @Override
    public MessageLengthDecoder getMessageLengthDecoder() {
        return null;
    }

    @Override
    public void setMessageLengthDecoder(MessageLengthDecoder messageLengthDecoder) {
    }

    public void setMaxInboundMessageSize(int maxInboundMessageSize) {
        this.maxInboundMessageSize = maxInboundMessageSize;
    }

    @Override
    public PKIXRevocationChecker getPKIXRevocationChecker() {
        return this.pkixRevocationChecker;
    }

    @Override
    public void setPKIXRevocationChecker(PKIXRevocationChecker pkixRevocationChecker) {
        this.pkixRevocationChecker = pkixRevocationChecker;
    }

    @Override
    public String getX509CertificateRevocationListURI() {
        return this.x509CertificateRevocationListURI;
    }

    @Override
    public void setX09CertificateRevocationListURI(String crlURI) {
        this.x509CertificateRevocationListURI = crlURI;
    }

    private synchronized void timeoutSocket(SocketEntry entry) {
        if (this.connectionTimeout > 0L) {
            SocketTimeout<TcpAddress> socketTimeout = new SocketTimeout<TcpAddress>(this, entry);
            entry.setSocketTimeout(socketTimeout);
            this.getSocketCleaner().schedule(socketTimeout, this.connectionTimeout);
        }
    }

    @Override
    public boolean isListening() {
        return this.server != null;
    }

    @Override
    public TcpAddress getListenAddress() {
        int port;
        block2: {
            port = this.tcpAddress.getPort();
            ServerThread serverThreadCopy = this.serverThread;
            try {
                port = serverThreadCopy.ssc.socket().getLocalPort();
            }
            catch (NullPointerException npe) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug((Serializable)((Object)"TLSTM.getListenAddress called but TLSTM is not listening yet"));
            }
        }
        return new TlsAddress(this.tcpAddress.getInetAddress(), port);
    }

    protected static boolean isEngineClosed(SSLEngine engine) {
        return engine.isOutboundDone() && engine.isInboundDone();
    }

    protected SSLEngineConfigurator ensureSslEngineConfigurator() {
        if (this.sslEngineConfigurator == null) {
            this.sslEngineConfigurator = new DefaultSSLEngineConfiguration(this, this.trustManagerFactory, DEFAULT_TLSTM_PROTOCOLS);
        }
        return this.sslEngineConfigurator;
    }

    void writeNetBuffer(SocketEntry entry, SocketChannel sc) throws IOException {
        entry.outNetBuffer.flip();
        while (entry.outNetBuffer.hasRemaining()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("Writing TLS outNetBuffer(PAYLOAD): " + entry.outNetBuffer)));
            }
            int num = sc.write(entry.outNetBuffer);
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("Wrote TLS " + num + " bytes from outNetBuffer(PAYLOAD)")));
            }
            if (num == -1) {
                throw new IOException("TLS connection closed");
            }
            if (num != 0) continue;
            entry.outNetBuffer.compact();
            return;
        }
        entry.outNetBuffer.clear();
    }

    private boolean matchingStateReferences(TransportStateReference tmStateReferenceNew, TransportStateReference tmStateReferenceExisting) {
        if (tmStateReferenceNew == null && tmStateReferenceExisting == null) {
            return true;
        }
        if (tmStateReferenceNew == null || tmStateReferenceExisting == null) {
            logger.error((Serializable)((Object)("Failed to compare TransportStateReferences refNew=" + tmStateReferenceNew + ",refOld=" + tmStateReferenceExisting)));
            return false;
        }
        if (tmStateReferenceNew.getSecurityName() == null && tmStateReferenceExisting.getSecurityName() == null) {
            return true;
        }
        if (tmStateReferenceNew.getSecurityName() == null || tmStateReferenceExisting.getSecurityName() == null) {
            logger.error((Serializable)((Object)("Could not match TransportStateReferences refNew=" + tmStateReferenceNew + ",refOld=" + tmStateReferenceExisting)));
            return false;
        }
        return tmStateReferenceNew.getSecurityName().equals(tmStateReferenceExisting.getSecurityName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SSLEngineResult sendNetMessage(SocketEntry entry) throws IOException {
        SSLEngineResult result;
        Object object = entry.outboundLock;
        synchronized (object) {
            if (!entry.outNetBuffer.hasRemaining()) {
                return null;
            }
            result = entry.sslEngine.wrap(ByteBuffer.allocate(0), entry.outNetBuffer);
            entry.outNetBuffer.flip();
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("TLS outNetBuffer = " + entry.outNetBuffer)));
            }
            entry.getSocketChannel().write(entry.outNetBuffer);
            entry.outNetBuffer.clear();
        }
        return result;
    }

    private void adjustInNetBuffer(SocketEntry entry, SSLEngineResult result) {
        if (result.getStatus() == SSLEngineResult.Status.OK) {
            if (result.bytesConsumed() == entry.inNetBuffer.limit()) {
                entry.inNetBuffer.clear();
            } else if (result.bytesConsumed() > 0) {
                entry.inNetBuffer.compact();
            }
        }
    }

    class SocketEntry
    extends AbstractSocketEntry<TcpAddress> {
        private final LinkedList<byte[]> message;
        private ByteBuffer inNetBuffer;
        private ByteBuffer inAppBuffer;
        private ByteBuffer outAppBuffer;
        private ByteBuffer outNetBuffer;
        private final SSLEngine sslEngine;
        private final long sessionID;
        private TransportStateReference tmStateReference;
        private boolean handshakeFinished;
        private final Object outboundLock;
        private final Object inboundLock;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SocketEntry(TcpAddress address, SocketChannel socketChannel, boolean useClientMode, TransportStateReference tmStateReference) throws GeneralSecurityException {
            super(address, socketChannel);
            this.message = new LinkedList();
            this.outboundLock = new Object();
            this.inboundLock = new Object();
            this.inAppBuffer = ByteBuffer.allocate(TLSTM.this.getMaxInboundMessageSize());
            this.inNetBuffer = ByteBuffer.allocate(TLSTM.this.getMaxInboundMessageSize());
            this.outNetBuffer = ByteBuffer.allocate(TLSTM.this.getMaxOutboundMessageSize());
            this.tmStateReference = tmStateReference;
            if (tmStateReference == null) {
                TLSTM.this.counterSupport.fireIncrementCounter(new CounterEvent(this, SnmpConstants.snmpTlstmSessionAccepts));
            }
            SSLEngineConfigurator sslEngineConfigurator = TLSTM.this.ensureSslEngineConfigurator();
            SSLContext sslContext = sslEngineConfigurator.getSSLContext(useClientMode, tmStateReference);
            this.sslEngine = sslContext.createSSLEngine(address.getInetAddress().getHostName(), address.getPort());
            this.sslEngine.setUseClientMode(useClientMode);
            sslEngineConfigurator.configure(this.sslEngine);
            TLSTM tLSTM = TLSTM.this;
            synchronized (tLSTM) {
                this.sessionID = TLSTM.this.nextSessionID++;
            }
        }

        @Override
        public synchronized void addMessage(byte[] message) {
            this.message.add(message);
        }

        @Override
        public synchronized byte[] nextMessage() {
            if (this.message.size() > 0) {
                return this.message.removeFirst();
            }
            return null;
        }

        @Override
        public synchronized boolean hasMessage() {
            return !this.message.isEmpty();
        }

        @Override
        public void setSocketTimeout(SocketTimeout<TcpAddress> socketTimeout) {
        }

        public void setInNetBuffer(ByteBuffer byteBuffer) {
            this.inNetBuffer = byteBuffer;
        }

        public ByteBuffer getInNetBuffer() {
            return this.inNetBuffer;
        }

        public ByteBuffer getOutNetBuffer() {
            return this.outNetBuffer;
        }

        public void setOutNetBuffer(ByteBuffer outNetBuffer) {
            this.outNetBuffer = outNetBuffer;
        }

        @Override
        public String toString() {
            return "SocketEntry[peerAddress=" + this.getPeerAddress() + ",socketChannel=" + this.socketChannel + ",lastUse=" + new Date(this.getLastUse() / 1000000L) + ",inNetBuffer=" + this.inNetBuffer + ",inAppBuffer=" + this.inAppBuffer + ",outAppBuffer=" + this.outAppBuffer + ",outNetBuffer=" + this.outNetBuffer + ",socketTimeout=" + this.getSocketTimeout() + "]";
        }

        public void checkTransportStateReference() {
            if (this.tmStateReference == null) {
                this.tmStateReference = new TransportStateReference(TLSTM.this, (Address)this.getPeerAddress(), new OctetString(), SecurityLevel.authPriv, SecurityLevel.authPriv, true, this.sessionID);
                OctetString securityName = null;
                try {
                    securityName = TLSTM.this.securityCallback.getSecurityName((X509Certificate[])this.sslEngine.getSession().getPeerCertificates());
                }
                catch (SSLPeerUnverifiedException e2) {
                    logger.error("SSL peer '" + this.getPeerAddress() + "' is not verified: " + e2.getMessage(), e2);
                    this.sslEngine.setEnableSessionCreation(false);
                }
                this.tmStateReference.setSecurityName(securityName);
            } else if (this.tmStateReference.getTransportSecurityLevel().equals((Object)SecurityLevel.undefined)) {
                this.tmStateReference.setTransportSecurityLevel(SecurityLevel.authPriv);
            }
        }

        public void setInAppBuffer(ByteBuffer inAppBuffer) {
            this.inAppBuffer = inAppBuffer;
        }

        public ByteBuffer getInAppBuffer() {
            return this.inAppBuffer;
        }

        @Override
        public boolean isHandshakeFinished() {
            return this.handshakeFinished;
        }

        @Override
        public void setHandshakeFinished(boolean handshakeFinished) {
            this.handshakeFinished = handshakeFinished;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isAppOutPending() {
            Object object = this.outboundLock;
            synchronized (object) {
                return this.outAppBuffer != null && this.outAppBuffer.limit() > 0;
            }
        }

        @Override
        public Object getSessionID() {
            return this.sessionID;
        }

        @Override
        public void closeSession() {
            block4: {
                if (logger.isInfoEnabled()) {
                    logger.info("Closing TLSTM session " + this.sessionID);
                }
                try {
                    SSLEngineResult result;
                    this.sslEngine.closeOutbound();
                    TLSTM.this.counterSupport.fireIncrementCounter(new CounterEvent(this, SnmpConstants.snmpTlstmSessionServerCloses));
                    while ((result = TLSTM.this.sendNetMessage(this)) != null && result.getStatus() != SSLEngineResult.Status.CLOSED && result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_WRAP) {
                    }
                }
                catch (IOException e2) {
                    if (!logger.isDebugEnabled()) break block4;
                    logger.debug((Serializable)((Object)("IOException while closing outbound channel of " + this + ": " + e2.getMessage())));
                }
            }
        }
    }

    private class DefaultTLSTMTrustManagerFactory
    implements TLSTMTrustManagerFactory {
        private DefaultTLSTMTrustManagerFactory() {
        }

        @Override
        public X509TrustManager create(X509TrustManager trustManager, boolean useClientMode, TransportStateReference tmStateReference) {
            return new TLSTMExtendedTrustManager(TLSTM.this.counterSupport, TLSTM.this.securityCallback, trustManager, useClientMode, tmStateReference);
        }
    }

    class ServerThread
    extends AbstractTransportServerThread<TcpAddress, SocketEntry> {
        private final BlockingQueue<SocketEntry> outQueue;
        private final BlockingQueue<SocketEntry> inQueue;

        public ServerThread() throws IOException, NoSuchAlgorithmException {
            super(TLSTM.this, TLSTM.this.tcpAddress);
            this.outQueue = new LinkedBlockingQueue<SocketEntry>();
            this.inQueue = new LinkedBlockingQueue<SocketEntry>();
            if (TLSTM.this.isServerEnabled()) {
                this.ssc = ServerSocketChannel.open();
                this.ssc.configureBlocking(false);
                InetSocketAddress isa = new InetSocketAddress(TLSTM.this.tcpAddress.getInetAddress(), TLSTM.this.tcpAddress.getPort());
                TLSTM.this.setSocketOptions(this.ssc.socket());
                this.ssc.socket().bind(isa);
                this.ssc.register(this.selector, 16);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected synchronized void processQueues() {
            while (!this.outQueue.isEmpty() || !this.inQueue.isEmpty()) {
                SocketEntry entry;
                while (!this.outQueue.isEmpty()) {
                    entry = null;
                    try {
                        entry = this.outQueue.take();
                        SSLEngineResult result = TLSTM.this.sendNetMessage(entry);
                        if (result == null || !this.runDelegatedTasks(result, entry) || !entry.isAppOutPending()) continue;
                        this.writeMessage(entry, entry.getSocketChannel());
                    }
                    catch (IOException iox) {
                        logger.error("IO exception caught while SSL processing: " + iox.getMessage(), iox);
                        while (this.inQueue.remove(entry)) {
                        }
                    }
                    catch (InterruptedException e2) {
                        logger.error("SSL processing interrupted: " + e2.getMessage(), e2);
                        return;
                    }
                }
                while (!this.inQueue.isEmpty()) {
                    entry = null;
                    try {
                        entry = this.inQueue.take();
                        Object e2 = entry.inboundLock;
                        synchronized (e2) {
                            if (entry.getInNetBuffer().position() > 0) {
                                entry.inNetBuffer.flip();
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Serializable)((Object)("TLS inNetBuffer = " + entry.inNetBuffer)));
                                }
                                SSLEngineResult nextResult = entry.sslEngine.unwrap(entry.inNetBuffer, entry.inAppBuffer);
                                TLSTM.this.adjustInNetBuffer(entry, nextResult);
                                if (this.runDelegatedTasks(nextResult, entry)) {
                                    switch (nextResult.getStatus()) {
                                        case BUFFER_OVERFLOW: {
                                            break;
                                        }
                                        case OK: {
                                            if (entry.isAppOutPending()) {
                                                this.writeMessage(entry, entry.getSocketChannel());
                                            }
                                            entry.inAppBuffer.flip();
                                            if (logger.isDebugEnabled()) {
                                                logger.debug((Serializable)((Object)("Dispatching inAppBuffer=" + entry.inAppBuffer)));
                                            }
                                            if (entry.inAppBuffer.limit() > 0) {
                                                this.dispatchMessage((TcpAddress)entry.getPeerAddress(), entry.inAppBuffer, entry.inAppBuffer.limit(), entry.sessionID, entry.tmStateReference);
                                            }
                                            entry.inAppBuffer.clear();
                                        }
                                    }
                                }
                            } else {
                                entry.addRegistration(this.selector, 1);
                            }
                        }
                    }
                    catch (IOException iox) {
                        logger.error("IO exception caught while SSL processing: " + iox.getMessage(), iox);
                        while (this.inQueue.remove(entry)) {
                        }
                        this.isConnectionClosed(entry, iox);
                    }
                    catch (InterruptedException e3) {
                        logger.error("SSL processing interrupted: " + e3.getMessage(), e3);
                        return;
                    }
                }
            }
        }

        private boolean isConnectionClosed(SocketEntry entry, IOException ioException) {
            if (TLSTM.isEngineClosed(entry.sslEngine)) {
                this.closeChannelAndRemoveSocket(entry, ioException);
                return true;
            }
            return false;
        }

        private void closeChannelAndRemoveSocket(SocketEntry entry, IOException ioException) {
            if (logger.isInfoEnabled()) {
                logger.info("TLS connection to " + entry.getPeerAddress() + " is closed");
            }
            this.closeChannel(entry.getSocketChannel());
            this.removeSocketEntry((TcpAddress)entry.getPeerAddress());
            TLSTM.this.fireConnectionStateChanged(new TransportStateEvent(TLSTM.this, (Address)entry.getPeerAddress(), 4, ioException));
        }

        @Override
        protected TcpAddress createIncomingAddress(SocketChannel sc) {
            Socket s2 = sc.socket();
            return new TcpAddress(s2.getInetAddress(), s2.getPort());
        }

        public boolean runDelegatedTasks(SSLEngineResult result, SocketEntry entry) throws IOException {
            SSLEngineResult.HandshakeStatus status;
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("Running delegated task on " + entry + ": " + result)));
            }
            if ((status = result.getHandshakeStatus()) == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                Runnable runnable;
                while ((runnable = entry.sslEngine.getDelegatedTask()) != null) {
                    logger.debug((Serializable)((Object)"Running delegated task..."));
                    runnable.run();
                }
                status = entry.sslEngine.getHandshakeStatus();
                if (status == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                    throw new IOException("Inconsistent Handshake status");
                }
                logger.info("Handshake status = " + status);
            }
            switch (result.getStatus()) {
                case BUFFER_UNDERFLOW: {
                    entry.inNetBuffer.position(entry.inNetBuffer.limit());
                    entry.inNetBuffer.limit(entry.inNetBuffer.capacity());
                    entry.addRegistration(this.selector, 1);
                    return false;
                }
                case CLOSED: {
                    entry.removeRegistration(this.selector, 1);
                    entry.removeRegistration(this.selector, 4);
                    entry.sslEngine.closeOutbound();
                    entry.sslEngine.closeInbound();
                    this.closeChannelAndRemoveSocket(entry, null);
                    return false;
                }
            }
            switch (status) {
                case NEED_WRAP: {
                    this.outQueue.add(entry);
                    break;
                }
                case NEED_UNWRAP: {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Serializable)((Object)("NEED_UNWRAP processing with inNetBuffer=" + entry.inNetBuffer)));
                    }
                    this.inQueue.add(entry);
                    entry.addRegistration(this.selector, 1);
                    return true;
                }
                case FINISHED: {
                    logger.debug((Serializable)((Object)"TLS handshake finished"));
                    entry.addRegistration(this.selector, 1);
                    entry.setHandshakeFinished(true);
                }
                case NOT_HANDSHAKING: {
                    if (result.bytesProduced() > 0 || entry.inNetBuffer.position() > 0) {
                        TLSTM.this.writeNetBuffer(entry, entry.getSocketChannel());
                    }
                    return true;
                }
                default: {
                    logger.warn((Serializable)((Object)("Unrecognized TLS result: " + status)));
                }
            }
            return false;
        }

        public Throwable getLastError() {
            return this.lastError;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sendMessage(TcpAddress address, byte[] message, TransportStateReference tmStateReference) throws IOException {
            AbstractInterruptibleChannel sc = null;
            SocketEntry entry = (SocketEntry)TLSTM.this.sockets.get(address);
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("Looking up connection for destination '" + address + "' returned: " + entry)));
                logger.debug((Serializable)((Object)TLSTM.this.sockets.toString()));
            }
            if (entry != null) {
                if (tmStateReference != null && tmStateReference.getSessionID() != null && !tmStateReference.getSessionID().equals(entry.getSessionID())) {
                    TLSTM.this.counterSupport.fireIncrementCounter(new CounterEvent(this, SnmpConstants.snmpTlstmSessionInvalidCaches));
                    String errmsg = "Session " + tmStateReference.getSessionID() + " not available";
                    if (logger.isDebugEnabled()) {
                        logger.debug((Serializable)((Object)errmsg));
                    }
                    throw new IOException(errmsg);
                }
                sc = entry.getSocketChannel();
            }
            if (sc == null || !sc.isOpen() || !((SocketChannel)sc).isConnected()) {
                if (tmStateReference != null && tmStateReference.isSameSecurity()) {
                    TLSTM.this.counterSupport.fireIncrementCounter(new CounterEvent(this, SnmpConstants.snmpTlstmSessionNoSessions));
                    throw new IOException("Session " + tmStateReference.getSessionID() + " not available");
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Serializable)((Object)("Socket for address '" + address + "' is closed, opening it...")));
                }
                if (entry != null) {
                    LinkedList errmsg = this.pending;
                    synchronized (errmsg) {
                        this.pending.remove(entry);
                    }
                }
                try {
                    SocketAddress targetAddress = address.getSocketAddress();
                    if (sc == null || !sc.isOpen()) {
                        sc = this.openSocketChannel(address.getFamily());
                        ((AbstractSelectableChannel)sc).configureBlocking(false);
                        ((SocketChannel)sc).connect(targetAddress);
                        TLSTM.this.counterSupport.fireIncrementCounter(new CounterEvent(this, SnmpConstants.snmpTlstmSessionOpens));
                    } else {
                        ((AbstractSelectableChannel)sc).configureBlocking(false);
                        if (!((SocketChannel)sc).isConnectionPending()) {
                            ((SocketChannel)sc).connect(targetAddress);
                            TLSTM.this.counterSupport.fireIncrementCounter(new CounterEvent(this, SnmpConstants.snmpTlstmSessionOpens));
                        } else {
                            if (TLSTM.this.matchingStateReferences(tmStateReference, entry.tmStateReference)) {
                                entry.addMessage(message);
                                LinkedList linkedList = this.pending;
                                synchronized (linkedList) {
                                    this.pending.add(entry);
                                }
                                this.selector.wakeup();
                                return;
                            }
                            logger.error((Serializable)((Object)("TransportStateReferences refNew=" + tmStateReference + ",refOld=" + entry.tmStateReference + " do not match, message dropped")));
                            throw new IOException("Transport state reference does not match existing reference for this session/target");
                        }
                    }
                    try {
                        entry = new SocketEntry(address, (SocketChannel)sc, true, tmStateReference);
                    }
                    catch (GeneralSecurityException gse) {
                        throw new IOException("Security exception while sending message to " + address + ": " + gse.getMessage(), gse);
                    }
                    entry.addMessage(message);
                    this.connectSocketToSendMessage(address, message, (SocketChannel)sc, entry, TLSTM.this.sockets);
                }
                catch (IOException iox) {
                    logger.error(iox);
                    throw iox;
                }
            }
            if (TLSTM.this.matchingStateReferences(tmStateReference, entry.tmStateReference)) {
                entry.addMessage(message);
                LinkedList linkedList = this.pending;
                synchronized (linkedList) {
                    this.pending.addFirst(entry);
                }
                logger.debug((Serializable)((Object)"Waking up selector for new message"));
                this.selector.wakeup();
            } else {
                logger.error((Serializable)((Object)("TransportStateReferences refNew=" + tmStateReference + ",refOld=" + entry.tmStateReference + " do not match, message dropped")));
                throw new IOException("Transport state reference does not match existing reference for this session/target");
            }
        }

        @Override
        public SocketEntry createSocketEntry(TcpAddress address, SocketChannel socketChannel, boolean useClientMode, TransportStateReference tmStateReference) {
            try {
                return new SocketEntry(address, socketChannel, useClientMode, tmStateReference);
            }
            catch (GeneralSecurityException gse) {
                logger.error("Failed to accept incoming connection from " + address + " because of a security exception: " + gse.getMessage(), gse);
                try {
                    socketChannel.close();
                }
                catch (IOException e2) {
                    logger.error((Serializable)((Object)("Failed to close socket channel " + socketChannel + " after security exception")));
                    throw new UncheckedIOException(e2);
                }
                return null;
            }
        }

        @Override
        protected SocketChannel openSocketChannel(ProtocolFamily family) throws IOException {
            return SocketChannel.open();
        }

        @Override
        public void run() {
            this.doServer(TLSTM.this.sockets);
        }

        @Override
        public SocketEntry removeSocketEntry(TcpAddress incomingAddress) {
            return (SocketEntry)TLSTM.this.sockets.remove(incomingAddress);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected boolean readMessage(SelectionKey sk, SocketChannel readChannel, TcpAddress incomingAddress, SocketEntry session) throws IOException {
            SocketEntry entry = (SocketEntry)sk.attachment();
            if (entry == null) {
                entry = session;
            }
            if (entry == null) {
                logger.error((Serializable)((Object)"SocketEntry null in readMessage"));
            }
            assert (entry != null);
            entry.used();
            ByteBuffer inNetBuffer = entry.getInNetBuffer();
            ByteBuffer inAppBuffer = entry.getInAppBuffer();
            try {
                long bytesRead = readChannel.read(inNetBuffer);
                if (logger.isDebugEnabled()) {
                    logger.debug((Serializable)((Object)("Read " + bytesRead + " bytes from " + incomingAddress)));
                    logger.debug((Serializable)((Object)("TLS inNetBuffer: " + inNetBuffer)));
                }
                if (bytesRead < 0L) {
                    logger.debug((Serializable)((Object)"Socket closed remotely"));
                    TLSTM.this.cancelNonServerSelectionKey(sk);
                    readChannel.close();
                    TransportStateEvent e2 = new TransportStateEvent(TLSTM.this, incomingAddress, 2, null);
                    TLSTM.this.fireConnectionStateChanged(e2);
                    return false;
                }
                if (bytesRead == 0L && entry.sslEngine.isInboundDone()) {
                    TLSTM.this.cancelNonServerSelectionKey(sk);
                    if (logger.isInfoEnabled()) {
                        logger.info("Inbound is done for " + entry + ", closing outbound and TLS session.");
                    }
                    entry.closeSession();
                    this.closeChannelAndRemoveSocket(entry, null);
                    return false;
                }
                if (bytesRead > 0L) {
                    Object object = entry.inboundLock;
                    synchronized (object) {
                        do {
                            inNetBuffer.flip();
                            SSLEngineResult result = entry.sslEngine.unwrap(inNetBuffer, inAppBuffer);
                            TLSTM.this.adjustInNetBuffer(entry, result);
                            if (result.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                                logger.error((Serializable)((Object)"BUFFER_OVERFLOW"));
                                throw new IOException("BUFFER_OVERFLOW");
                            }
                            if (!this.runDelegatedTasks(result, entry)) break;
                            if (result.bytesProduced() > 0) {
                                entry.inAppBuffer.flip();
                                if (entry.inAppBuffer.remaining() % TLSTM.this.tlsMaxFragmentSize == 0) {
                                    if (logger.isDebugEnabled()) {
                                        logger.debug((Serializable)((Object)("Checking PDU header for fragmented message: " + entry)));
                                    }
                                    try {
                                        BER.decodeHeader(new BERInputStream(entry.inAppBuffer.asReadOnlyBuffer()), new BER.MutableByte(), true);
                                    }
                                    catch (IOException iox) {
                                        entry.inAppBuffer.position(entry.inAppBuffer.limit());
                                        entry.inAppBuffer.limit(entry.inAppBuffer.capacity());
                                        if (!logger.isDebugEnabled()) continue;
                                        logger.debug((Serializable)((Object)("Waiting for rest of packet because: " + iox.getMessage() + ", inAppBuffer=" + entry.inAppBuffer + ", inNetBuffer=" + inNetBuffer)));
                                        continue;
                                    }
                                }
                                entry.checkTransportStateReference();
                                this.dispatchMessage(incomingAddress, inAppBuffer, inAppBuffer.limit(), entry.sessionID, entry.tmStateReference);
                                entry.getInAppBuffer().clear();
                                if (!entry.inNetBuffer.hasRemaining() || !logger.isDebugEnabled()) continue;
                                logger.debug((Serializable)((Object)("Processing next packet in inNetBuffer" + entry.inNetBuffer)));
                                continue;
                            }
                            if (!entry.isAppOutPending()) continue;
                            this.writeMessage(entry, entry.getSocketChannel());
                        } while (inNetBuffer.position() > 0 && inNetBuffer.remaining() > 0);
                    }
                }
                return true;
            }
            catch (ClosedChannelException ccex) {
                TLSTM.this.cancelNonServerSelectionKey(sk);
                if (logger.isDebugEnabled()) {
                    logger.debug((Serializable)((Object)("Read channel not open, no bytes read from " + incomingAddress)));
                }
                return false;
            }
        }

        @Override
        protected void fireIncrementCounterSessionClose() {
            if (TLSTM.this.counterSupport != null) {
                TLSTM.this.counterSupport.fireIncrementCounter(new CounterEvent(this, this.transportMapping.isServerEnabled() ? SnmpConstants.snmpTlstmSessionClientCloses : SnmpConstants.snmpTlstmSessionServerCloses));
            }
        }

        private void dispatchMessage(TcpAddress incomingAddress, ByteBuffer byteBuffer, long bytesRead, Object sessionID, TransportStateReference tmStateReference) {
            ByteBuffer bis;
            byteBuffer.flip();
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("Received message from " + incomingAddress + " with length " + bytesRead + ": " + new OctetString(byteBuffer.array(), 0, (int)bytesRead).toHexString())));
            }
            if (TLSTM.this.isAsyncMsgProcessingSupported()) {
                byte[] bytes = new byte[(int)bytesRead];
                System.arraycopy(byteBuffer.array(), 0, bytes, 0, (int)bytesRead);
                bis = ByteBuffer.wrap(bytes);
            } else {
                bis = ByteBuffer.wrap(byteBuffer.array(), 0, (int)bytesRead);
            }
            TLSTM.this.fireProcessMessage(incomingAddress, bis, tmStateReference);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        protected void writeMessage(SocketEntry entry, SocketChannel sc) throws IOException {
            Object object = entry.outboundLock;
            synchronized (object) {
                boolean sendNextFragment = false;
                entry.addRegistration(this.selector, 1);
                do {
                    SSLEngineResult result;
                    int offset;
                    block18: {
                        block17: {
                            sendNextFragment = false;
                            offset = 0;
                            if (entry.outAppBuffer != null) break block17;
                            byte[] message = entry.nextMessage();
                            if (message != null) {
                                entry.outAppBuffer = ByteBuffer.wrap(message);
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Serializable)((Object)("Sending message with length " + message.length + " as " + (entry.sslEngine.getUseClientMode() ? "client" : "server") + " to " + entry.getPeerAddress() + ": " + new OctetString(message).toHexString())));
                                }
                                break block18;
                            } else {
                                entry.removeRegistration(this.selector, 4);
                                if (entry.hasMessage() && !entry.isRegistered(4)) {
                                    entry.addRegistration(this.selector, 4);
                                    logger.debug((Serializable)((Object)"Waking up selector for writing"));
                                    this.selector.wakeup();
                                }
                                entry.addRegistration(this.selector, 1);
                                return;
                            }
                        }
                        offset = entry.outAppBuffer.position();
                    }
                    if ((result = entry.sslEngine.wrap(entry.outAppBuffer, entry.outNetBuffer)).getStatus() == SSLEngineResult.Status.OK) {
                        if (result.bytesProduced() > 0) {
                            TLSTM.this.writeNetBuffer(entry, sc);
                        } else {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Serializable)((Object)("SSL Engine status of wrap is ok, but 0 NET bytes produced, handshake status is " + result.getHandshakeStatus())));
                            }
                            if (result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_UNWRAP || result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_UNWRAP_AGAIN) {
                                entry.removeRegistration(this.selector, 4);
                                logger.debug((Serializable)((Object)"Removed write selection on key because handshake needs UNWRAP first"));
                            }
                        }
                    }
                    if (result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK && this.runDelegatedTasks(result, entry)) {
                        logger.debug((Serializable)((Object)"SSL session OK"));
                    }
                    if (result.bytesConsumed() >= entry.outAppBuffer.limit() - offset) {
                        logger.debug((Serializable)((Object)"Payload sent completely"));
                        entry.outAppBuffer = null;
                        continue;
                    }
                    if (result.bytesConsumed() > 0) {
                        logger.debug((Serializable)((Object)("Fragment of size " + result.bytesConsumed() + " sent: " + entry)));
                        sendNextFragment = true;
                        continue;
                    }
                    if (entry.outNetBuffer.position() == 0) {
                        logger.debug((Serializable)((Object)"Nothing to write to network, removing write key"));
                        entry.removeRegistration(this.selector, 4);
                        continue;
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Serializable)((Object)("Output in outNetBuffer not sent yet, adding entry to outQueue: " + entry)));
                    }
                    this.outQueue.add(entry);
                } while (sendNextFragment);
                if (!logger.isDebugEnabled()) return;
                logger.debug((Serializable)((Object)("Message sent for " + entry)));
                return;
            }
        }
    }
}

