/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.transport;

import java.io.Serializable;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.smi.Address;
import org.snmp4j.transport.AbstractServerSocket;

public abstract class AbstractSocketEntry<A extends Address>
extends AbstractServerSocket<A> {
    private static final LogAdapter logger = LogFactory.getLogger(AbstractSocketEntry.class);
    protected SocketChannel socketChannel;
    private volatile int registrations = 0;
    private final LinkedList<byte[]> messages = new LinkedList();
    private final AtomicInteger busyLoops = new AtomicInteger(0);

    public AbstractSocketEntry(A address, SocketChannel socketChannel) {
        super(address);
        this.socketChannel = socketChannel;
    }

    public synchronized void addRegistration(Selector selector, int opKey) throws ClosedChannelException {
        if ((this.registrations & opKey) == 0) {
            this.registrations |= opKey;
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("Adding operation " + AbstractSocketEntry.getOperationListFromSelectionKey(opKey) + " for: " + this)));
            }
            this.socketChannel.register(selector, this.registrations, this);
        } else if (!this.socketChannel.isRegistered()) {
            this.registrations = opKey;
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("Registering new operation " + AbstractSocketEntry.getOperationListFromSelectionKey(opKey) + " for: " + this)));
            }
            this.socketChannel.register(selector, opKey, this);
        }
    }

    private static String getOperationListFromSelectionKey(int opKey) {
        StringBuilder buf = new StringBuilder();
        if ((opKey & 1) > 0) {
            buf.append("[READ]");
        }
        if ((opKey & 4) > 0) {
            buf.append("[WRITE]");
        }
        if ((opKey & 0x10) > 0) {
            buf.append("[ACCEPT]");
        }
        if ((opKey & 8) > 0) {
            buf.append("[CONNECT]");
        }
        return buf.toString();
    }

    public synchronized void removeRegistration(Selector selector, int opKey) throws ClosedChannelException {
        if ((this.registrations & opKey) == opKey) {
            this.registrations &= ~opKey;
            this.socketChannel.register(selector, this.registrations, this);
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("Removed operation(s) " + AbstractSocketEntry.getOperationListFromSelectionKey(opKey) + " for: " + this)));
            }
        }
    }

    public synchronized boolean isRegistered(int opKey) {
        return (this.registrations & opKey) == opKey;
    }

    public SocketChannel getSocketChannel() {
        return this.socketChannel;
    }

    public List<byte[]> getMessages() {
        return this.messages;
    }

    public synchronized void addMessage(byte[] message) {
        this.messages.add(message);
    }

    public synchronized void insertMessages(List<byte[]> messages) {
        this.messages.addAll(0, messages);
    }

    public synchronized byte[] nextMessage() {
        if (this.messages.size() > 0) {
            return this.messages.removeFirst();
        }
        return null;
    }

    public synchronized boolean hasMessage() {
        return !this.messages.isEmpty();
    }

    public synchronized int nextBusyLoop() {
        return this.busyLoops.incrementAndGet();
    }

    public void resetBusyLoops() {
        this.busyLoops.set(0);
    }

    public abstract String toString();

    public abstract void closeSession();

    public abstract Object getSessionID();
}

