/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.tools.console;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.snmp4j.smi.AssignableFromInteger;
import org.snmp4j.smi.AssignableFromLong;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;

public class TableFormatter {
    private PrintStream printer;
    private List<Object[]> buffer = new ArrayList<Object[]>();
    private int limit = 5;
    private int[] colSizes;
    private int defaultColSize = 16;
    private int maxLineLength = 80;
    private String separator = " ";
    private boolean compact = false;
    private boolean leftAlign = false;

    public TableFormatter(PrintStream printer, int defaultColumnSize, int maxLineLength, String separator) {
        this.printer = printer;
        this.maxLineLength = maxLineLength;
        this.defaultColSize = defaultColumnSize;
        if (separator != null) {
            this.separator = separator;
        }
    }

    public void setBufferSize(int limit) {
        this.limit = Math.max(limit, 1);
    }

    public void setCompact(boolean compact) {
        this.compact = compact;
    }

    public synchronized void addRow(Object[] columns) {
        this.buffer.add(columns);
        if (this.buffer.size() > this.limit) {
            this.flush();
        }
    }

    private void computeColumnSizes() {
        Object[] o2;
        int numcols = 0;
        Iterator<Object[]> iterator = this.buffer.iterator();
        while (iterator.hasNext()) {
            Object[] aBuffer1;
            o2 = aBuffer1 = iterator.next();
            numcols = Math.max(numcols, o2.length);
        }
        this.colSizes = new int[numcols];
        iterator = this.buffer.iterator();
        while (iterator.hasNext()) {
            Object[] aBuffer;
            Object[] c2 = o2 = (aBuffer = iterator.next());
            for (int j2 = 0; j2 < c2.length; ++j2) {
                String s2 = TableFormatter.getString(c2[j2]);
                this.colSizes[j2] = Math.max(s2.length(), this.colSizes[j2]);
            }
        }
    }

    private static String getString(Object o2) {
        if (o2 instanceof VariableBinding) {
            return ((VariableBinding)o2).toValueString();
        }
        if (o2 == null) {
            return "";
        }
        return o2.toString();
    }

    public synchronized void flush() {
        if (this.colSizes == null) {
            this.computeColumnSizes();
        }
        this.printBuffer();
        this.buffer.clear();
    }

    public void setLeftAlign(boolean leftAlign) {
        this.leftAlign = leftAlign;
    }

    private void printBuffer() {
        Iterator<Object[]> iterator = this.buffer.iterator();
        while (iterator.hasNext()) {
            Object[] aBuffer;
            Object[] o2;
            Object[] c2 = o2 = (aBuffer = iterator.next());
            int rsz = 0;
            for (int j2 = 0; j2 < c2.length; ++j2) {
                int k2;
                String s2 = TableFormatter.getString(c2[j2]);
                int sz = s2.length();
                int tsz = j2 < this.colSizes.length ? this.colSizes[j2] : this.defaultColSize;
                rsz += tsz + this.separator.length();
                if (this.compact) {
                    this.printer.print(s2);
                    this.printer.print(this.separator);
                    continue;
                }
                boolean padded = false;
                if (!this.leftAlign && this.isNumber(c2[j2])) {
                    for (k2 = 0; k2 < tsz - sz; ++k2) {
                        this.printer.print(' ');
                    }
                    padded = true;
                }
                this.printer.print(s2);
                if (rsz > this.maxLineLength) {
                    this.printer.println();
                    rsz = 0;
                    continue;
                }
                if (!padded) {
                    this.printer.print(this.separator);
                    for (k2 = 0; k2 < tsz - sz; ++k2) {
                        this.printer.print(' ');
                    }
                    continue;
                }
                this.printer.print(this.separator);
            }
            this.printer.println();
        }
    }

    private boolean isNumber(Object o2) {
        Variable v;
        return o2 instanceof VariableBinding && ((v = ((VariableBinding)o2).getVariable()) instanceof AssignableFromLong || v instanceof AssignableFromInteger);
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }
}

