/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.smi;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.TransportIpAddress;

public class UdpAddress
extends TransportIpAddress {
    static final long serialVersionUID = -4390734262648716203L;

    public UdpAddress() {
    }

    public UdpAddress(InetAddress inetAddress, int port) {
        this.setInetAddress(inetAddress);
        this.setPort(port);
    }

    public UdpAddress(int port) {
        try {
            this.setInetAddress(InetAddress.getLocalHost());
        }
        catch (UnknownHostException e2) {
            throw new RuntimeException(e2);
        }
        this.setPort(port);
    }

    public UdpAddress(String address) {
        if (!this.parseAddress(address)) {
            throw new IllegalArgumentException(address);
        }
    }

    public static Address parse(String address) {
        UdpAddress a2 = new UdpAddress();
        if (a2.parseAddress(address)) {
            return a2;
        }
        return null;
    }

    @Override
    public boolean equals(Object o2) {
        return o2 instanceof UdpAddress && super.equals(o2);
    }
}

