/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.smi;

import java.io.IOException;
import java.io.OutputStream;
import java.text.ParseException;
import java.util.Arrays;
import java.util.NoSuchElementException;
import org.snmp4j.SNMP4JSettings;
import org.snmp4j.asn1.BER;
import org.snmp4j.asn1.BERInputStream;
import org.snmp4j.smi.AbstractVariable;
import org.snmp4j.smi.AssignableFromIntArray;
import org.snmp4j.smi.AssignableFromString;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Variable;
import org.snmp4j.util.OIDTextFormat;
import org.snmp4j.util.SimpleOIDTextFormat;

public class OID
extends AbstractVariable
implements AssignableFromString,
AssignableFromIntArray {
    private static final long serialVersionUID = 7521667239352941172L;
    private static OIDTextFormat oidTextFormat = new SimpleOIDTextFormat();
    public static final int MAX_OID_LEN = 128;
    public static final int MAX_SUBID_VALUE = -1;
    private static final int[] NULL_OID = new int[0];
    private int[] value = NULL_OID;

    public OID() {
    }

    public OID(String oid) {
        this.value = OID.parseDottedString(oid);
    }

    public OID(int[] rawOID) {
        this(rawOID, 0, rawOID.length);
    }

    public OID(int[] prefixOID, int[] suffixOID) {
        this.value = new int[prefixOID.length + suffixOID.length];
        System.arraycopy(prefixOID, 0, this.value, 0, prefixOID.length);
        System.arraycopy(suffixOID, 0, this.value, prefixOID.length, suffixOID.length);
    }

    public OID(int[] prefixOID, int suffixID) {
        this.value = new int[prefixOID.length + 1];
        System.arraycopy(prefixOID, 0, this.value, 0, prefixOID.length);
        this.value[prefixOID.length] = suffixID;
    }

    public OID(int[] rawOID, int offset, int length) {
        this.setValue(rawOID, offset, length);
    }

    public OID(OID other) {
        this(other.getValue());
    }

    private static int[] parseDottedString(String oid) {
        try {
            return SNMP4JSettings.getOIDTextFormat().parse(oid);
        }
        catch (ParseException ex) {
            throw new RuntimeException("OID '" + oid + "' cannot be parsed", ex);
        }
    }

    @Override
    public final int getSyntax() {
        return 6;
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.getValue());
    }

    @Override
    public final boolean equals(Object o2) {
        if (o2 instanceof OID) {
            OID other = (OID)o2;
            if (other.value.length != this.value.length) {
                return false;
            }
            for (int i2 = 0; i2 < this.value.length; ++i2) {
                if (this.value[i2] == other.value[i2]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public OID mask(OctetString mask) {
        int[] masked = new int[this.value.length];
        System.arraycopy(this.value, 0, masked, 0, this.value.length);
        for (int i2 = 0; i2 < mask.length() * 8 && i2 < masked.length; ++i2) {
            byte b2 = (byte)(128 >> i2 % 8);
            if ((mask.get(i2 / 8) & b2) != 0) continue;
            masked[i2] = 0;
        }
        return new OID(masked);
    }

    @Override
    public final int compareTo(Variable o2) {
        if (o2 instanceof OID) {
            OID other = (OID)o2;
            int min2 = Math.min(this.value.length, other.value.length);
            int result = this.leftMostCompare(min2, other);
            if (result == 0) {
                return this.value.length - other.value.length;
            }
            return result;
        }
        throw new ClassCastException(o2.getClass().getName());
    }

    @Override
    public String toString() {
        return SNMP4JSettings.getOIDTextFormat().formatForRoundTrip(this.value);
    }

    public String format() {
        return SNMP4JSettings.getOIDTextFormat().format(this.value);
    }

    public String toDottedString() {
        return oidTextFormat.format(this.value);
    }

    public byte[] toByteArray() {
        byte[] b2 = new byte[this.value.length];
        for (int i2 = 0; i2 < this.value.length; ++i2) {
            b2[i2] = (byte)(this.value[i2] & 0xFF);
        }
        return b2;
    }

    @Override
    public void encodeBER(OutputStream outputStream) throws IOException {
        BER.encodeOID(outputStream, (byte)6, this.value);
    }

    @Override
    public int getBERLength() {
        int length = BER.getOIDLength(this.value);
        return length + BER.getBERLengthOfLength(length) + 1;
    }

    @Override
    public void decodeBER(BERInputStream inputStream) throws IOException {
        BER.MutableByte type = new BER.MutableByte();
        int[] v = BER.decodeOID(inputStream, type);
        if (type.getValue() != 6) {
            throw new IOException("Wrong type encountered when decoding OID: " + type.getValue());
        }
        this.setValue(v);
    }

    @Override
    public void setValue(String value) {
        this.value = OID.parseDottedString(value);
    }

    @Override
    public final void setValue(int[] value) {
        if (value == null) {
            throw new IllegalArgumentException("OID value must not be set to null");
        }
        this.value = value;
    }

    private void setValue(int[] rawOID, int offset, int length) {
        this.value = new int[length];
        System.arraycopy(rawOID, offset, this.value, 0, length);
    }

    public final int[] getValue() {
        return this.value;
    }

    public final int get(int index) {
        return this.value[index];
    }

    public final long getUnsigned(int index) {
        return (long)this.value[index] & 0xFFFFFFFFL;
    }

    public final void set(int index, int value) {
        this.value[index] = value;
    }

    public final OID append(String oid) {
        OID suffix = new OID(oid);
        return this.append(suffix);
    }

    public final OID append(OID oid) {
        int[] newValue = new int[this.value.length + oid.value.length];
        System.arraycopy(this.value, 0, newValue, 0, this.value.length);
        System.arraycopy(oid.value, 0, newValue, this.value.length, oid.value.length);
        this.value = newValue;
        return this;
    }

    public final OID append(int subID) {
        int[] newValue = new int[this.value.length + 1];
        System.arraycopy(this.value, 0, newValue, 0, this.value.length);
        newValue[this.value.length] = subID;
        this.value = newValue;
        return this;
    }

    public final OID appendUnsigned(long subID) {
        return this.append((int)(subID & 0xFFFFFFFFL));
    }

    public boolean isValid() {
        return this.size() >= 2 && this.size() <= 128 && ((long)this.value[0] & 0xFFFFFFFFL) <= 2L && ((long)this.value[1] & 0xFFFFFFFFL) < 40L;
    }

    public final int size() {
        return this.value.length;
    }

    public int leftMostCompare(int n2, OID other) {
        for (int i2 = 0; i2 < n2 && i2 < this.value.length && i2 < other.size(); ++i2) {
            if (this.value[i2] == other.value[i2]) continue;
            if (((long)this.value[i2] & 0xFFFFFFFFL) < ((long)other.value[i2] & 0xFFFFFFFFL)) {
                return -1;
            }
            return 1;
        }
        if (n2 > this.value.length) {
            return -1;
        }
        if (n2 > other.size()) {
            return 1;
        }
        return 0;
    }

    public int rightMostCompare(int n2, OID other) {
        int cursorA = this.value.length - 1;
        int cursorB = other.value.length - 1;
        int i2 = n2 - 1;
        while (i2 >= 0) {
            if (this.value[cursorA] != other.value[cursorB]) {
                if (this.value[cursorA] < other.value[cursorB]) {
                    return -1;
                }
                return 1;
            }
            --i2;
            --cursorA;
            --cursorB;
        }
        return 0;
    }

    public boolean startsWith(OID other) {
        if (other.value.length > this.value.length) {
            return false;
        }
        int min2 = Math.min(this.value.length, other.value.length);
        return this.leftMostCompare(min2, other) == 0;
    }

    @Override
    public Object clone() {
        return new OID(this.value);
    }

    public final int last() {
        if (this.value.length > 0) {
            return this.value[this.value.length - 1];
        }
        throw new NoSuchElementException();
    }

    public final long lastUnsigned() {
        if (this.value.length > 0) {
            return (long)this.value[this.value.length - 1] & 0xFFFFFFFFL;
        }
        throw new NoSuchElementException();
    }

    public int removeLast() {
        if (this.value.length == 0) {
            return -1;
        }
        int[] newValue = new int[this.value.length - 1];
        System.arraycopy(this.value, 0, newValue, 0, this.value.length - 1);
        int retValue = this.value[this.value.length - 1];
        this.value = newValue;
        return retValue;
    }

    public void trim(int n2) {
        if (n2 > 0) {
            if (n2 > this.value.length) {
                n2 = this.value.length;
            }
            int[] newValue = new int[this.value.length - n2];
            System.arraycopy(this.value, 0, newValue, 0, this.value.length - n2);
            this.value = newValue;
        }
    }

    public OID trim() {
        return new OID(this.value, 0, Math.max(this.value.length - 1, 0));
    }

    @Override
    public int toInt() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long toLong() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final OID toSubIndex(boolean impliedLength) {
        if (impliedLength) {
            return new OID(this.value);
        }
        OID subIndex = new OID(new int[]{this.size()});
        subIndex.append(this);
        return subIndex;
    }

    @Override
    public final void fromSubIndex(OID subIndex, boolean impliedLength) {
        int offset = 1;
        if (impliedLength) {
            offset = 0;
        }
        this.setValue(subIndex.getValue(), offset, subIndex.size() - offset);
    }

    public final OID successor() {
        if (this.value.length == 128) {
            for (int i2 = 127; i2 >= 0; --i2) {
                if (this.value[i2] == -1) continue;
                int[] succ = new int[i2 + 1];
                System.arraycopy(this.value, 0, succ, 0, i2 + 1);
                int n2 = i2;
                succ[n2] = succ[n2] + 1;
                return new OID(succ);
            }
            return new OID();
        }
        int[] succ = new int[this.value.length + 1];
        System.arraycopy(this.value, 0, succ, 0, this.value.length);
        succ[this.value.length] = 0;
        return new OID(succ);
    }

    public final OID predecessor() {
        if (this.last() != 0) {
            int[] pval = new int[128];
            System.arraycopy(this.value, 0, pval, 0, this.value.length);
            Arrays.fill(pval, this.value.length, pval.length, -1);
            OID pred = new OID(pval);
            pred.set(this.size() - 1, this.last() - 1);
            return pred;
        }
        OID pred = new OID(this);
        pred.removeLast();
        return pred;
    }

    public final OID nextPeer() {
        OID next = new OID(this);
        if (next.size() > 0 && this.last() != -1) {
            next.set(next.size() - 1, this.last() + 1);
        } else if (next.size() > 1) {
            next.trim(1);
            next = next.nextPeer();
        }
        return next;
    }

    public static OID max(OID a2, OID b2) {
        if (a2.compareTo(b2) >= 0) {
            return a2;
        }
        return b2;
    }

    public static OID min(OID a2, OID b2) {
        if (a2.compareTo(b2) <= 0) {
            return a2;
        }
        return b2;
    }

    @Override
    public int[] toIntArray() {
        return this.value;
    }

    public long[] toUnsignedLongArray() {
        long[] longs = new long[this.size()];
        for (int i2 = 0; i2 < this.value.length; ++i2) {
            longs[i2] = Integer.toUnsignedLong(this.value[i2]);
        }
        return longs;
    }

    public OID getSuffix(OID prefix) {
        int prefixSize = prefix.size();
        if (this.leftMostCompare(prefixSize, prefix) == 0) {
            int[] suffix = new int[this.size() - prefixSize];
            System.arraycopy(this.value, prefixSize, suffix, 0, this.size() - prefixSize);
            return new OID(suffix);
        }
        return null;
    }

    public OID subOID(int beginIndex) {
        if (beginIndex < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int[] sub = new int[this.value.length - beginIndex];
        System.arraycopy(this.value, beginIndex, sub, 0, this.value.length - beginIndex);
        return new OID(sub);
    }

    public OID subOID(int beginIndex, int endIndex) {
        if (beginIndex < 0 || endIndex < 0 || endIndex > this.value.length || beginIndex > endIndex) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int[] sub = new int[endIndex - beginIndex];
        System.arraycopy(this.value, beginIndex, sub, 0, endIndex - beginIndex);
        return new OID(sub);
    }
}

