/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.smi;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.net.ProtocolFamily;
import java.net.SocketAddress;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.snmp4j.SNMP4JSettings;
import org.snmp4j.asn1.BERInputStream;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.DtlsAddress;
import org.snmp4j.smi.IpAddress;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.SMIAddress;
import org.snmp4j.smi.TcpAddress;
import org.snmp4j.smi.TlsAddress;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.smi.Variable;

public class GenericAddress
extends SMIAddress {
    static final long serialVersionUID = -6102594326202231511L;
    public static final String TYPE_UDP = "udp";
    public static final String TYPE_TCP = "tcp";
    public static final String TYPE_IP = "ip";
    public static final String TYPE_TLS = "tls";
    public static final String TYPE_DTLS = "dtls";
    public static final String TYPE_UNIX = "unix";
    public static final String ADDRESS_TYPES_PROPERTIES = "org.snmp4j.addresses";
    private static final String ADDRESS_TYPES_PROPERTIES_DEFAULT = "address.properties";
    private static final LogAdapter logger = LogFactory.getLogger(GenericAddress.class);
    public static final String UNIX_DOMAIN_SOCKET_ADDRESS_CLASS = "org.snmp4j.transport.unix.UnixDomainAddress";
    private SMIAddress address;
    private static Map<String, Class<? extends Address>> knownAddressTypes = null;

    public GenericAddress() {
    }

    public GenericAddress(SMIAddress address) {
        this.address = address;
    }

    @Override
    public int getSyntax() {
        return this.address.getSyntax();
    }

    @Override
    public boolean isValid() {
        return this.address != null && this.address.isValid();
    }

    @Override
    public String toString() {
        return this.address.toString();
    }

    @Override
    public int hashCode() {
        return this.address.hashCode();
    }

    @Override
    public int compareTo(Variable o2) {
        return this.address.compareTo(o2);
    }

    @Override
    public boolean equals(Object o2) {
        return this.address.equals(o2);
    }

    @Override
    public void decodeBER(BERInputStream inputStream) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void encodeBER(OutputStream outputStream) throws IOException {
        this.address.encodeBER(outputStream);
    }

    @Override
    public int getBERLength() {
        return this.address.getBERLength();
    }

    public void setAddress(SMIAddress address) {
        this.address = address;
    }

    public Address getAddress() {
        return this.address;
    }

    private static synchronized void registerAddressTypes() {
        TreeMap<String, Class<? extends Address>> h2;
        block17: {
            if (SNMP4JSettings.isExtensibilityEnabled()) {
                String addresses = System.getProperty(ADDRESS_TYPES_PROPERTIES, ADDRESS_TYPES_PROPERTIES_DEFAULT);
                InputStream is = Variable.class.getResourceAsStream(addresses);
                if (is == null) {
                    throw new InternalError("Could not read '" + addresses + "' from classpath!");
                }
                Properties props = new Properties();
                try {
                    props.load(is);
                    TreeMap<String, Class<? extends Address>> h3 = new TreeMap<String, Class<? extends Address>>();
                    for (String id : props.stringPropertyNames()) {
                        String className = props.getProperty(id);
                        try {
                            Class<?> c2 = Class.forName(className);
                            h3.put(id, c2);
                        }
                        catch (ClassNotFoundException cnfe) {
                            logger.error(cnfe);
                        }
                        catch (ClassCastException ccex) {
                            logger.error((Serializable)((Object)("Class name '" + className + "' is not a subclass of " + Address.class.getName())));
                        }
                    }
                    knownAddressTypes = h3;
                }
                catch (IOException iox) {
                    String txt = "Could not read '" + addresses + "': " + iox.getMessage();
                    logger.error((Serializable)((Object)txt));
                    throw new InternalError(txt);
                }
                finally {
                    try {
                        is.close();
                    }
                    catch (IOException ex) {
                        logger.warn(ex);
                    }
                }
            }
            h2 = new TreeMap<String, Class<? extends Address>>();
            h2.put(TYPE_UDP, UdpAddress.class);
            h2.put(TYPE_TCP, TcpAddress.class);
            h2.put(TYPE_IP, IpAddress.class);
            h2.put(TYPE_TLS, TlsAddress.class);
            h2.put(TYPE_DTLS, DtlsAddress.class);
            try {
                Class<?> c3 = Class.forName(UNIX_DOMAIN_SOCKET_ADDRESS_CLASS);
                h2.put(TYPE_UNIX, c3);
            }
            catch (ClassNotFoundException e2) {
                if (!logger.isDebugEnabled()) break block17;
                logger.debug((Serializable)((Object)"org.snmp4j.transport.unix.UnixDomainAddress not found in classpath, unix domain address not added to GenericAddress types"));
            }
        }
        knownAddressTypes = h2;
    }

    public static Address parse(String address) {
        Class<? extends Address> c2;
        if (knownAddressTypes == null) {
            GenericAddress.registerAddressTypes();
        }
        String type = TYPE_UDP;
        int sep = address.indexOf(58);
        if (sep > 0) {
            type = address.substring(0, sep);
            address = address.substring(sep + 1);
        }
        if ((c2 = knownAddressTypes.get(type = type.toLowerCase())) == null) {
            throw new IllegalArgumentException("Address type " + type + " unknown");
        }
        try {
            Address addr = c2.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (addr.parseAddress(address)) {
                return addr;
            }
            return null;
        }
        catch (Exception ex) {
            logger.warn(ex);
            return null;
        }
    }

    @Override
    public boolean parseAddress(String address) {
        Address addr = GenericAddress.parse(address);
        if (addr instanceof SMIAddress) {
            this.setAddress((SMIAddress)addr);
            return true;
        }
        return false;
    }

    @Override
    public void setValue(byte[] rawAddress) {
        this.address.setValue(rawAddress);
    }

    @Override
    public Object clone() {
        return new GenericAddress(this.address);
    }

    @Override
    public int toInt() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long toLong() {
        throw new UnsupportedOperationException();
    }

    @Override
    public OID toSubIndex(boolean impliedLength) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void fromSubIndex(OID subIndex, boolean impliedLength) {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] toByteArray() {
        return this.address.toByteArray();
    }

    @Override
    public void setValue(String value) {
        if (!this.parseAddress(value)) {
            throw new IllegalArgumentException(value + " cannot be parsed by " + this.getClass().getName());
        }
    }

    @Override
    public ProtocolFamily getFamily() {
        return this.address.getFamily();
    }

    @Override
    public SocketAddress getSocketAddress() {
        return this.address.getSocketAddress();
    }

    public static String getTDomainPrefix(Class<? extends Address> addressClass) {
        if (knownAddressTypes == null) {
            GenericAddress.registerAddressTypes();
        }
        for (Map.Entry<String, Class<? extends Address>> entry : knownAddressTypes.entrySet()) {
            if (!entry.getValue().equals(addressClass)) continue;
            return entry.getKey();
        }
        return null;
    }

    public static Address newLocalAddress(String transportDomainPrefix) {
        Class<? extends Address> addressClass;
        if (knownAddressTypes == null) {
            GenericAddress.registerAddressTypes();
        }
        if ((addressClass = knownAddressTypes.get(transportDomainPrefix)) != null) {
            try {
                return addressClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e2) {
                throw new RuntimeException(e2);
            }
        }
        return null;
    }
}

