/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.security;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.snmp4j.TransportStateReference;
import org.snmp4j.asn1.BERInputStream;
import org.snmp4j.asn1.BEROutputStream;
import org.snmp4j.event.CounterEvent;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.mp.CounterSupport;
import org.snmp4j.mp.MPv3;
import org.snmp4j.mp.SnmpConstants;
import org.snmp4j.mp.StatusInformation;
import org.snmp4j.security.SNMPv3SecurityModel;
import org.snmp4j.security.SecurityModel;
import org.snmp4j.security.SecurityParameters;
import org.snmp4j.security.SecurityStateReference;
import org.snmp4j.security.TsmSecurityParameters;
import org.snmp4j.security.TsmSecurityStateReference;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.GenericAddress;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.VariableBinding;

public class TSM
extends SNMPv3SecurityModel {
    private static final int MAX_PREFIX_LENGTH = 4;
    private static final byte PREFIX_SEPARATOR = 58;
    private static final LogAdapter logger = LogFactory.getLogger(TSM.class);
    private boolean usePrefix;

    public TSM() {
        this(new OctetString(MPv3.createLocalEngineID()), false);
    }

    public TSM(OctetString localEngineID, boolean usePrefix) {
        this(localEngineID, usePrefix, CounterSupport.getInstance());
    }

    public TSM(OctetString localEngineID, boolean usePrefix, CounterSupport counterSupport) {
        this.counterSupport = counterSupport;
        this.localEngineID = localEngineID;
        this.usePrefix = usePrefix;
    }

    public void setLocalEngineID(OctetString localEngineID) {
        this.localEngineID = localEngineID;
    }

    protected void fireIncrementCounter(CounterEvent e2) {
        this.counterSupport.fireIncrementCounter(e2);
    }

    @Override
    public int getID() {
        return 4;
    }

    @Override
    public boolean supportsEngineIdDiscovery() {
        return false;
    }

    @Override
    public boolean hasAuthoritativeEngineID() {
        return false;
    }

    @Override
    public SecurityParameters newSecurityParametersInstance() {
        return new TsmSecurityParameters();
    }

    @Override
    public SecurityStateReference newSecurityStateReference() {
        return new TsmSecurityStateReference();
    }

    @Override
    public int generateRequestMessage(int messageProcessingModel, byte[] globalData, int maxMessageSize, int securityModel, byte[] securityEngineID, byte[] securityName, int securityLevel, BERInputStream scopedPDU, SecurityParameters securityParameters, BEROutputStream wholeMsg, TransportStateReference tmStateReference, SecurityStateReference securityStateReference) throws IOException {
        return this.generateMessage(messageProcessingModel, globalData, maxMessageSize, securityModel, securityEngineID, securityName, securityLevel, scopedPDU, null, securityParameters, wholeMsg, tmStateReference);
    }

    private int generateMessage(int messageProcessingModel, byte[] globalData, int maxMessageSize, int securityModel, byte[] securityEngineID, byte[] securityName, int securityLevel, BERInputStream scopedPDU, SecurityStateReference securityStateReference, SecurityParameters securityParameters, BEROutputStream wholeMsg, TransportStateReference tmStateReference) throws IOException {
        TransportStateReference activeTmStateReference = tmStateReference;
        TsmSecurityStateReference tsmSecurityStateReference = (TsmSecurityStateReference)securityStateReference;
        if (tsmSecurityStateReference != null && tsmSecurityStateReference.getTmStateReference() != null) {
            activeTmStateReference = tsmSecurityStateReference.getTmStateReference();
            activeTmStateReference.setRequestedSecurityLevel(activeTmStateReference.getTransportSecurityLevel());
            activeTmStateReference.setSameSecurity(true);
        } else {
            activeTmStateReference.setSameSecurity(false);
            if (this.usePrefix) {
                String prefix = this.getTransportDomainPrefix(tmStateReference.getAddress());
                if (prefix == null) {
                    CounterEvent event = new CounterEvent(this, SnmpConstants.snmpTsmUnknownPrefixes);
                    this.fireIncrementCounter(event);
                    return 1601;
                }
                if (prefix.length() < 1 || prefix.length() > 4) {
                    CounterEvent event = new CounterEvent(this, SnmpConstants.snmpTsmInvalidPrefixes);
                    this.fireIncrementCounter(event);
                    return 1601;
                }
                String secNamePrefix = this.getSecurityNamePrefix(securityName);
                if (secNamePrefix == null) {
                    CounterEvent event = new CounterEvent(this, SnmpConstants.snmpTsmUnknownPrefixes);
                    this.fireIncrementCounter(event);
                    return 1601;
                }
                if (!secNamePrefix.equals(prefix)) {
                    CounterEvent event = new CounterEvent(this, SnmpConstants.snmpTsmInvalidPrefixes);
                    this.fireIncrementCounter(event);
                    return 1601;
                }
                activeTmStateReference.setSecurityName(new OctetString(new String(securityName).substring(secNamePrefix.length() + 1)));
            } else {
                activeTmStateReference.setSecurityName(OctetString.fromByteArray(securityName));
            }
        }
        byte[] scopedPduBytes = TSM.buildMessageBuffer(scopedPDU);
        byte[] wholeMessage = TSM.buildWholeMessage(new Integer32(messageProcessingModel), scopedPduBytes, globalData, securityParameters);
        ByteBuffer buf = ByteBuffer.wrap(wholeMessage).position(wholeMessage.length);
        wholeMsg.setBuffer(buf);
        return 0;
    }

    protected String getSecurityNamePrefix(byte[] securityName) {
        if (securityName == null) {
            return null;
        }
        String prefix = new String(securityName);
        int colonPos = prefix.indexOf(58);
        if (colonPos <= 0 || colonPos > 4) {
            return null;
        }
        return prefix.substring(0, colonPos);
    }

    protected String getTransportDomainPrefix(Address address) {
        return GenericAddress.getTDomainPrefix(address.getClass());
    }

    @Override
    public int generateResponseMessage(int messageProcessingModel, byte[] globalData, int maxMessageSize, int securityModel, byte[] securityEngineID, byte[] securityName, int securityLevel, BERInputStream scopedPDU, SecurityStateReference securityStateReference, SecurityParameters securityParameters, BEROutputStream wholeMsg) throws IOException {
        return this.generateMessage(messageProcessingModel, globalData, maxMessageSize, securityModel, securityEngineID, securityName, securityLevel, scopedPDU, securityStateReference, securityParameters, wholeMsg, null);
    }

    @Override
    public int processIncomingMsg(int messageProcessingModel, int maxMessageSize, SecurityParameters securityParameters, SecurityModel securityModel, int securityLevel, BERInputStream wholeMsg, TransportStateReference tmStateReference, OctetString securityEngineID, OctetString securityName, BEROutputStream scopedPDU, Integer32 maxSizeResponseScopedPDU, SecurityStateReference securityStateReference, StatusInformation statusInfo) throws IOException {
        securityEngineID.setValue(this.localEngineID.getValue());
        if (tmStateReference == null || !tmStateReference.isTransportSecurityValid()) {
            CounterEvent event = new CounterEvent(this, SnmpConstants.snmpTsmInvalidCaches);
            this.fireIncrementCounter(event);
            return 1602;
        }
        if (this.usePrefix) {
            String prefix = GenericAddress.getTDomainPrefix(tmStateReference.getAddress().getClass());
            if (prefix == null) {
                CounterEvent event = new CounterEvent(this, SnmpConstants.snmpTsmUnknownPrefixes);
                this.fireIncrementCounter(event);
                this.updateStatusInfo(securityLevel, statusInfo, event);
                return 1601;
            }
            if (prefix.length() <= 0 || prefix.length() > 4) {
                CounterEvent event = new CounterEvent(this, SnmpConstants.snmpTsmInvalidPrefixes);
                this.fireIncrementCounter(event);
                this.updateStatusInfo(securityLevel, statusInfo, event);
                return 1601;
            }
            OctetString secName = new OctetString(prefix);
            secName.append((byte)58);
            secName.append(tmStateReference.getSecurityName());
            securityName.setValue(secName.getValue());
        } else if (tmStateReference.getSecurityName() != null) {
            securityName.setValue(OctetString.toByteArray(tmStateReference.getSecurityName()));
        }
        if (securityLevel > tmStateReference.getTransportSecurityLevel().getSnmpValue()) {
            CounterEvent event = new CounterEvent(this, SnmpConstants.snmpTsmInadequateSecurityLevels);
            this.fireIncrementCounter(event);
            this.updateStatusInfo(securityLevel, statusInfo, event);
            return 1603;
        }
        ((TsmSecurityStateReference)securityStateReference).setTmStateReference(tmStateReference);
        TsmSecurityParameters tsmSecurityParameters = (TsmSecurityParameters)securityParameters;
        int scopedPDUPosition = tsmSecurityParameters.getScopedPduPosition();
        byte[] message = TSM.buildMessageBuffer(wholeMsg);
        int scopedPduLength = message.length - scopedPDUPosition;
        ByteBuffer buf = ByteBuffer.wrap(message, scopedPDUPosition, scopedPduLength);
        scopedPDU.setFilledBuffer(buf);
        int maxSecParamsOverhead = tsmSecurityParameters.getBERMaxLength(securityLevel);
        maxSizeResponseScopedPDU.setValue(maxMessageSize - maxSecParamsOverhead);
        return 0;
    }

    private void updateStatusInfo(int securityLevel, StatusInformation statusInfo, CounterEvent event) {
        if (statusInfo != null) {
            statusInfo.setSecurityLevel(new Integer32(securityLevel));
            statusInfo.setErrorIndication(new VariableBinding(event.getOid(), event.getCurrentValue()));
        }
    }

    public boolean isUsePrefix() {
        return this.usePrefix;
    }

    public void setUsePrefix(boolean usePrefix) {
        this.usePrefix = usePrefix;
    }
}

