/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.security;

import java.io.Serializable;
import javax.crypto.Cipher;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.security.AuthenticationProtocol;
import org.snmp4j.security.CipherPool;
import org.snmp4j.security.DecryptParams;
import org.snmp4j.security.PrivacyGeneric;
import org.snmp4j.security.PrivacyProtocol;
import org.snmp4j.security.Salt;
import org.snmp4j.security.SecretOctetString;
import org.snmp4j.smi.OctetString;

public abstract class PrivAES
extends PrivacyGeneric
implements PrivacyProtocol {
    private static final String PROTOCOL_ID = "AES/CFB/NoPadding";
    private static final String PROTOCOL_CLASS = "AES";
    private static final int DECRYPT_PARAMS_LENGTH = 8;
    private static final int INIT_VECTOR_LENGTH = 16;
    private static final LogAdapter logger = LogFactory.getLogger(PrivAES.class);
    private static final long serialVersionUID = 2798468538964694029L;
    protected Salt salt;

    public PrivAES(int keyBytes) {
        this.initVectorLength = 16;
        this.protocolId = PROTOCOL_ID;
        this.protocolClass = PROTOCOL_CLASS;
        if (keyBytes != 16 && keyBytes != 24 && keyBytes != 32) {
            throw new IllegalArgumentException("Only 128, 192 and 256 bit AES is allowed. Requested (" + 8 * keyBytes + ").");
        }
        this.keyBytes = keyBytes;
        this.salt = Salt.getInstance();
        this.cipherPool = new CipherPool();
    }

    @Override
    public byte[] encrypt(byte[] unencryptedData, int offset, int length, byte[] encryptionKey, long engineBoots, long engineTime, DecryptParams decryptParams) {
        byte[] initVect = new byte[16];
        long my_salt = this.salt.getNext();
        if (encryptionKey.length != this.keyBytes) {
            throw new IllegalArgumentException("Needed key length is " + this.keyBytes + ". Got " + encryptionKey.length + ".");
        }
        if (decryptParams.array == null || decryptParams.length < 8) {
            decryptParams.array = new byte[8];
        }
        decryptParams.length = 8;
        decryptParams.offset = 0;
        PrivAES.buildInitVector(engineBoots, engineTime, initVect);
        int i2 = 56;
        int j2 = 8;
        while (i2 >= 0) {
            initVect[j2] = (byte)(my_salt >> i2 & 0xFFL);
            i2 -= 8;
            ++j2;
        }
        System.arraycopy(initVect, 8, decryptParams.array, 0, 8);
        if (logger.isDebugEnabled()) {
            logger.debug((Serializable)((Object)("initVect is " + PrivAES.asHex(initVect))));
        }
        byte[] encryptedData = null;
        try {
            Cipher alg = this.doInit(encryptionKey, initVect);
            encryptedData = alg.doFinal(unencryptedData, offset, length);
            this.cipherPool.offerCipher(alg);
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("aes encrypt: Data to encrypt " + PrivAES.asHex(unencryptedData))));
                logger.debug((Serializable)((Object)("aes encrypt: used key " + PrivAES.asHex(encryptionKey))));
                logger.debug((Serializable)((Object)("aes encrypt: created privacy_params " + PrivAES.asHex(decryptParams.array))));
                logger.debug((Serializable)((Object)("aes encrypt: encrypted Data  " + PrivAES.asHex(encryptedData))));
            }
        }
        catch (Exception e2) {
            logger.error((Serializable)((Object)("Encrypt Exception " + e2)));
        }
        return encryptedData;
    }

    @Override
    public byte[] decrypt(byte[] cryptedData, int offset, int length, byte[] decryptionKey, long engineBoots, long engineTime, DecryptParams decryptParams) {
        byte[] initVect = new byte[16];
        if (decryptionKey.length != this.keyBytes) {
            throw new IllegalArgumentException("Needed key length is " + this.keyBytes + ". Got " + decryptionKey.length + ".");
        }
        PrivAES.buildInitVector(engineBoots, engineTime, initVect);
        System.arraycopy(decryptParams.array, decryptParams.offset, initVect, 8, 8);
        if (logger.isDebugEnabled()) {
            logger.debug((Serializable)((Object)("initVect is " + PrivAES.asHex(initVect))));
        }
        return this.doDecrypt(cryptedData, offset, length, decryptionKey, initVect);
    }

    private static void buildInitVector(long engineBoots, long engineTime, byte[] initVect) {
        initVect[0] = (byte)(engineBoots >> 24 & 0xFFL);
        initVect[1] = (byte)(engineBoots >> 16 & 0xFFL);
        initVect[2] = (byte)(engineBoots >> 8 & 0xFFL);
        initVect[3] = (byte)(engineBoots & 0xFFL);
        initVect[4] = (byte)(engineTime >> 24 & 0xFFL);
        initVect[5] = (byte)(engineTime >> 16 & 0xFFL);
        initVect[6] = (byte)(engineTime >> 8 & 0xFFL);
        initVect[7] = (byte)(engineTime & 0xFFL);
    }

    @Override
    public int getEncryptedLength(int scopedPDULength) {
        return scopedPDULength;
    }

    public static String asHex(byte[] buf) {
        return new SecretOctetString(buf).toHexString();
    }

    @Override
    public int getMinKeyLength() {
        return this.keyBytes;
    }

    @Override
    public int getMaxKeyLength() {
        return this.getMinKeyLength();
    }

    @Override
    public int getDecryptParamsLength() {
        return 8;
    }

    @Override
    public byte[] extendShortKey(byte[] shortKey, OctetString password, byte[] engineID, AuthenticationProtocol authProtocol) {
        int bytesToCopy;
        int length;
        byte[] extKey = new byte[this.getMinKeyLength()];
        System.arraycopy(shortKey, 0, extKey, 0, length);
        for (length = shortKey.length; length < extKey.length; length += bytesToCopy) {
            byte[] hash = authProtocol.hash(extKey, 0, length);
            if (hash == null) {
                return null;
            }
            bytesToCopy = extKey.length - length;
            if (bytesToCopy > authProtocol.getDigestLength()) {
                bytesToCopy = authProtocol.getDigestLength();
            }
            System.arraycopy(hash, 0, extKey, length, bytesToCopy);
        }
        return extKey;
    }
}

