/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.security;

import java.util.Arrays;
import java.util.Objects;

public class ByteArrayWindow {
    private byte[] value;
    private int offset;
    private int length;

    public ByteArrayWindow(byte[] value, int offset, int length) {
        this.value = value;
        this.offset = offset;
        this.length = length;
    }

    public byte[] getValue() {
        return this.value;
    }

    public void setValue(byte[] value) {
        this.value = value;
    }

    public int getOffset() {
        return this.offset;
    }

    public void set(int i2, byte b2) {
        if (i2 >= this.length) {
            throw new IndexOutOfBoundsException(i2 + " >= " + this.length);
        }
        if (i2 < 0) {
            throw new IndexOutOfBoundsException("" + i2);
        }
        this.value[i2 + this.offset] = b2;
    }

    public byte get(int i2) {
        if (i2 >= this.length) {
            throw new IndexOutOfBoundsException(i2 + " >= " + this.length);
        }
        if (i2 < 0) {
            throw new IndexOutOfBoundsException("" + i2);
        }
        return this.value[i2 + this.offset];
    }

    public int getLength() {
        return this.length;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ByteArrayWindow) {
            ByteArrayWindow other = (ByteArrayWindow)obj;
            if (other.length != this.length) {
                return false;
            }
            for (int i2 = 0; i2 < this.length; ++i2) {
                if (other.value[i2] == this.value[i2]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean equals(ByteArrayWindow other, int maxBytesToCompare) {
        if (other.length < maxBytesToCompare || this.length < maxBytesToCompare) {
            return false;
        }
        for (int i2 = 0; i2 < maxBytesToCompare; ++i2) {
            if (this.value[this.offset + i2] == other.value[other.offset + i2]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = Objects.hash(this.getOffset(), this.getLength());
        result = 31 * result + Arrays.hashCode(this.getValue());
        return result;
    }
}

