/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.security;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.security.AuthenticationProtocol;
import org.snmp4j.security.ByteArrayWindow;
import org.snmp4j.security.PrivAES;
import org.snmp4j.security.SecretOctetString;
import org.snmp4j.smi.OctetString;

public abstract class AuthGeneric
implements AuthenticationProtocol {
    private static final LogAdapter logger = LogFactory.getLogger(AuthGeneric.class);
    private static final long serialVersionUID = 4035708925348178888L;
    private static final int HMAC_BUFFER_SIZE = 0x100000;
    public static final int HMAC_BLOCK_SIZE = 64;
    private static final int DEFAULT_AUTHENTICATION_CODE_LENGTH = 12;
    protected int hmacBlockSize = 64;
    private int authenticationCodeLength = 12;
    private final int digestLength;
    private final String protoName;

    public AuthGeneric(String protoName, int digestLength) {
        this.protoName = protoName;
        this.digestLength = digestLength;
    }

    public AuthGeneric(String protoName, int digestLength, int authenticationCodeLength) {
        this(protoName, digestLength);
        this.authenticationCodeLength = authenticationCodeLength;
    }

    public AuthGeneric(String protoName, int digestLength, int authenticationCodeLength, int hmacBlockSize) {
        this(protoName, digestLength, authenticationCodeLength);
        this.hmacBlockSize = hmacBlockSize;
    }

    @Override
    public int getDigestLength() {
        return this.digestLength;
    }

    @Override
    public int getMaxKeyLength() {
        return this.getDigestLength();
    }

    @Override
    public int getAuthenticationCodeLength() {
        return this.authenticationCodeLength;
    }

    protected MessageDigest getDigestObject() {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance(this.protoName);
        }
        catch (NoSuchAlgorithmException e2) {
            throw new InternalError(this.protoName + " not supported in this VM.");
        }
        return md;
    }

    @Override
    public boolean isSupported() {
        try {
            MessageDigest.getInstance(this.protoName);
            return true;
        }
        catch (NoSuchAlgorithmException e2) {
            return false;
        }
    }

    @Override
    public boolean authenticate(byte[] authenticationKey, byte[] message, int messageOffset, int messageLength, ByteArrayWindow digest) {
        int i2;
        MessageDigest md = this.getDigestObject();
        byte[] authKey = authenticationKey;
        byte[] k_ipad = new byte[this.hmacBlockSize];
        byte[] k_opad = new byte[this.hmacBlockSize];
        for (i2 = 0; i2 < this.authenticationCodeLength; ++i2) {
            digest.set(i2, (byte)0);
        }
        if (authKey.length > this.hmacBlockSize) {
            authKey = md.digest(authenticationKey);
        }
        for (i2 = 0; i2 < authKey.length; ++i2) {
            k_ipad[i2] = (byte)(authKey[i2] ^ 0x36);
            k_opad[i2] = (byte)(authKey[i2] ^ 0x5C);
        }
        for (i2 = authKey.length; i2 < this.hmacBlockSize; ++i2) {
            k_ipad[i2] = 54;
            k_opad[i2] = 92;
        }
        md.update(k_ipad);
        md.update(message, messageOffset, messageLength);
        byte[] newDigest = md.digest();
        md.reset();
        md.update(k_opad);
        md.update(newDigest);
        newDigest = md.digest();
        for (i2 = 0; i2 < this.authenticationCodeLength; ++i2) {
            digest.set(i2, newDigest[i2]);
        }
        return true;
    }

    @Override
    public boolean isAuthentic(byte[] authenticationKey, byte[] message, int messageOffset, int messageLength, ByteArrayWindow digest) {
        ByteArrayWindow origDigest = new ByteArrayWindow(new byte[this.authenticationCodeLength], 0, this.authenticationCodeLength);
        System.arraycopy(digest.getValue(), digest.getOffset(), origDigest.getValue(), 0, this.authenticationCodeLength);
        if (!this.authenticate(authenticationKey, message, messageOffset, messageLength, digest)) {
            return false;
        }
        return digest.equals(origDigest, this.authenticationCodeLength);
    }

    @Override
    public byte[] changeDelta(byte[] oldKey, byte[] newKey, byte[] random) {
        MessageDigest hash = this.getDigestObject();
        int digestLength = hash.getDigestLength();
        if (logger.isDebugEnabled()) {
            logger.debug((Serializable)((Object)(this.protoName + "oldKey: " + PrivAES.asHex(oldKey))));
            logger.debug((Serializable)((Object)(this.protoName + "newKey: " + PrivAES.asHex(newKey))));
            logger.debug((Serializable)((Object)(this.protoName + "random: " + PrivAES.asHex(random))));
        }
        int iterations = (oldKey.length - 1) / hash.getDigestLength();
        SecretOctetString tmp = new SecretOctetString(oldKey);
        SecretOctetString delta = new SecretOctetString();
        for (int k2 = 0; k2 < iterations; ++k2) {
            tmp.append(random);
            hash.update(tmp.getValue());
            tmp.setValue(hash.digest());
            delta.append(new byte[digestLength]);
            for (int kk = 0; kk < digestLength; ++kk) {
                delta.set(k2 * digestLength + kk, (byte)(tmp.get(kk) ^ newKey[k2 * digestLength + kk]));
            }
        }
        tmp.append(random);
        hash.update(tmp.getValue());
        tmp = new SecretOctetString(hash.digest(), 0, oldKey.length - delta.length());
        for (int j2 = 0; j2 < tmp.length(); ++j2) {
            tmp.set(j2, (byte)(tmp.get(j2) ^ newKey[iterations * digestLength + j2]));
        }
        byte[] keyChange = new byte[random.length + delta.length() + tmp.length()];
        System.arraycopy(random, 0, keyChange, 0, random.length);
        System.arraycopy(delta.getValue(), 0, keyChange, random.length, delta.length());
        System.arraycopy(tmp.getValue(), 0, keyChange, random.length + delta.length(), tmp.length());
        if (logger.isDebugEnabled()) {
            logger.debug((Serializable)((Object)(this.protoName + "keyChange:" + new SecretOctetString(keyChange).toHexString())));
        }
        return keyChange;
    }

    @Override
    public byte[] passwordToKey(OctetString passwordString, byte[] engineID) {
        MessageDigest md = this.getDigestObject();
        ByteBuffer buf = ByteBuffer.allocate(0x100000);
        int password_index = 0;
        byte[] password = passwordString.getValue();
        for (int count = 0; count < 0x100000; count += this.hmacBlockSize) {
            for (int i2 = 0; i2 < this.hmacBlockSize; ++i2) {
                buf.put(password[password_index++ % password.length]);
            }
        }
        buf.flip();
        md.update(buf);
        byte[] digest = md.digest();
        if (logger.isDebugEnabled()) {
            logger.debug((Serializable)((Object)(this.protoName + " first digest: " + new SecretOctetString(digest).toHexString())));
        }
        md.reset();
        md.update(digest);
        md.update(engineID);
        md.update(digest);
        digest = md.digest();
        if (logger.isDebugEnabled()) {
            logger.debug((Serializable)((Object)(this.protoName + " localized key: " + new SecretOctetString(digest).toHexString())));
        }
        return digest;
    }

    @Override
    public byte[] hash(byte[] data) {
        MessageDigest md = this.getDigestObject();
        md.update(data);
        return md.digest();
    }

    @Override
    public byte[] hash(byte[] data, int offset, int length) {
        MessageDigest md = this.getDigestObject();
        md.update(data, offset, length);
        return md.digest();
    }
}

