/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.mp;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.snmp4j.SNMP4JSettings;
import org.snmp4j.TransportMapping;
import org.snmp4j.mp.MessageID;
import org.snmp4j.mp.PduHandle;
import org.snmp4j.mp.RequestStatistics;
import org.snmp4j.mp.SimpleMessageID;
import org.snmp4j.mp.TimedMessageID;
import org.snmp4j.security.SecurityModel;
import org.snmp4j.security.SecurityStateReference;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.OctetString;

public class StateReference<A extends Address>
implements Serializable {
    private static final long serialVersionUID = 7385215386971310699L;
    private A address;
    private transient TransportMapping<? super A> transportMapping;
    private byte[] contextEngineID;
    private byte[] contextName;
    private SecurityModel securityModel;
    private byte[] securityName;
    private int securityLevel;
    private SecurityStateReference securityStateReference;
    private MessageID msgID;
    private int maxSizeResponseScopedPDU;
    private int msgFlags;
    private PduHandle pduHandle;
    private byte[] securityEngineID;
    private int errorCode = 0;
    protected List<MessageID> retryMsgIDs;
    private int matchedMsgID;
    private long responseRuntimeNanos;

    public StateReference() {
    }

    public StateReference(PduHandle pduHandle, A peerAddress, TransportMapping<? super A> peerTransport, SecurityModel secModel, byte[] secName, int errorCode) {
        this(0, 0, 65535, pduHandle, (A)peerAddress, peerTransport, null, secModel, secName, 1, null, null, null, errorCode);
    }

    public StateReference(int msgID, int msgFlags, int maxSizeResponseScopedPDU, PduHandle pduHandle, A peerAddress, TransportMapping<? super A> peerTransport, byte[] secEngineID, SecurityModel secModel, byte[] secName, int secLevel, byte[] contextEngineID, byte[] contextName, SecurityStateReference secStateReference, int errorCode) {
        this.msgID = StateReference.createMessageID(msgID);
        this.msgFlags = msgFlags;
        this.maxSizeResponseScopedPDU = maxSizeResponseScopedPDU;
        this.pduHandle = pduHandle;
        this.address = peerAddress;
        this.transportMapping = peerTransport;
        this.securityEngineID = secEngineID;
        this.securityModel = secModel;
        this.securityName = secName;
        this.securityLevel = secLevel;
        this.contextEngineID = contextEngineID;
        this.contextName = contextName;
        this.securityStateReference = secStateReference;
        this.errorCode = errorCode;
    }

    public boolean isReportable() {
        return (this.msgFlags & 4) > 0;
    }

    public A getAddress() {
        return this.address;
    }

    public void setAddress(A address) {
        this.address = address;
    }

    public void setContextEngineID(byte[] contextEngineID) {
        this.contextEngineID = contextEngineID;
    }

    public byte[] getContextEngineID() {
        return this.contextEngineID;
    }

    public void setContextName(byte[] contextName) {
        this.contextName = contextName;
    }

    public byte[] getContextName() {
        return this.contextName;
    }

    public void setSecurityModel(SecurityModel securityModel) {
        this.securityModel = securityModel;
    }

    public SecurityModel getSecurityModel() {
        return this.securityModel;
    }

    public void setSecurityName(byte[] securityName) {
        this.securityName = securityName;
    }

    public byte[] getSecurityName() {
        return this.securityName;
    }

    public void setSecurityLevel(int securityLevel) {
        this.securityLevel = securityLevel;
    }

    public int getSecurityLevel() {
        return this.securityLevel;
    }

    public void setSecurityStateReference(SecurityStateReference securityStateReference) {
        this.securityStateReference = securityStateReference;
    }

    public SecurityStateReference getSecurityStateReference() {
        return this.securityStateReference;
    }

    public void setMsgID(MessageID msgID) {
        this.msgID = msgID;
    }

    public void setMsgID(int msgID) {
        this.msgID = StateReference.createMessageID(msgID);
    }

    public MessageID getMsgID() {
        return this.msgID;
    }

    public void setMsgFlags(int msgFlags) {
        this.msgFlags = msgFlags;
    }

    public int getMsgFlags() {
        return this.msgFlags;
    }

    public void setMaxSizeResponseScopedPDU(int maxSizeResponseScopedPDU) {
        this.maxSizeResponseScopedPDU = maxSizeResponseScopedPDU;
    }

    public int getMaxSizeResponseScopedPDU() {
        return this.maxSizeResponseScopedPDU;
    }

    public PduHandle getPduHandle() {
        return this.pduHandle;
    }

    public byte[] getSecurityEngineID() {
        return this.securityEngineID;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public TransportMapping<? super A> getTransportMapping() {
        return this.transportMapping;
    }

    public void setPduHandle(PduHandle pduHandle) {
        this.pduHandle = pduHandle;
        this.updateRequestStatisticsPduHandle(pduHandle);
    }

    protected void updateRequestStatisticsPduHandle(PduHandle pduHandle) {
        if (pduHandle instanceof RequestStatistics) {
            RequestStatistics requestStatistics = (RequestStatistics)((Object)pduHandle);
            requestStatistics.setTotalMessagesSent(1 + (this.retryMsgIDs != null ? this.retryMsgIDs.size() : 0));
            requestStatistics.setResponseRuntimeNanos(this.responseRuntimeNanos);
            if (this.msgID.getID() == this.matchedMsgID) {
                requestStatistics.setIndexOfMessageResponded(0);
            } else if (this.retryMsgIDs != null) {
                int index = 1;
                Iterator<MessageID> it = this.retryMsgIDs.iterator();
                while (it.hasNext()) {
                    if (it.next().getID() == this.matchedMsgID) {
                        requestStatistics.setIndexOfMessageResponded(index);
                        break;
                    }
                    ++index;
                }
            }
        }
    }

    public void setSecurityEngineID(byte[] securityEngineID) {
        this.securityEngineID = securityEngineID;
    }

    public void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    public void setTransportMapping(TransportMapping<? super A> transportMapping) {
        this.transportMapping = transportMapping;
    }

    protected boolean isMatchingMessageID(MessageID msgID) {
        return this.isMatchingMessageID(msgID.getID());
    }

    public boolean isMatchingMessageID(int msgID) {
        block3: {
            block2: {
                if (this.msgID.getID() != msgID) break block2;
                this.matchedMsgID = msgID;
                if (!(this.msgID instanceof TimedMessageID)) break block3;
                this.responseRuntimeNanos = System.nanoTime() - ((TimedMessageID)this.msgID).getCreationNanoTime();
                break block3;
            }
            if (this.retryMsgIDs != null) {
                for (MessageID retryMsgID : this.retryMsgIDs) {
                    if (retryMsgID.getID() != msgID) continue;
                    this.matchedMsgID = msgID;
                    if (!(this.msgID instanceof TimedMessageID)) break;
                    this.responseRuntimeNanos = System.nanoTime() - ((TimedMessageID)this.msgID).getCreationNanoTime();
                    break;
                }
            }
        }
        this.updateRequestStatisticsPduHandle(this.pduHandle);
        return this.matchedMsgID == msgID;
    }

    public boolean equals(Object o2) {
        if (o2 instanceof StateReference) {
            StateReference other = (StateReference)o2;
            return (this.isMatchingMessageID(other.msgID) || other.retryMsgIDs != null && other.retryMsgIDs.contains(this.msgID)) && this.equalsExceptMsgID(other);
        }
        return false;
    }

    public boolean equalsExceptMsgID(StateReference<?> other) {
        return this.pduHandle == null && other.pduHandle == null || this.pduHandle != null && this.pduHandle.equals(other.getPduHandle()) && Arrays.equals(this.securityEngineID, other.securityEngineID) && this.securityModel.equals(other.securityModel) && Arrays.equals(this.securityName, other.securityName) && this.securityLevel == other.securityLevel && Arrays.equals(this.contextEngineID, other.contextEngineID) && Arrays.equals(this.contextName, other.contextName);
    }

    public int hashCode() {
        return this.msgID.getID();
    }

    public String toString() {
        return "StateReference[msgID=" + this.msgID + ",pduHandle=" + this.pduHandle + ",securityEngineID=" + OctetString.fromByteArray(this.securityEngineID) + ",securityModel=" + this.securityModel + ",securityName=" + OctetString.fromByteArray(this.securityName) + ",securityLevel=" + this.securityLevel + ",contextEngineID=" + OctetString.fromByteArray(this.contextEngineID) + ",contextName=" + OctetString.fromByteArray(this.contextName) + ",retryMsgIDs=" + this.retryMsgIDs + "]";
    }

    public synchronized void addMessageIDs(List<MessageID> msgIDs) {
        if (this.retryMsgIDs == null) {
            this.retryMsgIDs = new ArrayList<MessageID>(msgIDs.size());
        }
        this.retryMsgIDs.addAll(msgIDs);
    }

    public synchronized List<MessageID> getMessageIDs() {
        ArrayList<MessageID> msgIDs = new ArrayList<MessageID>(1 + (this.retryMsgIDs != null ? this.retryMsgIDs.size() : 0));
        msgIDs.add(this.msgID);
        if (this.retryMsgIDs != null) {
            msgIDs.addAll(this.retryMsgIDs);
        }
        return msgIDs;
    }

    public static MessageID createMessageID(int msgID) {
        if (SNMP4JSettings.getSnmp4jStatistics() == SNMP4JSettings.Snmp4jStatistics.extended) {
            return new TimedMessageID(msgID);
        }
        return new SimpleMessageID(msgID);
    }
}

