/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.model.snmp.spi;

import org.snmp4j.PDU;

public enum SnmpErrorStatus {
    timeout(-1),
    lexicographicOrder(-2),
    report(-3),
    ioError(-4),
    noError(0),
    tooBig(1),
    noSuchName(2),
    badValue(3),
    readOnly(4),
    genErr(5),
    noAccess(6),
    wrongType(7),
    wrongLength(8),
    wrongValue(10),
    wrongEncoding(9),
    noCreation(11),
    inconsistentValue(12),
    resourceUnavailable(13),
    commitFailed(14),
    undoFailed(15),
    authorizationError(16),
    notWritable(17),
    inconsistentName(18);

    private final int errorStatus;

    private SnmpErrorStatus(int errorStatus) {
        this.errorStatus = errorStatus;
    }

    public int getErrorStatus() {
        return this.errorStatus;
    }

    public String toString() {
        return PDU.toErrorStatusText(this.getErrorStatus());
    }

    public static SnmpErrorStatus fromSnmpErrorStatus(int errorStatus) {
        for (SnmpErrorStatus snmpErrorStatus : SnmpErrorStatus.values()) {
            if (snmpErrorStatus.getErrorStatus() != errorStatus) continue;
            return snmpErrorStatus;
        }
        return null;
    }
}

