/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.model.snmp.proxy.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.snmp4j.Target;
import org.snmp4j.model.mapper.VariableBindingMapper;
import org.snmp4j.model.snmp.proxy.ChangeSet;
import org.snmp4j.model.snmp.proxy.SnmpProxyColumn;
import org.snmp4j.model.snmp.proxy.SnmpProxyIndexColumn;
import org.snmp4j.model.snmp.proxy.SnmpProxyRow;
import org.snmp4j.model.snmp.proxy.SnmpProxyRowFactory;
import org.snmp4j.model.snmp.proxy.SnmpTable;
import org.snmp4j.model.snmp.proxy.TaskId;
import org.snmp4j.model.snmp.proxy.impl.SnmpTableImplRO;
import org.snmp4j.model.snmp.proxy.impl.SnmpValueChange;
import org.snmp4j.model.snmp.proxy.impl.SnmpValuesChangeSet;
import org.snmp4j.model.snmp.spi.SnmpCell;
import org.snmp4j.model.snmp.spi.SnmpCellUpdateListener;
import org.snmp4j.model.snmp.spi.SnmpErrorStatus;
import org.snmp4j.model.snmp.spi.SnmpProxyCommitter;
import org.snmp4j.model.snmp.spi.SnmpProxyReloadListener;
import org.snmp4j.model.snmp.spi.SnmpService;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;

public class SnmpTableImpl<IC extends SnmpProxyIndexColumn, C extends SnmpProxyColumn, IT, T, R extends SnmpProxyRow<IT, T>>
extends SnmpTableImplRO<C, IC, IT, T, R>
implements SnmpTable<C, IC, IT, T, R> {
    private final SnmpProxyCommitter committer;
    private SnmpCellUpdateListener cellUpdateListener;

    public SnmpTableImpl(OID tableEntryOID, OctetString context, SnmpProxyCommitter snmpProxyCommitter, SnmpProxyRowFactory<R, IT, T> rowFactory, List<IC> indexColumns, List<C> columns, int pageSize) {
        super(tableEntryOID, context, rowFactory, columns, indexColumns, pageSize);
        this.committer = snmpProxyCommitter;
    }

    @Override
    public SnmpProxyCommitter getCommitter() {
        return this.committer;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (rowIndex >= 0 && columnIndex < this.getColumnCount() && rowIndex < this.rows.size()) {
            SnmpProxyRow row = (SnmpProxyRow)this.rows.get(rowIndex);
            if (columnIndex >= this.indexColumns.size() && columnIndex - this.indexColumns.size() < row.size()) {
                SnmpProxyColumn column = (SnmpProxyColumn)this.columns.get(columnIndex - this.indexColumns.size());
                OID instanceOID = new OID(column.getOID().getValue(), row.getIndex().getValue());
                SnmpValueChange change = new SnmpValueChange(instanceOID, column.getValueClass(), aValue, row.getValue(columnIndex - this.indexColumns.size()));
                SnmpValuesChangeSet changeSet = new SnmpValuesChangeSet();
                changeSet.addChange(change);
                SnmpValuesChangeSet validatedChangeSet = this.committer.validateChange(changeSet);
                if (validatedChangeSet.getStatus() == ChangeSet.ChangeStatus.PREPARED) {
                    this.committer.addChange(this, validatedChangeSet);
                    row.setValue(columnIndex - this.indexColumns.size(), validatedChangeSet.getChanges().get(0).getNewValue());
                    this.cellUpdated(rowIndex, columnIndex, validatedChangeSet.getChanges().get(0));
                } else {
                    this.cellUpdateValidationFailure(rowIndex, columnIndex, validatedChangeSet.getChanges().get(0));
                    row.setValue(columnIndex - this.indexColumns.size(), aValue);
                }
                this.fireTableCellUpdated(rowIndex, columnIndex);
            }
        }
    }

    @Override
    public SnmpCellUpdateListener getCellUpdateListener() {
        return this.cellUpdateListener;
    }

    @Override
    public void setCellUpdateListener(SnmpCellUpdateListener cellUpdateListener) {
        this.cellUpdateListener = cellUpdateListener;
    }

    protected void cellUpdateValidationFailure(int row, int column, SnmpValueChange change) {
        if (this.cellUpdateListener != null) {
            this.cellUpdateListener.cellUpdateFailed(row, column, change);
        }
    }

    protected void cellUpdated(int row, int column, SnmpValueChange change) {
        if (this.cellUpdateListener != null) {
            this.cellUpdateListener.cellUpdated(row, column, change);
        }
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex > this.indexColumns.size() && ((SnmpProxyColumn)this.columns.get(columnIndex - this.indexColumns.size())).getSmiMaxAccess().isWritable();
    }

    public OID getCellOID(int column, OID index) {
        return new OID(((SnmpProxyColumn)this.getColumns().get(column)).getOID().getValue(), index.getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertRow(R newRow) {
        OID newIndex = newRow.getIndex();
        List list = this.rows;
        synchronized (list) {
            int insertIndex = Collections.binarySearch(this.rows, newIndex, new SnmpTableImplRO.SnmpProxyRowOidComparator(this));
            if (insertIndex < 0) {
                insertIndex = Math.abs(insertIndex) - 1;
            }
            this.rows.add(insertIndex, newRow);
            this.fireTableRowsInserted(insertIndex, insertIndex);
            SnmpValuesChangeSet change = new SnmpValuesChangeSet();
            for (int j2 = 0; j2 < newRow.size(); ++j2) {
                change.addChange(new SnmpValueChange(this.getCellOID(j2, newIndex), this.getColumnClass(j2), newRow.getValue(j2), null));
            }
            this.committer.addChange(this, change);
        }
    }

    public R removeRow(int rowIndex) {
        return (R)((SnmpProxyRow)this.rows.remove(rowIndex));
    }

    public R removeRow(OID rowIndex) {
        int i2 = this.getRowNumber(rowIndex);
        if (i2 >= 0 && i2 < this.rows.size()) {
            return this.removeRow(i2);
        }
        return null;
    }

    @Override
    public void clear() {
        this.rows.clear();
    }

    @Override
    public void commitSuccess(List<SnmpValuesChangeSet> committedChanges) {
    }

    @Override
    public void commitFailure(List<SnmpValuesChangeSet> failedChanges, SnmpErrorStatus errorStatus, int errorIndex) {
    }

    @Override
    public TaskId reload(SnmpService snmpService, Target target, VariableBindingMapper variableBindingMapper, SnmpProxyReloadListener reloadListener) {
        TaskId taskId = super.reload(snmpService, target, variableBindingMapper, reloadListener);
        this.committer.removeAllChanges(this);
        return taskId;
    }

    @Override
    public int getRowNumber(OID rowIndex) {
        return Collections.binarySearch(this.rows, rowIndex, new SnmpTableImplRO.SnmpProxyRowOidComparator(this));
    }

    @Override
    public boolean doChange(SnmpValuesChangeSet changeSet) {
        return this.doChange(changeSet, true);
    }

    public boolean doChange(SnmpValuesChangeSet changeSet, boolean addToCommitter) {
        SnmpValuesChangeSet validatedChangeSet = this.committer.validateChange(changeSet);
        if (validatedChangeSet.getStatus() == ChangeSet.ChangeStatus.FAILURE) {
            return false;
        }
        if (addToCommitter) {
            this.committer.addChange(this, validatedChangeSet);
        }
        for (SnmpValueChange change : changeSet.getChanges()) {
            OID oid = change.getOid();
            SnmpCell cell = this.getCell(oid);
            int r2 = cell.getRow();
            if (r2 < 0) continue;
            SnmpProxyRow row = (SnmpProxyRow)this.rows.get(r2);
            int columnIndex = cell.getColumn();
            for (int i2 = 0; i2 < validatedChangeSet.getChanges().size(); ++i2) {
                row.setValue(columnIndex, validatedChangeSet.getChanges().get(i2).getNewValue());
            }
            this.fireTableCellUpdated(r2, columnIndex + this.indexColumns.size());
        }
        return true;
    }

    @Override
    public boolean undoChange(SnmpValuesChangeSet changeSet) {
        SnmpValuesChangeSet undoChangeSet = new SnmpValuesChangeSet(new ArrayList<SnmpValueChange>(), changeSet.getUserReference());
        for (SnmpValueChange change : changeSet.getChanges()) {
            undoChangeSet.addChange(new SnmpValueChange(change.getOid(), change.getValueClass(), change.getOldValue(), change.getNewValue()));
        }
        return this.doChange(undoChangeSet, ChangeSet.ChangeStatus.COMMITTED.equals((Object)changeSet.getStatus()));
    }
}

