/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.model.snmp.proxy.impl;

import java.util.List;
import org.snmp4j.model.snmp.proxy.SnmpProxyRow;
import org.snmp4j.model.snmp.spi.SnmpErrorStatus;
import org.snmp4j.smi.OID;

public class SnmpProxyRowImpl<IT, T>
implements SnmpProxyRow<IT, T> {
    private OID index;
    private List<IT> indexObjects;
    private List<T> columns;
    private SnmpErrorStatus errorStatus;
    private int errorIndex;

    public SnmpProxyRowImpl(OID index, List<IT> indexObjects, List<T> columns) {
        this.index = index;
        this.indexObjects = indexObjects;
        this.columns = columns;
    }

    @Override
    public OID getIndex() {
        return this.index;
    }

    @Override
    public List<IT> getIndexObjects() {
        return this.indexObjects;
    }

    @Override
    public List<T> getValues() {
        return this.columns;
    }

    @Override
    public IT getIndexValue(int indexColumn) {
        return this.indexObjects.get(indexColumn);
    }

    @Override
    public T getValue(int columnIndex) {
        return this.columns.get(columnIndex);
    }

    @Override
    public void setValue(int columnIndex, T value) {
        this.columns.set(columnIndex, value);
    }

    @Override
    public SnmpErrorStatus getError(int columnIndex) {
        if (columnIndex != this.errorIndex - 1) {
            return null;
        }
        return this.errorStatus;
    }

    public void setErrorStatus(int errorIndex, SnmpErrorStatus errorStatus) {
        this.errorIndex = errorIndex;
        this.errorStatus = errorStatus;
    }

    @Override
    public int size() {
        return this.columns.size();
    }

    public String toString() {
        return "SnmpProxyRowImpl{index=" + this.index + ", indexObjects=" + this.indexObjects + ", columns=" + this.columns + ", errorStatus=" + this.errorStatus + ", errorIndex=" + this.errorIndex + "}";
    }
}

