/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.model.snmp.proxy.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.snmp4j.model.mapper.VariableBindingMapper;
import org.snmp4j.model.snmp.proxy.SnmpProxyColumn;
import org.snmp4j.model.snmp.proxy.impl.SnmpValueChange;
import org.snmp4j.model.snmp.proxy.impl.SnmpValuesChangeSet;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.VariableBinding;

public abstract class SnmpProxyObjectHelper {
    public static List<VariableBinding> mapObjectsToVB(VariableBindingMapper variableBindingMapper, List<OID> oids, List<Object> objects) {
        ArrayList<VariableBinding> vbs = new ArrayList<VariableBinding>(Math.min(oids.size(), objects.size()));
        Iterator<OID> oit = oids.iterator();
        Iterator<Object> vit = objects.iterator();
        while (oit.hasNext() && vit.hasNext()) {
            vbs.add(variableBindingMapper.fromObject(oit.next(), vit.next()));
            oit.next();
            vit.next();
        }
        return vbs;
    }

    public static <Type> List<Type> mapVBsToObjects(VariableBindingMapper variableBindingMapper, List<VariableBinding> vbs, List<? extends SnmpProxyColumn> targetColumns) {
        ArrayList<Object> objects = new ArrayList<Object>(vbs.size());
        for (int i2 = 0; i2 < vbs.size() && i2 < targetColumns.size(); ++i2) {
            objects.add(variableBindingMapper.toObject(vbs.get(i2), targetColumns.get(i2).getValueClass()));
        }
        return objects;
    }

    public static void applyNewValues(VariableBindingMapper variableBindingMapper, SnmpValuesChangeSet changeSet) {
        for (SnmpValueChange change : changeSet.getChanges()) {
            VariableBinding vb = variableBindingMapper.fromObject(change.getOid(), change.getNewValue());
            change.setVariable(vb.getVariable());
        }
    }

    public static void applyOldValues(VariableBindingMapper variableBindingMapper, SnmpValuesChangeSet changeSet) {
        for (SnmpValueChange change : changeSet.getChanges()) {
            VariableBinding vb = variableBindingMapper.fromObject(change.getOid(), change.getOldValue());
            change.setVariable(vb.getVariable());
        }
    }
}

