/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.model.snmp.proxy.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.snmp4j.Target;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.model.mapper.VariableBindingMapper;
import org.snmp4j.model.snmp.proxy.ChangeSet;
import org.snmp4j.model.snmp.proxy.SnmpCommitListener;
import org.snmp4j.model.snmp.proxy.SnmpProxyObject;
import org.snmp4j.model.snmp.proxy.TaskId;
import org.snmp4j.model.snmp.proxy.impl.SnmpProxyObjectHelper;
import org.snmp4j.model.snmp.proxy.impl.SnmpValueChange;
import org.snmp4j.model.snmp.proxy.impl.SnmpValuesChangeSet;
import org.snmp4j.model.snmp.spi.SnmpErrorStatus;
import org.snmp4j.model.snmp.spi.SnmpProxyCommitter;
import org.snmp4j.model.snmp.spi.SnmpProxyReloadListener;
import org.snmp4j.model.snmp.spi.SnmpProxyReloader;
import org.snmp4j.model.snmp.spi.SnmpService;
import org.snmp4j.model.transaction.SnmpIsolationLevel;
import org.snmp4j.model.transaction.SnmpTransaction;
import org.snmp4j.model.transaction.SnmpTransactionStrategy;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.VariableBinding;

public class SnmpProxyAdapter
implements SnmpProxyCommitter,
SnmpProxyReloader,
SnmpTransactionStrategy {
    private static final LogAdapter LOG = LogFactory.getLogger(SnmpProxyAdapter.class);
    private SnmpService snmpService;
    private Target target;
    private VariableBindingMapper variableBindingMapper;
    private Map<SnmpProxyObject, List<SnmpValuesChangeSet>> commitQueue = new LinkedHashMap<SnmpProxyObject, List<SnmpValuesChangeSet>>();
    private Queue<ReloadTask> reloadQueue = new ConcurrentLinkedQueue<ReloadTask>();

    public SnmpProxyAdapter(SnmpService snmpService, Target target, VariableBindingMapper variableBindingMapper) {
        this.snmpService = snmpService;
        this.target = target;
        this.variableBindingMapper = variableBindingMapper;
    }

    @Override
    public SnmpValuesChangeSet validateChange(SnmpValuesChangeSet change) {
        SnmpValuesChangeSet result = new SnmpValuesChangeSet();
        result.setStatus(ChangeSet.ChangeStatus.PREPARED);
        for (SnmpValueChange valueChange : change.getChanges()) {
            SnmpValueChange validatedChange;
            try {
                VariableBinding vb = this.variableBindingMapper.fromObject(valueChange.getOid(), valueChange.getNewValue());
                if (vb == null) {
                    validatedChange = new SnmpValueChange(valueChange.getOid(), valueChange.getValueClass(), valueChange.getOldValue(), valueChange.getOldValue());
                    validatedChange.setErrorStatus(SnmpErrorStatus.badValue);
                    validatedChange.setStatus(ChangeSet.ChangeStatus.FAILURE);
                    result.addChange(validatedChange);
                    result.setStatus(ChangeSet.ChangeStatus.FAILURE);
                    continue;
                }
                result.addChange(new SnmpValueChange(valueChange.getOid(), valueChange.getValueClass(), this.variableBindingMapper.toObject(vb, valueChange.getValueClass()), valueChange.getOldValue()));
            }
            catch (Exception ex) {
                LOG.error("Validation of change " + change + " failed with exception: " + ex.getMessage(), ex);
                validatedChange = new SnmpValueChange(valueChange.getOid(), valueChange.getValueClass(), valueChange.getOldValue(), valueChange.getOldValue());
                validatedChange.setErrorStatus(SnmpErrorStatus.badValue);
                result.addChange(validatedChange);
                result.setStatus(ChangeSet.ChangeStatus.FAILURE);
            }
        }
        return result;
    }

    @Override
    public void addChange(SnmpProxyObject proxyObject, SnmpValuesChangeSet change) {
        List<SnmpValuesChangeSet> proxyCommitQueue = this.commitQueue.get(proxyObject);
        if (proxyCommitQueue == null) {
            proxyCommitQueue = new ArrayList<SnmpValuesChangeSet>();
            proxyCommitQueue.add(change);
            this.commitQueue.put(proxyObject, proxyCommitQueue);
        } else {
            proxyCommitQueue.add(change);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SnmpValuesChangeSet removeLastChangeSet(SnmpProxyObject proxyObject) {
        List<SnmpValuesChangeSet> proxyCommitQueue = this.commitQueue.get(proxyObject);
        if (proxyCommitQueue != null && !proxyCommitQueue.isEmpty()) {
            List<SnmpValuesChangeSet> list = proxyCommitQueue;
            synchronized (list) {
                if (!proxyCommitQueue.isEmpty()) {
                    return proxyCommitQueue.remove(proxyCommitQueue.size() - 1);
                }
            }
        }
        return null;
    }

    @Override
    public List<SnmpValuesChangeSet> removeAllChanges(SnmpProxyObject proxyObject) {
        return this.commitQueue.remove(proxyObject);
    }

    @Override
    public TaskId commitChanges(SnmpCommitListener commitListener) {
        CommitTask commitTask = new CommitTask(this.commitQueue, commitListener);
        commitTask.run();
        return commitTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumberOfPendingChanges() {
        int changeCount = 0;
        for (List<SnmpValuesChangeSet> proxyCommitQueue : this.commitQueue.values()) {
            if (proxyCommitQueue == null || proxyCommitQueue.isEmpty()) continue;
            List<SnmpValuesChangeSet> list = proxyCommitQueue;
            synchronized (list) {
                if (!proxyCommitQueue.isEmpty()) {
                    changeCount += proxyCommitQueue.size();
                }
            }
        }
        return changeCount;
    }

    @Override
    public void queueReload(SnmpProxyObject proxyObject) {
        this.reloadQueue.add(new ReloadTask(proxyObject));
    }

    @Override
    public List<TaskId> reloadQueued(SnmpProxyReloadListener reloadListener) {
        return this.processReloadQueue(reloadListener);
    }

    protected List<TaskId> processReloadQueue(SnmpProxyReloadListener reloadListener) {
        ArrayList<TaskId> taskIds = new ArrayList<TaskId>(this.reloadQueue.size());
        while (this.reloadQueue.size() > 0) {
            ReloadTask reloadTask = this.reloadQueue.poll();
            reloadTask.reloadListener = reloadListener;
            reloadTask.run();
            taskIds.add(reloadTask.getTaskId());
        }
        return taskIds;
    }

    @Override
    public SnmpIsolationLevel getIsolationLevel() {
        return SnmpIsolationLevel.fineGrained;
    }

    protected class CommitTask
    implements Runnable,
    TaskId {
        private Map<SnmpProxyObject, List<SnmpValuesChangeSet>> commits;
        private SnmpCommitListener commitListener;
        private volatile boolean finished;

        public CommitTask(Map<SnmpProxyObject, List<SnmpValuesChangeSet>> commits, SnmpCommitListener commitListener) {
            this.commits = commits;
            this.commitListener = commitListener;
        }

        @Override
        public void run() {
            SnmpTransaction snmpTransaction = SnmpProxyAdapter.this.snmpService.getSnmpTransaction(SnmpProxyAdapter.this);
            LOG.debug((Serializable)((Object)("Committing SNMP transaction " + snmpTransaction)));
            for (Map.Entry<SnmpProxyObject, List<SnmpValuesChangeSet>> commit : this.commits.entrySet()) {
                SnmpProxyObject proxyObject = commit.getKey();
                CommitListenerProxy commitListenerProxy = new CommitListenerProxy(proxyObject instanceof SnmpCommitListener ? (SnmpCommitListener)((Object)proxyObject) : null);
                List<SnmpValuesChangeSet> changeSetList = commit.getValue();
                for (SnmpValuesChangeSet changeSet : changeSetList) {
                    SnmpProxyObjectHelper.applyNewValues(SnmpProxyAdapter.this.variableBindingMapper, changeSet);
                    LOG.debug((Serializable)((Object)("Committing change set " + changeSet + " to target " + SnmpProxyAdapter.this.target)));
                    SnmpProxyAdapter.this.snmpService.update(snmpTransaction, SnmpProxyAdapter.this.target, changeSet, commitListenerProxy);
                }
            }
            SnmpProxyAdapter.this.snmpService.commit(snmpTransaction, this.commitListener);
            this.finished = true;
        }

        @Override
        public boolean isFinished() {
            return this.finished;
        }
    }

    protected class ReloadTask
    implements Runnable {
        private SnmpProxyObject snmpProxyObject;
        private SnmpProxyReloadListener reloadListener;
        private TaskId taskId;

        private ReloadTask(SnmpProxyObject snmpProxyObject) {
            this.snmpProxyObject = snmpProxyObject;
        }

        public SnmpProxyObject getSnmpProxyObject() {
            return this.snmpProxyObject;
        }

        @Override
        public void run() {
            this.taskId = this.snmpProxyObject.reload(SnmpProxyAdapter.this.snmpService, SnmpProxyAdapter.this.target, SnmpProxyAdapter.this.variableBindingMapper, this.reloadListener);
        }

        public TaskId getTaskId() {
            return this.taskId;
        }
    }

    protected class CommitListenerProxy
    implements SnmpCommitListener {
        private SnmpCommitListener snmpProxyObject;

        public CommitListenerProxy(SnmpCommitListener snmpProxyObject) {
            this.snmpProxyObject = snmpProxyObject;
        }

        @Override
        public void commitSuccess(List<SnmpValuesChangeSet> committedChanges) {
            if (this.snmpProxyObject != null) {
                this.snmpProxyObject.commitSuccess(committedChanges);
            }
            SnmpProxyAdapter.this.commitQueue.remove(this.snmpProxyObject);
        }

        @Override
        public void commitFailure(List<SnmpValuesChangeSet> failedChanges, SnmpErrorStatus errorStatus, int errorIndex) {
            if (this.snmpProxyObject != null) {
                this.snmpProxyObject.commitFailure(failedChanges, errorStatus, errorIndex);
            }
        }

        @Override
        public OctetString getContext() {
            if (this.snmpProxyObject == null) {
                return null;
            }
            return this.snmpProxyObject.getContext();
        }
    }
}

