/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.model.snmp.api;

import com.snmp4j.smi.SmiObject;
import com.snmp4j.smi.SmiObjectType;
import com.snmp4j.smi.SmiObjectTypeIndex;
import java.util.ArrayList;
import java.util.List;
import org.snmp4j.model.snmp.proxy.SnmpProxyColumn;
import org.snmp4j.model.snmp.proxy.SnmpProxyColumnFactory;
import org.snmp4j.model.snmp.proxy.SnmpProxyIndexColumn;
import org.snmp4j.model.snmp.proxy.impl.SnmpColumn;
import org.snmp4j.model.snmp.proxy.impl.SnmpIndexColumn;
import org.snmp4j.smi.MaxAccess;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.SubIndexInfo;

public class TableHelper {
    protected static SnmpProxyColumnFactory<String> columnFactory = new StringSnmpProxyColumnFactory();

    public static List<String> getTitlesFromNames(String prefix, List<String> names) {
        ArrayList<String> v = new ArrayList<String>(names.size() + 1);
        String commonPrefix = TableHelper.trimTitleSuffix(prefix);
        boolean match = false;
        block0: while (!match && commonPrefix.length() > 0) {
            match = true;
            for (String s2 : names) {
                if (s2.startsWith(commonPrefix)) continue;
                commonPrefix = TableHelper.trimTitleSuffix(commonPrefix);
                match = false;
                continue block0;
            }
        }
        if (match) {
            for (String s2 : names) {
                v.add(s2.substring(commonPrefix.length()));
            }
            return v;
        }
        return names;
    }

    protected static String trimTitleSuffix(String title) {
        String s2 = title;
        while (s2.length() > 2 && Character.isLowerCase(s2.charAt(s2.length() - 1))) {
            s2 = s2.substring(0, s2.length() - 1);
        }
        if (s2.length() < 2) {
            return "";
        }
        return s2.substring(0, s2.length() - 1);
    }

    public static List<SnmpProxyColumn<String>> buildColumns(SmiObjectType entryObjet) {
        return TableHelper.buildColumns(entryObjet, String.class, columnFactory);
    }

    public static <T> List<SnmpProxyColumn<T>> buildColumns(SmiObjectType child, Class<T> valueClass, SnmpProxyColumnFactory<T> columnFactory) {
        List<SmiObjectType> smiObjectTypes = child.getColumns();
        return TableHelper.getSnmpProxyColumns(child, valueClass, columnFactory, smiObjectTypes);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> List<SnmpProxyColumn<T>> getSnmpProxyColumns(SmiObjectType parentObjectType, Class<T> valueClass, SnmpProxyColumnFactory<T> columnFactory, List<SmiObjectType> smiObjectTypes) {
        void var7_9;
        ArrayList<SnmpProxyColumn<T>> columns = new ArrayList<SnmpProxyColumn<T>>(smiObjectTypes.size());
        ArrayList<String> columnNames = new ArrayList<String>(smiObjectTypes.size());
        for (SmiObject smiObject : smiObjectTypes) {
            columnNames.add(smiObject.getObjectName());
        }
        List<String> headers = TableHelper.getTitlesFromNames(parentObjectType.getObjectName(), columnNames);
        boolean bl = false;
        while (var7_9 < smiObjectTypes.size()) {
            SmiObjectType objectType = smiObjectTypes.get((int)var7_9);
            columns.add(columnFactory.createSnmpProxyColumn(objectType.getOID(), valueClass, objectType.getMaxAccess(), objectType.getSyntax().getSyntax(), objectType.getMinValueLength(), objectType.getMaxValueLength(), parentObjectType.equals(objectType) ? parentObjectType.getObjectName() : headers.get((int)var7_9)));
            ++var7_9;
        }
        return columns;
    }

    public static List<SnmpProxyIndexColumn<String>> buildIndexColumns(SmiObjectType child) {
        return TableHelper.buildIndexColumns(child, String.class, columnFactory);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> List<SnmpProxyIndexColumn<T>> buildIndexColumns(SmiObjectType child, Class<T> valueClass, SnmpProxyColumnFactory<T> columnFactory) {
        void var7_9;
        List<SmiObjectTypeIndex> smiObjectTypes = child.getIndexObjects();
        ArrayList<SnmpProxyIndexColumn<T>> indexColumns = new ArrayList<SnmpProxyIndexColumn<T>>(smiObjectTypes.size());
        ArrayList<String> columnNames = new ArrayList<String>(smiObjectTypes.size());
        for (SmiObject smiObject : smiObjectTypes) {
            columnNames.add(smiObject.getObjectName());
        }
        List<String> headers = TableHelper.getTitlesFromNames(child.getObjectName(), columnNames);
        boolean bl = false;
        while (var7_9 < smiObjectTypes.size()) {
            SmiObjectTypeIndex objectType = smiObjectTypes.get((int)var7_9);
            indexColumns.add(columnFactory.createSnmpProxyIndexColumn(objectType.getOID(), valueClass, objectType.getSyntax().getSyntax(), objectType.getMinValueLength(), objectType.getMaxValueLength(), headers.get((int)var7_9), objectType.getIndexInfo()));
            ++var7_9;
        }
        return indexColumns;
    }

    public static class StringSnmpProxyColumnFactory
    implements SnmpProxyColumnFactory<String> {
        @Override
        public SnmpProxyColumn<String> createSnmpProxyColumn(OID oid, Class<String> valueClass, MaxAccess smiMaxAccess, int smiSyntax, int minWidth, int maxWidth, String header) {
            return new SnmpColumn<String>(oid, valueClass, smiMaxAccess, smiSyntax, minWidth, maxWidth, header);
        }

        @Override
        public SnmpIndexColumn<String> createSnmpProxyIndexColumn(OID oid, Class<String> valueClass, int smiSyntax, int minWidth, int maxWidth, String header, SubIndexInfo smiIndexInfo) {
            return new SnmpIndexColumn<String>(oid, valueClass, smiSyntax, minWidth, maxWidth, header, smiIndexInfo);
        }
    }
}

