/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.model.snmp.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.snmp4j.Target;
import org.snmp4j.model.snmp.proxy.impl.SnmpValuesChangeSet;
import org.snmp4j.model.snmp.spi.SnmpErrorStatus;
import org.snmp4j.smi.VariableBinding;

public class LocalTransaction {
    private Target target;
    private Queue<SnmpValuesChangeSet> pending = new ConcurrentLinkedDeque<SnmpValuesChangeSet>();
    private List<VariableBinding> failed = new ArrayList<VariableBinding>(1);
    private SnmpErrorStatus snmpErrorStatus;
    private int errorIndex = 0;
    private List<SnmpValuesChangeSet> committed = Collections.synchronizedList(new ArrayList());

    public LocalTransaction(Target target) {
        this.target = target;
    }

    public Target getTarget() {
        return this.target;
    }

    public Queue<SnmpValuesChangeSet> getPending() {
        return this.pending;
    }

    public List<SnmpValuesChangeSet> getCommitted() {
        return this.committed;
    }

    public void addUpdate(SnmpValuesChangeSet changeSet) {
        this.pending.add(changeSet);
    }

    public boolean isSuccess() {
        return this.failed.isEmpty();
    }

    public SnmpErrorStatus getErrorStatus() {
        return this.snmpErrorStatus;
    }

    public List<VariableBinding> getFailedVariableBindings() {
        return this.failed;
    }

    public int getErrorIndex() {
        return this.errorIndex;
    }

    public void setErrorIndex(int errorIndex) {
        this.errorIndex = errorIndex;
    }

    public void setSnmpErrorStatus(SnmpErrorStatus snmpErrorStatus) {
        this.snmpErrorStatus = snmpErrorStatus;
    }

    public String toString() {
        return "LocalTransaction{target=" + this.target + ", pending=" + this.pending + ", failed=" + this.failed + ", snmpErrorStatus=" + this.snmpErrorStatus + ", errorIndex=" + this.errorIndex + ", committed=" + this.committed + "}";
    }
}

