/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.model.snmp.agent;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.TreeMap;
import java.util.WeakHashMap;
import org.snmp4j.Target;
import org.snmp4j.agent.DefaultMOContextScope;
import org.snmp4j.agent.DefaultMOQuery;
import org.snmp4j.agent.MOQuery;
import org.snmp4j.agent.MOScope;
import org.snmp4j.agent.MOServer;
import org.snmp4j.agent.ManagedObject;
import org.snmp4j.agent.mo.MOColumn;
import org.snmp4j.agent.mo.MOMutableTableModel;
import org.snmp4j.agent.mo.MOMutableTableRow;
import org.snmp4j.agent.mo.MOScalar;
import org.snmp4j.agent.mo.MOTable;
import org.snmp4j.agent.mo.MOTableCellInfo;
import org.snmp4j.agent.mo.MOTableRow;
import org.snmp4j.agent.request.Request;
import org.snmp4j.agent.request.RequestStatus;
import org.snmp4j.agent.request.SubRequest;
import org.snmp4j.agent.request.SubRequestIterator;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.model.snmp.api.CommitStatus;
import org.snmp4j.model.snmp.api.GlobalTransaction;
import org.snmp4j.model.snmp.api.LocalTransaction;
import org.snmp4j.model.snmp.proxy.SnmpCommitListener;
import org.snmp4j.model.snmp.proxy.impl.SnmpValuesChangeSet;
import org.snmp4j.model.snmp.spi.SnmpCommitResult;
import org.snmp4j.model.snmp.spi.SnmpErrorStatus;
import org.snmp4j.model.snmp.spi.SnmpException;
import org.snmp4j.model.snmp.spi.SnmpRow;
import org.snmp4j.model.snmp.spi.SnmpRowListener;
import org.snmp4j.model.snmp.spi.SnmpService;
import org.snmp4j.model.transaction.SnmpIsolationLevel;
import org.snmp4j.model.transaction.SnmpTransaction;
import org.snmp4j.model.transaction.SnmpTransactionStrategy;
import org.snmp4j.smi.Null;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;

public class SNMP4JAgentSnmpService
implements SnmpService {
    private static final LogAdapter LOG = LogFactory.getLogger(SNMP4JAgentSnmpService.class);
    private final MOServer[] moServers;
    private static final OctetString DEFAULT_CONTEXT = new OctetString();
    private final WeakHashMap<GlobalTransaction, Map<Target, LocalTransaction>> transactions = new WeakHashMap();

    public SNMP4JAgentSnmpService(MOServer[] moServers) {
        this.moServers = moServers;
    }

    @Override
    public void initTransports() throws IOException {
    }

    @Override
    public List<? extends VariableBinding> get(Target target, List<OID> oidList) throws SnmpException {
        OctetString context = DEFAULT_CONTEXT;
        MOServer moServer = this.getServer(context);
        LOG.debug((Serializable)((Object)("GET on target " + target + " OIDs=" + oidList)));
        ArrayList<VariableBinding> vbs = new ArrayList<VariableBinding>();
        for (OID oid : oidList) {
            DefaultMOContextScope scope = new DefaultMOContextScope(context, oid, true, oid, true);
            DefaultMOQuery moQuery = new DefaultMOQuery(scope, false);
            ManagedObject<?> mo = moServer.lookup(moQuery);
            LOG.debug((Serializable)((Object)("Got MO = " + mo + " for query " + moQuery)));
            if (mo == null) continue;
            AgentSubRequest subRequest = new AgentSubRequest(scope, moQuery, new VariableBinding(oid), 0);
            mo.get(subRequest);
            LOG.debug((Serializable)((Object)("GET SubRequest returned " + subRequest + " for OID = " + oid)));
            if (subRequest.hasError()) {
                throw new SnmpException(SnmpErrorStatus.fromSnmpErrorStatus(subRequest.getErrorStatus()));
            }
            vbs.add(subRequest.getVariableBinding());
        }
        LOG.debug((Serializable)((Object)("Returning GET VBS = " + vbs)));
        return vbs;
    }

    @Override
    public List<? extends VariableBinding> getNext(Target target, List<OID> oidList) throws SnmpException {
        OctetString context = DEFAULT_CONTEXT;
        MOServer moServer = this.getServer(context);
        LOG.debug((Serializable)((Object)("GETNEXT on target " + target + " OIDs=" + oidList)));
        ArrayList<VariableBinding> vbs = new ArrayList<VariableBinding>();
        for (OID oid : oidList) {
            DefaultMOContextScope scope = new DefaultMOContextScope(context, oid, false, oid, true);
            DefaultMOQuery moQuery = new DefaultMOQuery(scope, false);
            ManagedObject<?> mo = moServer.lookup(moQuery);
            LOG.debug((Serializable)((Object)("Got MO = " + mo + " for query " + moQuery)));
            if (mo == null) continue;
            AgentSubRequest subRequest = new AgentSubRequest(scope, moQuery, new VariableBinding(oid), 0);
            mo.next(subRequest);
            LOG.debug((Serializable)((Object)("NEXT SubRequest returned " + subRequest + " for OID = " + oid)));
            if (subRequest.hasError()) {
                throw new SnmpException(SnmpErrorStatus.fromSnmpErrorStatus(subRequest.getErrorStatus()));
            }
            vbs.add(subRequest.getVariableBinding());
        }
        LOG.debug((Serializable)((Object)("Returning NEXT VBS = " + vbs)));
        return vbs;
    }

    @Override
    public List<? extends VariableBinding> getSubTree(Target target, OID oid) throws SnmpException {
        OctetString context = DEFAULT_CONTEXT;
        MOServer moServer = this.getServer(context);
        LOG.debug((Serializable)((Object)("SUBTREE on target " + target + " OIDs=" + oid)));
        ArrayList<VariableBinding> vbs = new ArrayList<VariableBinding>();
        OID lastOID = oid;
        while (lastOID.startsWith(oid)) {
            DefaultMOContextScope scope = new DefaultMOContextScope(context, lastOID, false, oid.nextPeer(), false);
            DefaultMOQuery moQuery = new DefaultMOQuery(scope, false);
            ManagedObject<?> mo = moServer.lookup(moQuery);
            LOG.debug((Serializable)((Object)("Got MO = " + mo + " for query " + moQuery)));
            if (mo == null) break;
            AgentSubRequest subRequest = new AgentSubRequest(scope, moQuery, new VariableBinding(lastOID), 0);
            mo.next(subRequest);
            LOG.debug((Serializable)((Object)("NEXT SubRequest returned " + subRequest + " for OID = " + lastOID)));
            if (subRequest.hasError()) {
                throw new SnmpException(SnmpErrorStatus.fromSnmpErrorStatus(subRequest.getErrorStatus()));
            }
            if (subRequest.getVariableBinding().getOid().compareTo(lastOID) <= 0) break;
            vbs.add(subRequest.getVariableBinding());
            lastOID = subRequest.getVariableBinding().getOid();
        }
        LOG.debug((Serializable)((Object)("Returning SUBTREE VBS = " + vbs)));
        return vbs;
    }

    @Override
    public List<? extends SnmpRow> getTable(Target target, List<OID> columnOIDs, OID minIndex, OID maxIndex) throws SnmpException {
        OctetString context = DEFAULT_CONTEXT;
        MOServer moServer = this.getServer(context);
        LOG.debug((Serializable)((Object)("TABLE on target " + target + " OIDs=" + columnOIDs + ", minIndex = " + minIndex + ", maxIndex = " + maxIndex)));
        TreeMap<OID, SnmpRow> cellBuffer = new TreeMap<OID, SnmpRow>();
        HashSet visitedMOs = new HashSet();
        for (int c2 = 0; c2 < columnOIDs.size(); ++c2) {
            OID endCell;
            OID column = columnOIDs.get(c2);
            OID startCell = minIndex != null ? new OID(column.getValue(), minIndex.getValue()) : column;
            DefaultMOContextScope scope = new DefaultMOContextScope(context, startCell, minIndex != null, endCell = maxIndex != null ? new OID(column.getValue(), maxIndex.getValue()) : column.successor(), maxIndex != null);
            DefaultMOQuery moQuery = new DefaultMOQuery(scope, false);
            ManagedObject<?> mo = moServer.lookup(moQuery);
            if (mo == null || visitedMOs.contains(mo)) continue;
            LOG.debug((Serializable)((Object)("Found MO = " + mo + " for table query " + moQuery)));
            visitedMOs.add(mo);
            if (mo instanceof MOTable) {
                Iterator rowIterator = ((MOTable)mo).getModel().tailIterator(minIndex);
                while (rowIterator.hasNext()) {
                    MOTableRow row = (MOTableRow)rowIterator.next();
                    LOG.debug((Serializable)((Object)("ROW returned: " + row)));
                    if (maxIndex != null && row.getIndex().compareTo(maxIndex) > 0) continue;
                    List<VariableBinding> list = Arrays.asList(new VariableBinding[columnOIDs.size()]);
                    SnmpRow snmpRow = (SnmpRow)cellBuffer.get(row.getIndex());
                    if (snmpRow == null) {
                        snmpRow = new SnmpRow(row.getIndex(), list);
                    }
                    for (int cr = c2; cr < columnOIDs.size(); ++cr) {
                        if (!columnOIDs.get(cr).startsWith(((MOTable)mo).getOID())) continue;
                        for (int i2 = 0; i2 < row.size() && i2 < ((MOTable)mo).getColumnCount(); ++i2) {
                            if (columnOIDs.get(cr).last() != ((MOColumn)((MOTable)mo).getColumn(i2)).getColumnID()) continue;
                            Variable variable = row.getValue(i2);
                            if (variable == null) {
                                variable = Null.noSuchInstance;
                            }
                            list.set(cr, new VariableBinding(new OID(columnOIDs.get(cr).getValue(), snmpRow.getIndex().getValue()), variable));
                        }
                    }
                    LOG.debug((Serializable)((Object)("Putting ROW in cell buffer: " + snmpRow)));
                    cellBuffer.put(snmpRow.getIndex(), snmpRow);
                }
                continue;
            }
            List<? extends VariableBinding> columnValues = this.getSubTree(target, startCell);
            for (VariableBinding variableBinding : columnValues) {
                OID index = new OID(variableBinding.getOid().getValue(), column.size(), variableBinding.getOid().size() - column.size());
                SnmpRow row = (SnmpRow)cellBuffer.get(index);
                if (row == null) {
                    List<VariableBinding> columnVbs = Arrays.asList(new VariableBinding[columnOIDs.size()]);
                    row = new SnmpRow(index, columnVbs);
                    LOG.debug((Serializable)((Object)("Putting ROW in cell buffer: " + row)));
                    cellBuffer.put(index, row);
                    columnVbs.set(c2, variableBinding);
                    continue;
                }
                LOG.debug((Serializable)((Object)("Setting cell col=" + c2 + " to vb=" + variableBinding)));
                row.getVariableBindings().set(c2, variableBinding);
            }
        }
        LOG.debug((Serializable)((Object)("Returning ROWS = " + cellBuffer.values())));
        return new ArrayList(cellBuffer.values());
    }

    @Override
    public void getTable(Target target, List<OID> columnOIDs, OID minIndex, OID maxIndex, SnmpRowListener callback, Object userObject) throws SnmpException {
        List<? extends SnmpRow> rows = this.getTable(target, columnOIDs, minIndex, maxIndex);
        callback.beginUpdate(userObject);
        for (SnmpRow snmpRow : rows) {
            callback.nextRow(snmpRow, userObject);
        }
        callback.endUpdate(SnmpErrorStatus.noError, userObject);
    }

    @Override
    public void update(SnmpTransaction snmpTransaction, Target target, SnmpValuesChangeSet variableBindings, SnmpCommitListener snmpCommitListener) {
        Map<Target, LocalTransaction> localTransactions = this.transactions.get(snmpTransaction);
        if (localTransactions == null) {
            throw new IllegalStateException("Transaction not available: " + snmpTransaction);
        }
        LocalTransaction localTransaction = localTransactions.get(target);
        if (localTransaction == null) {
            localTransaction = new LocalTransaction(target);
            localTransactions.put(target, localTransaction);
        }
        localTransaction.addUpdate(variableBindings);
        if (snmpTransaction.isAutoCommit()) {
            this.commit(snmpTransaction, snmpCommitListener);
        }
    }

    @Override
    public List<? extends SnmpCommitResult> commit(SnmpTransaction transaction, SnmpCommitListener commitListener) {
        OctetString context = DEFAULT_CONTEXT;
        MOServer moServer = this.getServer(context);
        Map<Target, LocalTransaction> localTransactions = this.transactions.get(transaction);
        if (localTransactions == null) {
            throw new IllegalStateException("Transaction not available: " + transaction);
        }
        ArrayList<CommitStatus> commitResults = new ArrayList<CommitStatus>();
        for (Map.Entry<Target, LocalTransaction> localTransactionEntry : localTransactions.entrySet()) {
            LocalTransaction localTransaction = localTransactionEntry.getValue();
            Queue<SnmpValuesChangeSet> updates = localTransaction.getPending();
            ArrayList<SnmpValuesChangeSet> localTransactionPending = new ArrayList<SnmpValuesChangeSet>();
            ArrayList<? extends VariableBinding> chunk = new ArrayList<VariableBinding>();
            while (!updates.isEmpty() && localTransaction.getFailedVariableBindings().isEmpty()) {
                SnmpValuesChangeSet nextUpdate = updates.poll();
                chunk.addAll(nextUpdate.getVariableBindings());
                localTransactionPending.add(nextUpdate);
            }
            CommitStatus result = null;
            for (VariableBinding variableBinding : chunk) {
                DefaultMOContextScope scope = new DefaultMOContextScope(context, variableBinding.getOid(), true, variableBinding.getOid(), true);
                DefaultMOQuery moQuery = new DefaultMOQuery(scope, true);
                ManagedObject<?> mo = moServer.lookup(moQuery);
                LOG.debug((Serializable)((Object)("Committing VB = " + variableBinding + " to " + mo + " return by query " + moQuery)));
                if (mo == null) continue;
                if (mo instanceof MOTable && ((MOTable)mo).getModel() instanceof MOMutableTableModel) {
                    MOTable moTable = (MOTable)mo;
                    MOMutableTableModel tableModel = (MOMutableTableModel)moTable.getModel();
                    MOTableCellInfo cellInfo = moTable.getCellInfo(variableBinding.getOid());
                    OID rowIndex = cellInfo.getIndex();
                    Object row = moTable.getModel().getRow(rowIndex);
                    if (row == null) {
                        row = tableModel.createRow(rowIndex, moTable.getDefaultValues());
                        moTable.addRow(row);
                    }
                    if (!(row instanceof MOMutableTableRow)) continue;
                    MOMutableTableRow mutableTableRow = (MOMutableTableRow)row;
                    mutableTableRow.setValue(cellInfo.getColumn(), (Variable)variableBinding.getVariable().clone());
                    LOG.debug((Serializable)((Object)("Committed VB = " + variableBinding + " to row " + row + " at " + cellInfo)));
                    continue;
                }
                if (!(mo instanceof MOScalar)) continue;
                MOScalar moScalar = (MOScalar)mo;
                LOG.debug((Serializable)((Object)("Committing VB = " + variableBinding + " to scalar " + moScalar)));
                moScalar.setValue(variableBinding.getVariable());
            }
            if (result == null) {
                result = new CommitStatus(SnmpErrorStatus.noError, 0, localTransactionPending, Collections.emptyList());
            }
            commitResults.add(result);
        }
        return commitResults;
    }

    @Override
    public void rollback(SnmpTransaction transaction) {
        Map<Target, LocalTransaction> localTransactions = this.transactions.get(transaction);
        if (localTransactions != null) {
            for (LocalTransaction localTransaction : localTransactions.values()) {
                localTransaction.getPending().clear();
            }
        }
    }

    @Override
    public SnmpTransaction getSnmpTransaction(SnmpTransactionStrategy transactionStrategy) {
        GlobalTransaction globalTransaction = new GlobalTransaction(SnmpIsolationLevel.none == transactionStrategy.getIsolationLevel());
        this.transactions.put(globalTransaction, new LinkedHashMap());
        return globalTransaction;
    }

    @Override
    public boolean isAtomic(SnmpTransaction transaction) {
        return false;
    }

    private MOServer getServer(OctetString context) {
        for (MOServer moServer : this.moServers) {
            if (!moServer.isContextSupported(context)) continue;
            return moServer;
        }
        return null;
    }

    private class AgentSubRequest
    implements SubRequest {
        private final RequestStatus requestStatus;
        private final MOScope moScope;
        private final VariableBinding variableBinding;
        private Object undoValue;
        private ManagedObject targetMO;
        private MOQuery moQuery;
        private final int index;
        private volatile Object userObject;

        private AgentSubRequest(MOScope moScope, MOQuery moQuery, VariableBinding variableBinding, int index) {
            this.moScope = moScope;
            this.variableBinding = variableBinding;
            this.moQuery = moQuery;
            this.index = index;
            this.requestStatus = new RequestStatus();
        }

        @Override
        public boolean hasError() {
            return this.requestStatus.getErrorStatus() != 0;
        }

        @Override
        public void setErrorStatus(int errorStatus) {
            this.requestStatus.setErrorStatus(errorStatus);
        }

        @Override
        public int getErrorStatus() {
            return this.requestStatus.getErrorStatus();
        }

        @Override
        public RequestStatus getStatus() {
            return this.requestStatus;
        }

        @Override
        public MOScope getScope() {
            return this.moScope;
        }

        @Override
        public VariableBinding getVariableBinding() {
            return this.variableBinding;
        }

        public Request getRequest() {
            return null;
        }

        @Override
        public Object getUndoValue() {
            return this.undoValue;
        }

        @Override
        public void setUndoValue(Object undoInformation) {
            this.undoValue = undoInformation;
        }

        @Override
        public void completed() {
            this.requestStatus.setPhaseComplete(true);
        }

        @Override
        public boolean isComplete() {
            return this.requestStatus.isPhaseComplete();
        }

        public void setTargetMO(ManagedObject managedObject) {
            this.targetMO = managedObject;
        }

        public ManagedObject getTargetMO() {
            return this.targetMO;
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public void setQuery(MOQuery query) {
            this.moQuery = query;
        }

        @Override
        public MOQuery getQuery() {
            return this.moQuery;
        }

        public SubRequestIterator<? extends SubRequest> repetitions() {
            return null;
        }

        @Override
        public void updateNextRepetition() {
        }

        @Override
        public Object getUserObject() {
            return this.userObject;
        }

        @Override
        public void setUserObject(Object userObject) {
            this.userObject = userObject;
        }
    }
}

