/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.model.mapper;

import java.math.BigInteger;
import java.text.ParseException;
import java.util.GregorianCalendar;
import org.snmp4j.model.mapper.AbstractVariableBindingMapper;
import org.snmp4j.smi.Counter64;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.VariableBinding;

public class VariableBindingMapperJava
extends AbstractVariableBindingMapper<Long, BigInteger, String, GregorianCalendar, byte[]> {
    @Override
    public Long toLong(VariableBinding variableBinding) {
        return variableBinding.getVariable().toLong();
    }

    @Override
    public BigInteger toUnsignedLong(VariableBinding variableBinding) {
        if (variableBinding.getVariable() instanceof Counter64) {
            byte[] bytes = new byte[8];
            for (int i2 = 0; i2 < 8; ++i2) {
                bytes[i2] = (byte)(((Counter64)variableBinding.getVariable()).getValue() >> (7 - i2) * 8 & 0xFFL);
            }
            return new BigInteger(1, bytes);
        }
        return new BigInteger(variableBinding.getVariable().toString());
    }

    @Override
    public String toString(VariableBinding variableBinding) {
        return variableBinding.toValueString();
    }

    @Override
    public GregorianCalendar toDate(VariableBinding variableBinding) {
        if (variableBinding.getVariable() instanceof OctetString) {
            return VariableBindingMapperJava.makeCalendar((OctetString)variableBinding.getVariable());
        }
        throw new IllegalArgumentException("Only OctetString with DateAndTime TC can be converted to GregorianCalendar: " + variableBinding);
    }

    @Override
    public byte[] toBinary(VariableBinding variableBinding) {
        if (variableBinding.getVariable() instanceof OctetString) {
            return ((OctetString)variableBinding.getVariable()).getValue();
        }
        throw new IllegalArgumentException("Only OctetString can be converted to an byte array: " + variableBinding);
    }

    @Override
    public Object toObject(VariableBinding variableBinding, Class targetClass) {
        if (targetClass.equals(GregorianCalendar.class)) {
            return this.toDate(variableBinding);
        }
        if (targetClass.equals(String.class)) {
            return this.toString(variableBinding);
        }
        if (targetClass.equals(byte[].class)) {
            return this.toBinary(variableBinding);
        }
        if (targetClass.equals(Long.class)) {
            return this.toLong(variableBinding);
        }
        if (BigInteger.class.equals((Object)targetClass)) {
            return this.toUnsignedLong(variableBinding);
        }
        return null;
    }

    @Override
    public VariableBinding fromLong(OID oid, Long longValue) {
        try {
            return new VariableBinding(oid, longValue.toString());
        }
        catch (ParseException e2) {
            throw new IllegalArgumentException("The OID " + oid + " cannot be bound to a long value: " + e2.getMessage(), e2);
        }
    }

    @Override
    public VariableBinding fromUnsignedLong(OID oid, BigInteger unsignedLongValue) {
        try {
            return new VariableBinding(oid, unsignedLongValue.toString());
        }
        catch (ParseException e2) {
            throw new IllegalArgumentException("The OID " + oid + " cannot be bound to an unsigned long value: " + e2.getMessage(), e2);
        }
    }

    @Override
    public VariableBinding fromString(OID oid, String stringValue) {
        try {
            return new VariableBinding(oid, stringValue);
        }
        catch (ParseException e2) {
            throw new IllegalArgumentException("The OID " + oid + " cannot be bound to a string value: " + e2.getMessage(), e2);
        }
    }

    @Override
    public VariableBinding fromDate(OID oid, GregorianCalendar dateValue) {
        return new VariableBinding(oid, VariableBindingMapperJava.makeDateAndTime(dateValue));
    }

    @Override
    public VariableBinding fromBinary(OID oid, byte[] binaryValue) {
        return new VariableBinding(oid, new OctetString(binaryValue));
    }

    @Override
    public VariableBinding fromObject(OID oid, Object object) {
        if (object instanceof byte[]) {
            return this.fromBinary(oid, (byte[])object);
        }
        if (object instanceof GregorianCalendar) {
            return this.fromDate(oid, (GregorianCalendar)object);
        }
        if (object instanceof BigInteger) {
            return this.fromUnsignedLong(oid, (BigInteger)object);
        }
        if (object instanceof Long) {
            return this.fromLong(oid, (Long)object);
        }
        if (object == null) {
            return new VariableBinding(oid);
        }
        String s2 = object.toString();
        if (s2 == null) {
            return new VariableBinding(oid);
        }
        return this.fromString(oid, object.toString());
    }
}

