/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.model.mapper;

import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.snmp4j.model.mapper.VariableBindingMapper;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Variable;

public abstract class AbstractVariableBindingMapper<L, U, S, D, B>
implements VariableBindingMapper<L, U, S, D, B> {
    public static String formatLong(Long value, String displayHint) {
        Object s2 = null;
        if (displayHint == null || displayHint.length() < 1) {
            return null;
        }
        char c2 = displayHint.charAt(0);
        switch (c2) {
            case 'd': {
                int dec = -1;
                if (displayHint.length() > 2 && displayHint.charAt(1) == '-') {
                    dec = Integer.parseInt(displayHint.substring(2));
                }
                s2 = value.toString();
                if (dec <= 0) break;
                int pos = ((String)s2).length() - dec;
                if (pos <= 0) {
                    s2 = "." + (String)s2;
                    break;
                }
                s2 = ((String)s2).substring(0, pos) + "." + ((String)s2).substring(pos);
                break;
            }
            case 'b': {
                s2 = Long.toBinaryString(value);
                break;
            }
            case 'o': {
                s2 = Long.toOctalString(value);
                break;
            }
            case 'x': {
                s2 = Long.toHexString(value);
            }
        }
        return s2;
    }

    public static String formatString(OctetString value, String displayHint) {
        if (displayHint == null) {
            return value.toString();
        }
        OctetString output = new OctetString();
        int pd = 0;
        int pv = 0;
        block6: while (pv < value.length() && pd < displayHint.length()) {
            int end;
            int repetition = 1;
            Character sep = null;
            Character repTerm = null;
            if (displayHint.charAt(pd) == '*') {
                repetition = 0xFF & value.get(pv++);
            }
            for (end = ++pd; end < displayHint.length() && Character.isDigit(displayHint.charAt(end)); ++end) {
            }
            if (end == pd) {
                return value.toString();
            }
            String str = null;
            if (end >= displayHint.length()) {
                return value.toString();
            }
            str = displayHint.substring(pd, end);
            int n2 = Math.min(Integer.parseInt(str), 65535);
            pd = end;
            char mode = displayHint.charAt(pd++);
            if (pd < displayHint.length() && !Character.isDigit(displayHint.charAt(pd)) && displayHint.charAt(pd) != '*') {
                sep = Character.valueOf(displayHint.charAt(pd));
                if (++pd < displayHint.length() && !Character.isDigit(displayHint.charAt(pd)) && displayHint.charAt(pd) != '*') {
                    repTerm = Character.valueOf(displayHint.charAt(pd));
                    ++pd;
                }
            }
            for (int k2 = 0; k2 < repetition; ++k2) {
                if (pv + n2 >= value.length()) {
                    n2 = value.length() - pv;
                }
                if (n2 <= 0 || pv >= value.length()) continue block6;
                byte[] val = new byte[n2];
                for (int z = 0; z < n2; ++z) {
                    val[z] = value.get(pv + z);
                }
                pv += n2;
                if (mode == 'a' || mode == 't') {
                    output.append(val);
                } else {
                    long l2 = 0L;
                    for (byte aVal : val) {
                        l2 = l2 * 256L + (long)(aVal & 0xFF);
                    }
                    switch (mode) {
                        case 'd': {
                            output.append(Long.toString(l2));
                            break;
                        }
                        case 'b': {
                            output.append(Long.toBinaryString(l2));
                            break;
                        }
                        case 'o': {
                            output.append(Long.toOctalString(l2));
                            break;
                        }
                        case 'x': {
                            Object h2 = Long.toHexString(l2);
                            if (((String)h2).length() == 1) {
                                h2 = "0" + (String)h2;
                            }
                            output.append((String)h2);
                            break;
                        }
                    }
                }
                if (sep != null && pv < value.length()) {
                    output.append((byte)sep.charValue());
                }
                if (k2 + 1 < repetition) {
                    output.append((byte)repTerm.charValue());
                }
                if (pd < displayHint.length()) continue;
                pd = 0;
            }
        }
        return new String(output.getValue());
    }

    public static OctetString scanString(String format, String value) {
        if (format == null) {
            return new OctetString(value);
        }
        int i2 = 0;
        int fmt = 0;
        int vv = 0;
        if (value == null || format == null) {
            return null;
        }
        OctetString out = new OctetString();
        while (fmt < format.length() && i2 < value.length()) {
            int last = fmt;
            boolean have_pfx = false;
            int pfx = 0;
            while (fmt < format.length() && Character.isDigit(format.charAt(fmt))) {
                pfx = pfx * 10 + format.charAt(fmt) - 48;
                have_pfx = true;
                ++fmt;
            }
            if (!have_pfx) {
                pfx = 1;
            }
            boolean valid = false;
            switch (format.charAt(fmt)) {
                case 'a': 
                case 't': {
                    if (pfx < value.length() - i2) {
                        out.append(value.substring(i2, i2 + pfx).getBytes());
                        i2 += pfx;
                        break;
                    }
                    out.append(value.substring(i2).getBytes());
                    i2 = value.length();
                    break;
                }
                case 'b': {
                    int start = i2;
                    while (i2 < value.length() && (value.charAt(i2) == '0' || value.charAt(i2) == '1')) {
                        ++i2;
                    }
                    try {
                        vv = Integer.parseInt(value.substring(start, i2), 2);
                        valid = true;
                    }
                    catch (NumberFormatException nfe) {
                        valid = false;
                    }
                    break;
                }
                case 'd': {
                    int start = i2;
                    while (i2 < value.length() && Character.isDigit(value.charAt(i2))) {
                        ++i2;
                    }
                    try {
                        vv = Integer.parseInt(value.substring(start, i2), 10);
                        valid = true;
                    }
                    catch (NumberFormatException nfe) {
                        valid = false;
                    }
                    break;
                }
                case 'o': {
                    int start = i2;
                    while (i2 < value.length() && value.charAt(i2) >= '0' && value.charAt(i2) <= '7') {
                        ++i2;
                    }
                    try {
                        vv = Integer.parseInt(value.substring(start, i2), 8);
                        valid = true;
                    }
                    catch (NumberFormatException nfe) {
                        valid = false;
                    }
                    break;
                }
                case 'x': {
                    int start = i2;
                    while (i2 < value.length() && (value.charAt(i2) >= '0' && value.charAt(i2) <= '9' || value.charAt(i2) >= 'A' && value.charAt(i2) <= 'F' || value.charAt(i2) >= 'a' && value.charAt(i2) <= 'f')) {
                        ++i2;
                    }
                    try {
                        vv = Integer.parseInt(value.substring(start, i2), 16);
                        valid = true;
                    }
                    catch (NumberFormatException nfe) {
                        valid = false;
                    }
                    break;
                }
                default: {
                    return null;
                }
            }
            ++fmt;
            if (valid) {
                while (pfx > 0) {
                    byte c2 = (byte)(vv >> (pfx - 1) * 8 & 0xFF);
                    out.append(c2);
                    --pfx;
                }
            }
            if (fmt < format.length() && format.charAt(fmt) != '*') {
                if (!Character.isDigit(format.charAt(fmt))) {
                    ++fmt;
                }
                if (i2 < value.length() && !Character.isDigit(value.charAt(i2))) {
                    ++i2;
                }
            }
            if (fmt < format.length() || i2 >= value.length()) continue;
            if (valid) {
                fmt = last;
                continue;
            }
            return null;
        }
        return out;
    }

    public static Long scanLong(String format, String value) throws NumberFormatException {
        if (format == null) {
            return new Long(value);
        }
        Long out = null;
        long l2 = 0L;
        int v = 0;
        int dpt = 0;
        int i2 = 0;
        boolean sign = false;
        if (format.length() < 1 || value == null || value.length() < 1) {
            return null;
        }
        switch (format.charAt(0)) {
            case 'd': {
                if (format.length() == 1) {
                    out = new Long(value);
                    break;
                }
                if (format.length() < 2) {
                    return null;
                }
                if (format.charAt(1) != '-') break;
                if (Character.isDigit(format.charAt(2))) {
                    dpt = 0;
                    i2 = 0;
                    while (i2 + 2 < format.length() && Character.isDigit(format.charAt(2 + i2))) {
                        dpt = dpt * 10 + (format.charAt(2 + i2) - 48);
                        ++i2;
                    }
                }
                if (2 + i2 < format.length()) break;
                if (value.charAt(0) == '-') {
                    sign = true;
                    ++v;
                }
                int frac = -1;
                l2 = 0L;
                while (v < value.length() && (Character.isDigit(value.charAt(v)) || value.charAt(v) == '.')) {
                    if (value.charAt(v) == '.') {
                        if (frac >= 0) break;
                        frac = 0;
                    } else {
                        l2 = l2 * 10L + (long)(value.charAt(v) - 48);
                        if (frac >= 0) {
                            ++frac;
                        }
                    }
                    ++v;
                }
                if (v < value.length()) break;
                while (frac < dpt) {
                    l2 *= 10L;
                    ++frac;
                }
                while (frac > dpt) {
                    l2 /= 10L;
                    --frac;
                }
                out = sign ? -1L * l2 : l2;
                break;
            }
            case 'x': {
                if (format.length() > 1) break;
                out = Long.parseLong(value, 16);
                break;
            }
            case 'o': {
                if (format.length() > 1) break;
                out = Long.parseLong(value, 8);
                break;
            }
            case 'b': {
                if (format.length() > 1) break;
                out = Long.parseLong(value, 2);
                break;
            }
        }
        return out;
    }

    public static OctetString makeDateAndTime(GregorianCalendar dateAndTime) {
        int length = 0;
        byte[] bytes = new byte[11];
        bytes[length++] = (byte)(dateAndTime.get(1) / 256);
        bytes[length++] = (byte)(dateAndTime.get(1) % 256);
        bytes[length++] = (byte)(dateAndTime.get(2) + 1);
        bytes[length++] = (byte)dateAndTime.get(5);
        bytes[length++] = (byte)dateAndTime.get(11);
        bytes[length++] = (byte)dateAndTime.get(12);
        bytes[length++] = (byte)dateAndTime.get(13);
        bytes[length++] = (byte)(dateAndTime.get(14) / 100);
        if (dateAndTime.getTimeZone() != null) {
            TimeZone tz = dateAndTime.getTimeZone();
            bytes[length++] = (byte)(tz.getRawOffset() >= 0 ? 43 : 45);
            bytes[length++] = (byte)(tz.getOffset(dateAndTime.getTimeInMillis()) / 3600000);
            bytes[length++] = (byte)(tz.getOffset(dateAndTime.getTimeInMillis()) % 3600000 / 60000);
        }
        return new OctetString(bytes, 0, length);
    }

    public static GregorianCalendar makeCalendar(OctetString dateAndTimeValue) {
        int year = (dateAndTimeValue.get(0) & 0xFF) * 256 + (dateAndTimeValue.get(1) & 0xFF);
        int month = dateAndTimeValue.get(2) & 0xFF;
        int date = dateAndTimeValue.get(3) & 0xFF;
        int hour = dateAndTimeValue.get(4) & 0xFF;
        int minute = dateAndTimeValue.get(5) & 0xFF;
        int second = dateAndTimeValue.get(6) & 0xFF;
        int deci = dateAndTimeValue.get(7) & 0xFF;
        if (dateAndTimeValue.length() == 11) {
            String timezone = String.format("GMT%c%02d:%02d", dateAndTimeValue.get(8), dateAndTimeValue.get(9), dateAndTimeValue.get(10));
            GregorianCalendar tgc = new GregorianCalendar(TimeZone.getTimeZone(timezone));
            tgc.set(year, month - 1, date, hour, minute, second);
            tgc.set(14, deci * 100);
            return tgc;
        }
        GregorianCalendar gc = new GregorianCalendar(year, month - 1, date, hour, minute, second);
        gc.set(14, deci * 100);
        return gc;
    }

    public static int validateDateAndTime(Variable dateAndTime) {
        if (dateAndTime instanceof OctetString) {
            OctetString os = (OctetString)dateAndTime;
            if (os.length() != 8 && os.length() != 11) {
                return 8;
            }
            int month = os.get(2) & 0xFF;
            int date = os.get(3) & 0xFF;
            int hour = os.get(4) & 0xFF;
            int minute = os.get(5) & 0xFF;
            int second = os.get(6) & 0xFF;
            int deci = os.get(7) & 0xFF;
            if (month < 1 || month > 12 || date < 1 || date > 31 || hour > 23 || second > 59 || minute > 59 || deci > 9) {
                return 10;
            }
            if (os.length() == 11 && os.get(8) != 43 && os.get(8) != 45) {
                return 10;
            }
            return 0;
        }
        return 7;
    }
}

