/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.model.demo.mibbrowser;

import com.snmp4j.smi.SmiManager;
import com.snmp4j.smi.SmiObjectType;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumnModel;
import org.snmp4j.Target;
import org.snmp4j.model.mapper.VariableBindingMapper;
import org.snmp4j.model.snmp.proxy.SnmpTable;
import org.snmp4j.model.snmp.proxy.impl.SnmpColumn;
import org.snmp4j.model.snmp.proxy.impl.SnmpProxyObjectHelper;
import org.snmp4j.model.snmp.spi.SnmpService;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.VariableBinding;

public abstract class SimpleMibTableBrowser {
    private SnmpService snmpService;
    private SmiManager smiManager;
    private Target target;
    private VariableBindingMapper variableBindingMapper;
    SnmpTable table;
    private JTable snmpTable;
    private TableColumnModel columnModel;
    private JButton refreshButton;
    private JButton saveButton;
    private JButton closeButton;
    private JPanel rootPanel;
    private JButton addButton;

    public SimpleMibTableBrowser(final SnmpTable table, TableColumnModel columnModel, final SnmpService snmpService, final SmiManager smiManager, final Target target, final VariableBindingMapper variableBindingMapper) {
        this.table = table;
        this.smiManager = smiManager;
        this.columnModel = columnModel;
        this.snmpService = snmpService;
        this.target = target;
        this.variableBindingMapper = variableBindingMapper;
        this.$$$setupUI$$$();
        this.refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                table.reload(snmpService, target, variableBindingMapper, null);
            }
        });
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                SimpleMibTableBrowser.this.close();
            }
        });
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                table.getCommitter().commitChanges(table);
            }
        });
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                String indexString = JOptionPane.showInputDialog(this, (Object)"Row index value:");
                if (indexString != null) {
                    SnmpColumn firstColumn = (SnmpColumn)table.getColumns().get(0);
                    OID indexOID = new OID(firstColumn.getOID() + "." + indexString);
                    indexOID = new OID(indexOID.getValue(), firstColumn.getOID().size(), indexOID.size() - firstColumn.getOID().size());
                    List<VariableBinding> indexVBs = table.getIndexVariableBindings(indexOID);
                    ArrayList<VariableBinding> initialVBs = new ArrayList<VariableBinding>();
                    for (SnmpColumn snmpColumn : table.getColumns()) {
                        OID cellOID = new OID(snmpColumn.getOID().getValue(), indexOID.getValue());
                        SmiObjectType objectType = (SmiObjectType)smiManager.findSmiObject(snmpColumn.getOID());
                        VariableBinding vb = new VariableBinding(cellOID, objectType.createNewVariable());
                        initialVBs.add(vb);
                    }
                    Object newRow = table.getRowFactory().createProxyRow(indexOID, SnmpProxyObjectHelper.mapVBsToObjects(variableBindingMapper, indexVBs, table.getIndexColumns()), SnmpProxyObjectHelper.mapVBsToObjects(variableBindingMapper, initialVBs, table.getColumns()));
                    table.insertRow(newRow);
                }
            }
        });
    }

    public abstract void close();

    private void createUIComponents() {
        this.snmpTable = new JTable(this.table, this.columnModel);
    }

    public JPanel getRootPanel() {
        return this.rootPanel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JButton jButton2;
        JButton jButton3;
        JButton jButton4;
        JPanel jPanel;
        this.createUIComponents();
        this.rootPanel = jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        JPanel jPanel2 = new JPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(2, 5, 5));
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.fill = 1;
        jPanel.add((Component)jPanel3, gridBagConstraints2);
        this.refreshButton = jButton4 = new JButton();
        jButton4.setText("Refresh");
        Component component = jPanel3.add(jButton4);
        this.addButton = jButton3 = new JButton();
        jButton3.setText("Add Row");
        Component component2 = jPanel3.add(jButton3);
        this.saveButton = jButton2 = new JButton();
        jButton2.setText("Save");
        Component component3 = jPanel3.add(jButton2);
        this.closeButton = jButton = new JButton();
        jButton.setText("Close");
        Component component4 = jPanel3.add(jButton);
        JScrollPane jScrollPane = new JScrollPane();
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.weighty = 1.0;
        gridBagConstraints3.fill = 1;
        gridBagConstraints3.insets = new Insets(10, 10, 10, 10);
        jPanel.add((Component)jScrollPane, gridBagConstraints3);
        JTable jTable = this.snmpTable;
        jScrollPane.setViewportView(jTable);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.rootPanel;
    }
}

