/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.log;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;
import org.snmp4j.log.JavaLogAdapter;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.log.LogLevel;

public class JavaLogFactory
extends LogFactory {
    public static final String JAVA_CONSOLE_HANDLER = "java.util.logging.ConsoleHandler";
    public static final String JAVA_FILE_HANDLER = "java.util.logging.FileHandler";
    public static final String FH_ATTR_PATTERN = "pattern";
    public static final String DEFAULT_PATTERN = "%h/java%u.log";
    public static final String FH_ATTR_COUNT = "count";
    public static final String DEFAULT_COUNT = "1";
    public static final String FH_ATTR_APPEND = "append";
    public static final String FH_ATTR_LIMIT = "limit";
    public static final String DEFAULT_LIMIT = "0";
    public static final String FH_ATTR_FORMATTER = "formatter";
    public static final String SF_ATTR_FORMAT = "format";

    public JavaLogFactory() {
    }

    public JavaLogFactory(boolean removeExistingHandlers) {
        if (removeExistingHandlers) {
            for (Handler handler : Logger.getLogger("").getHandlers()) {
                Logger.getLogger("").removeHandler(handler);
            }
        }
    }

    @Override
    protected LogAdapter createLogger(Class<?> c2) {
        return new JavaLogAdapter(Logger.getLogger(c2.getName()));
    }

    @Override
    protected LogAdapter createLogger(String className) {
        return new JavaLogAdapter(Logger.getLogger(className));
    }

    @Override
    public LogAdapter getRootLogger() {
        return new JavaLogAdapter(Logger.getLogger(""));
    }

    @Override
    public Iterator<LogAdapter> loggers() {
        Enumeration<String> loggerNames = LogManager.getLogManager().getLoggerNames();
        return new JavaLogAdapterIterator(loggerNames);
    }

    @Override
    protected void addHandler(LogAdapter logAdapter, String handlerName, Map<String, String> handlerConfig) {
        StreamHandler handler = null;
        switch (handlerName) {
            case "java.util.logging.ConsoleHandler": {
                handler = new ConsoleHandler();
                break;
            }
            case "java.util.logging.FileHandler": {
                try {
                    FileHandler fileHandler = new FileHandler(handlerConfig.getOrDefault(FH_ATTR_PATTERN, DEFAULT_PATTERN), Long.parseLong(handlerConfig.getOrDefault(FH_ATTR_LIMIT, DEFAULT_LIMIT)), Integer.parseInt(handlerConfig.getOrDefault(FH_ATTR_COUNT, DEFAULT_COUNT)), Boolean.parseBoolean(handlerConfig.getOrDefault(FH_ATTR_APPEND, "false")));
                    String formatterClass = handlerConfig.get(FH_ATTR_FORMATTER);
                    if (formatterClass != null) {
                        String simpleFormat;
                        if (formatterClass.equals(SimpleFormatter.class.getName()) && (simpleFormat = handlerConfig.get(SF_ATTR_FORMAT)) != null) {
                            System.setProperty(SimpleFormatter.class.getName() + ".format", simpleFormat);
                        }
                        Formatter formatter = (Formatter)Class.forName(formatterClass).getConstructor(new Class[]{null}).newInstance(new Object[]{null});
                        fileHandler.setFormatter(formatter);
                    }
                    handler = fileHandler;
                    break;
                }
                catch (IOException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e2) {
                    e2.printStackTrace();
                }
            }
        }
        if (handler != null) {
            Level level;
            String handlerLevel = handlerConfig.get("level");
            if (handlerLevel != null && (level = JavaLogAdapter.fromSnmp4jToJdk(LogLevel.toLevel(handlerLevel))) != null) {
                handler.setLevel(level);
            }
            ((JavaLogAdapter)logAdapter).getJavaLogger().addHandler(handler);
        }
    }

    @Override
    protected void removeAllHandlers(LogAdapter logAdapter) {
        Handler[] handlers;
        Logger logger = ((JavaLogAdapter)logAdapter).getJavaLogger();
        for (Handler handler : handlers = logger.getHandlers()) {
            logger.removeHandler(handler);
        }
    }

    public class JavaLogAdapterIterator
    implements Iterator<LogAdapter> {
        private Enumeration<String> loggerNames;

        protected JavaLogAdapterIterator(Enumeration<String> loggerNames) {
            this.loggerNames = loggerNames;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean hasNext() {
            return this.loggerNames.hasMoreElements();
        }

        @Override
        public LogAdapter next() {
            String loggerName = this.loggerNames.nextElement();
            Logger logger = Logger.getLogger(loggerName);
            return new JavaLogAdapter(logger);
        }
    }
}

