/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.cfg;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.snmp4j.cfg.SnmpEngineIdProvider;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.smi.OctetString;

public class EngineBootsCounterFile
implements SnmpEngineIdProvider {
    private static final LogAdapter logger = LogFactory.getLogger(EngineBootsCounterFile.class);
    private final File bootCounterFile;
    private int boots = -1;
    private OctetString engineID;

    public EngineBootsCounterFile(File bootCounterFile) {
        this.bootCounterFile = bootCounterFile;
    }

    @Override
    public int updateEngineBoots() {
        this.boots = this.getLastEngineBoots();
        ++this.boots;
        if (this.boots <= 0) {
            this.boots = 1;
        }
        this.setEngineBoots(this.boots);
        return this.boots;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getLastEngineBoots() {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(this.bootCounterFile);
            ObjectInputStream ois = new ObjectInputStream(fis);
            int boots = ois.readInt();
            try {
                Object engineIdObject = ois.readObject();
                if (engineIdObject instanceof OctetString) {
                    this.engineID = (OctetString)engineIdObject;
                }
            }
            catch (Exception e2) {
                logger.warn((Serializable)((Object)("Engine boots counter file could not be read: " + e2.getMessage())));
            }
            if (logger.isInfoEnabled()) {
                logger.info("Engine boots is: " + boots + " for engine ID: " + this.engineID);
            }
            int n2 = boots;
            return n2;
        }
        catch (FileNotFoundException ex) {
            logger.warn((Serializable)((Object)("Could not find boot counter file: " + this.bootCounterFile)));
        }
        catch (IOException iox) {
            if (logger.isDebugEnabled()) {
                iox.printStackTrace();
            }
            logger.error((Serializable)((Object)("Failed to read boot counter: " + iox.getMessage())));
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ex1) {
                    logger.warn(ex1);
                }
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setEngineBoots(int engineBoots) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(this.bootCounterFile);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeInt(engineBoots);
            oos.writeObject(this.engineID);
            oos.close();
            if (logger.isInfoEnabled()) {
                logger.info("Wrote boot counter: " + engineBoots + " for engine ID: " + this.engineID);
            }
        }
        catch (FileNotFoundException fnfex) {
            logger.error((Serializable)((Object)("Boot counter configuration file not found: " + fnfex.getMessage())));
        }
        catch (IOException iox) {
            logger.error((Serializable)((Object)("Failed to write boot counter: " + iox.getMessage())));
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException ex1) {
                    logger.warn(ex1);
                }
            }
        }
    }

    @Override
    public int getEngineBoots() {
        if (this.boots < 0) {
            this.boots = this.getLastEngineBoots();
        }
        return this.boots;
    }

    public File getBootCounterFile() {
        return this.bootCounterFile;
    }

    @Override
    public OctetString getEngineId(OctetString defaultEngineID) {
        if (this.boots < 0) {
            this.getEngineBoots();
        }
        if (this.engineID == null) {
            this.engineID = defaultEngineID;
            this.setEngineBoots(this.boots);
            return this.engineID;
        }
        return this.engineID;
    }

    @Override
    public void resetEngineId(OctetString engineId) {
        this.engineID = engineId;
    }
}

