/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.mo.snmp.dh;

import java.io.IOException;
import java.math.BigInteger;
import org.snmp4j.agent.MOAccess;
import org.snmp4j.agent.mo.MOScalar;
import org.snmp4j.security.dh.DHGroups;
import org.snmp4j.security.dh.DHParameters;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;

public class UsmDHParametersImpl
extends MOScalar<OctetString> {
    private DHParameters dhParameters;

    public UsmDHParametersImpl(OID id, MOAccess access, OctetString value) {
        super(id, access, value);
        if (value != null && value.length() > 0) {
            try {
                this.decodeBER(value);
            }
            catch (IOException e2) {
                throw new IllegalArgumentException(value.toHexString());
            }
        } else {
            this.dhParameters = new DHParameters(DHGroups.P1, DHGroups.G, 128);
        }
    }

    public DHParameters getDHParamters() {
        return this.dhParameters;
    }

    public OctetString encodeBER() {
        BigInteger prime = this.dhParameters.getPrime();
        BigInteger generator = this.dhParameters.getGenerator();
        int privateValueLength = this.dhParameters.getPrivateValueLength();
        return DHParameters.encodeBER(prime, generator, privateValueLength);
    }

    public void decodeBER(OctetString berValue) throws IOException {
        this.dhParameters = DHParameters.getDHParametersFromBER(berValue);
    }

    @Override
    public OctetString getValue() {
        return this.encodeBER();
    }

    @Override
    public String toString() {
        return "UsmDHParametersImpl{" + this.dhParameters + "}";
    }
}

