/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.mo.snmp.dh;

import java.io.Serializable;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.interfaces.DHPublicKey;
import org.snmp4j.agent.MOAccess;
import org.snmp4j.agent.mo.MOMutableTableRow;
import org.snmp4j.agent.mo.MOTableRow;
import org.snmp4j.agent.mo.snmp.KeyChange;
import org.snmp4j.agent.mo.snmp.UsmMIB;
import org.snmp4j.agent.mo.snmp.dh.DHKeyInfo;
import org.snmp4j.agent.mo.snmp.dh.SnmpUsmDhObjectsMib;
import org.snmp4j.agent.request.SubRequest;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.security.SecurityProtocol;
import org.snmp4j.security.dh.DHOperations;
import org.snmp4j.security.dh.DHParameters;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Variable;

public class DHKeyChangeImpl
extends KeyChange {
    private static final LogAdapter LOGGER = LogFactory.getLogger(DHKeyChangeImpl.class);
    private DHParameters dhParameters;
    private DHOperations.KeyType keyType;
    private UsmMIB usmMIB;

    public DHKeyChangeImpl(int columnID, MOAccess access, OctetString defaultValue, DHParameters usmDHParameters, UsmMIB usmMIB, DHOperations.KeyType keyType) {
        super(columnID, access, defaultValue, true);
        this.usmMIB = usmMIB;
        this.keyType = keyType;
        this.dhParameters = usmDHParameters;
    }

    @Override
    public void get(SubRequest<?> subRequest, MOTableRow row, int column) {
        DHKeyInfo keyInfo = this.getDHKeyInfo(row, column);
        if (keyInfo != null && this.getAccess().isAccessibleForRead()) {
            if (keyInfo.getKeyPair() == null) {
                try {
                    keyInfo.generatePublicKey(this.dhParameters);
                }
                catch (NoSuchAlgorithmException e2) {
                    LOGGER.error("Failed to generate DH public key because Diffie-Hellman algorithm is not available", e2);
                }
                catch (InvalidAlgorithmParameterException e3) {
                    LOGGER.error("Failed to generate DH public key because of invalid parameters", e3);
                }
            }
            subRequest.getVariableBinding().setVariable(DHOperations.derivePublicKey(keyInfo.getKeyPair()));
        } else {
            subRequest.getStatus().setErrorStatus(6);
        }
        subRequest.completed();
    }

    @Override
    public void prepare(SubRequest<?> subRequest, MOTableRow row, MOTableRow changeSet, int column) {
        Variable variable;
        super.prepare(subRequest, row, changeSet, column);
        DHKeyInfo keyInfo = this.getDHKeyInfo(row, column);
        if (keyInfo == null || keyInfo.getKeyPair() == null || !(keyInfo.getKeyPair().getPublic() instanceof DHPublicKey)) {
            subRequest.setErrorStatus(10);
        }
        if ((variable = subRequest.getVariableBinding().getVariable()) instanceof OctetString) {
            OctetString yz = (OctetString)variable;
            OctetString yl = DHOperations.derivePublicKey(keyInfo.getKeyPair());
            try {
                OctetString yr = yz.substring(0, yl.length());
                if (!yr.equals(yl)) {
                    subRequest.setErrorStatus(10);
                }
            }
            catch (IndexOutOfBoundsException ioobe) {
                subRequest.setErrorStatus(10);
            }
        }
    }

    @Override
    public void commit(SubRequest<?> subRequest, MOTableRow row, MOTableRow changeSet, int column) {
        Variable variable = subRequest.getVariableBinding().getVariable();
        if (variable instanceof OctetString && row.getBaseRow() instanceof UsmMIB.UsmTableRow) {
            DHKeyInfo keyInfo = this.getDHKeyInfo(row, column);
            if (keyInfo == null) {
                subRequest.setErrorStatus(14);
                return;
            }
            OID protocolForKeyChangerotocol = this.usmMIB.getProtocolForKeyChange(subRequest.getRequest(), row.getIndex(), this.keyType);
            SecurityProtocol securityProtocol = this.usmMIB.getSecurityProtocols().getSecurityProtocol(protocolForKeyChangerotocol);
            if (securityProtocol == null) {
                LOGGER.warn((Serializable)((Object)("Unknown security protocol '" + protocolForKeyChangerotocol + "' specified for row " + row.getIndex())));
                subRequest.setErrorStatus(14);
                return;
            }
            int keyLength = securityProtocol.getMaxKeyLength();
            OctetString yz = (OctetString)variable;
            OctetString yl = DHOperations.derivePublicKey(keyInfo.getKeyPair());
            OctetString z = new OctetString(yz.substring(yl.length(), yz.length()));
            if (keyInfo.getKeyAgreement() == null) {
                keyInfo.getInitializedKeyAgreement();
            }
            byte[] sharedKey = DHOperations.computeSharedKey(keyInfo.getKeyAgreement(), z.getValue(), this.dhParameters);
            byte[] usmKey = DHOperations.deriveKey(sharedKey, keyLength);
            keyInfo.setUsmKey(usmKey);
            int usmMirrorKeyChangeObjectIndex = 3 + (column < 2 ? column : column + 1);
            ((MOMutableTableRow)row.getBaseRow()).setValue(usmMirrorKeyChangeObjectIndex, null);
        }
        super.commit(subRequest, row, changeSet, column);
    }

    @Override
    public void undo(SubRequest<?> subRequest, MOTableRow row, int column) {
        DHKeyInfo keyInfo = this.getDHKeyInfo(row, column);
        if (keyInfo != null) {
            keyInfo.clearUsmKey();
        }
        super.undo(subRequest, row, column);
    }

    DHKeyInfo getDHKeyInfo(MOTableRow row, int columnID) {
        if (row instanceof SnmpUsmDhObjectsMib.UsmDHUserKeyEntryRow) {
            SnmpUsmDhObjectsMib.UsmDHUserKeyEntryRow dhUsmUserEntry = (SnmpUsmDhObjectsMib.UsmDHUserKeyEntryRow)row;
            switch (columnID) {
                case 0: {
                    return dhUsmUserEntry.getAuthKeyChange();
                }
                case 1: {
                    return dhUsmUserEntry.getOwnAuthKeyChange();
                }
                case 2: {
                    return dhUsmUserEntry.getPrivKeyChange();
                }
                case 3: {
                    return dhUsmUserEntry.getOwnPrivKeyChange();
                }
            }
        }
        return null;
    }
}

