/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.mo.snmp;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.snmp4j.agent.MOAccess;
import org.snmp4j.agent.mo.MOMutableColumn;
import org.snmp4j.agent.mo.snmp.SnmpTagValue;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Variable;

public class SnmpTagList
extends MOMutableColumn<OctetString> {
    private static final OctetString TAG_DELIMITER = new OctetString(" \t\r\n");

    public SnmpTagList(int columnID, MOAccess access, OctetString defaultValue, boolean mutableInService) {
        super(columnID, 4, access, defaultValue, mutableInService);
    }

    @Override
    public synchronized int validate(OctetString newValue, OctetString oldValue) {
        int status = super.validate(newValue, oldValue);
        if (status == 0) {
            return SnmpTagList.isValidTagList(newValue);
        }
        return status;
    }

    public static Set<OctetString> getTags(OctetString tagList) {
        Collection<OctetString> tags = OctetString.split(tagList, TAG_DELIMITER);
        return new HashSet<OctetString>(tags);
    }

    public static int isValidTagList(Variable newValue) {
        if (!(newValue instanceof OctetString)) {
            return 7;
        }
        OctetString os = (OctetString)newValue;
        if (os.length() > 255) {
            return 8;
        }
        if (os.length() > 0) {
            if (SnmpTagValue.isDelimiter(os.get(0)) || SnmpTagValue.isDelimiter(os.get(os.length() - 1))) {
                return 3;
            }
            boolean lastWasDelimiter = false;
            for (int i2 = 0; i2 < os.length() - 1; ++i2) {
                boolean isDelimiter = SnmpTagValue.isDelimiter(os.get(i2));
                if (lastWasDelimiter && isDelimiter) {
                    return 3;
                }
                lastWasDelimiter = isDelimiter;
            }
        }
        return 0;
    }
}

