/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.mo.snmp;

import java.io.IOException;
import java.io.OutputStream;
import org.snmp4j.agent.mo.MOTable;
import org.snmp4j.asn1.BER;
import org.snmp4j.asn1.BERInputStream;
import org.snmp4j.smi.Gauge32;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.UnsignedInteger32;
import org.snmp4j.smi.Variable;

public class RowCount
implements Variable {
    private MOTable table;

    public RowCount() {
        this(null);
    }

    public RowCount(MOTable moTable) {
        this.table = moTable;
    }

    public long getValue() {
        return this.table == null || this.table.getModel() == null ? 0L : (long)this.table.getModel().getRowCount();
    }

    @Override
    public int compareTo(Variable o2) {
        long diff = this.getValue() - ((UnsignedInteger32)o2).getValue();
        if (diff < 0L) {
            return -1;
        }
        if (diff > 0L) {
            return 1;
        }
        return 0;
    }

    @Override
    public Object clone() {
        return new Gauge32(this.getValue());
    }

    @Override
    public int getSyntax() {
        return 66;
    }

    @Override
    public boolean isException() {
        return false;
    }

    @Override
    public int toInt() {
        return (int)this.getValue();
    }

    @Override
    public long toLong() {
        return this.getValue();
    }

    @Override
    public String getSyntaxString() {
        return new Gauge32().getSyntaxString();
    }

    @Override
    public OID toSubIndex(boolean impliedLength) {
        return new Gauge32(this.getValue()).toSubIndex(impliedLength);
    }

    @Override
    public void fromSubIndex(OID subIndex, boolean impliedLength) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isDynamic() {
        return true;
    }

    @Override
    public int getBERLength() {
        return UnsignedInteger32.getBERLengthFromValue(this.getValue());
    }

    @Override
    public int getBERPayloadLength() {
        return this.getBERLength();
    }

    @Override
    public void decodeBER(BERInputStream inputStream) throws IOException {
        throw new UnsupportedOperationException("RowCount cannot be decoded from BER");
    }

    @Override
    public void encodeBER(OutputStream outputStream) throws IOException {
        BER.encodeUnsignedInteger(outputStream, (byte)66, this.getValue());
    }
}

