/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.mo.snmp;

import org.snmp4j.agent.MOAccess;
import org.snmp4j.agent.mo.MOMutableColumn;
import org.snmp4j.agent.mo.MOValueValidationEvent;
import org.snmp4j.agent.mo.snmp.smi.Constraint;
import org.snmp4j.agent.mo.snmp.smi.Constraints;
import org.snmp4j.agent.mo.snmp.smi.ConstraintsImpl;
import org.snmp4j.agent.mo.snmp.smi.ValueConstraint;
import org.snmp4j.agent.mo.snmp.smi.ValueConstraintValidator;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Variable;

public class DisplayString<V extends OctetString>
extends MOMutableColumn<V> {
    public static final int MIN_SIZE = 0;
    public static final int MAX_SIZE = 255;
    private Constraints sizeConstraints = new ConstraintsImpl();

    public DisplayString(int columnID, MOAccess access, V defaultValue, boolean mutableInService) {
        super(columnID, 4, access, defaultValue, mutableInService);
    }

    public DisplayString(int columnID, MOAccess access, V defaultValue) {
        super(columnID, 4, access, defaultValue);
    }

    public DisplayString(int columnID, MOAccess access, V defaultValue, boolean mutableInService, int minSize, int maxSize) {
        super(columnID, 4, access, defaultValue, mutableInService);
        this.sizeConstraints.add(new Constraint(minSize, maxSize));
    }

    @Override
    public synchronized int validate(V newValue, V oldValue) {
        int status = super.validate(newValue, oldValue);
        if (status == 0) {
            status = DisplayString.validateDisplayString(newValue, this.sizeConstraints);
        }
        return status;
    }

    public static <V extends Variable> int validateDisplayString(V displayString, ValueConstraint sizeConstraints) {
        if (displayString instanceof OctetString) {
            OctetString os = (OctetString)displayString;
            int status = sizeConstraints.validate(displayString);
            if (status != 0) {
                return status;
            }
            for (int i2 = 0; i2 < os.length(); ++i2) {
                if (os.get(i2) < 0) {
                    return 10;
                }
                if (os.get(i2) != 13) continue;
                if (i2 + 1 == os.length()) {
                    return 10;
                }
                if (os.get(i2 + 1) == 0 || os.get(i2 + 1) == 10) continue;
                return 10;
            }
            return 0;
        }
        return 7;
    }

    public static class DisplayStringValidation
    extends ValueConstraintValidator {
        public DisplayStringValidation(Constraints valueConstraint) {
            super(valueConstraint);
        }

        public DisplayStringValidation(int minSize, int maxSize) {
            super(new ConstraintsImpl());
            ((ConstraintsImpl)this.getValueConstraint()).add(new Constraint(minSize, maxSize));
        }

        @Override
        public void validate(MOValueValidationEvent validationEvent) {
            Variable newValue = validationEvent.getNewValue();
            int status = DisplayString.validateDisplayString(newValue, this.getValueConstraint());
            validationEvent.setValidationStatus(status);
        }
    }
}

