/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.mo;

import java.util.Arrays;
import org.snmp4j.agent.mo.MOTableIndexValidator;
import org.snmp4j.agent.mo.MOTableSubIndex;
import org.snmp4j.smi.AbstractVariable;
import org.snmp4j.smi.Gauge32;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.IpAddress;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TimeTicks;
import org.snmp4j.smi.Variable;

public class MOTableIndex
implements MOTableIndexValidator {
    public static final int MAX_INDEX_OID_LENGTH = 127;
    private MOTableSubIndex[] subindexes;
    private boolean impliedLength = false;
    private MOTableIndexValidator validator;

    public MOTableIndex(MOTableSubIndex[] subIndexes) {
        if (subIndexes == null || subIndexes.length < 1) {
            throw new IllegalArgumentException("Index definition must have at least one sub-index");
        }
        this.subindexes = subIndexes;
    }

    public MOTableIndex(MOTableSubIndex[] subIndexes, boolean impliedLength) {
        this(subIndexes);
        this.impliedLength = impliedLength;
    }

    public MOTableIndex(MOTableSubIndex[] subIndexes, boolean impliedLength, MOTableIndexValidator validator) {
        this(subIndexes, impliedLength);
        this.validator = validator;
    }

    public MOTableSubIndex getIndex(int index) {
        return this.subindexes[index];
    }

    public boolean isImpliedLength() {
        return this.impliedLength;
    }

    public MOTableIndexValidator getValidator() {
        return this.validator;
    }

    public void setValidator(MOTableIndexValidator validator) {
        this.validator = validator;
    }

    public int size() {
        return this.subindexes.length;
    }

    private static boolean checkIndexBytes(OID index, long start, long end) {
        if (start < 0L || start > 127L || end < 0L || end > 127L) {
            return false;
        }
        for (int i2 = (int)start; i2 < index.size() && (long)i2 < end; ++i2) {
            if (index.getUnsigned(i2) <= 255L) continue;
            return false;
        }
        return true;
    }

    private static boolean isStringSyntax(int smiSyntax) {
        switch (smiSyntax) {
            case 4: 
            case 64: 
            case 68: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isValidIndex(OID index) {
        int i2;
        if (index != null && index.size() > 127) {
            return false;
        }
        int l2 = 0;
        for (i2 = 0; index != null && i2 < this.size() && l2 < index.size(); ++i2) {
            MOTableSubIndex subIndex = this.getIndex(i2);
            if (i2 + 1 == this.size() && this.isImpliedLength()) {
                int type = subIndex.getSmiSyntax();
                switch (type) {
                    case 4: 
                    case 64: {
                        if (MOTableIndex.checkIndexBytes(index, l2, index.size())) break;
                        return false;
                    }
                }
                return true;
            }
            if (subIndex.getMinLength() != subIndex.getMaxLength()) {
                if (index.size() < index.get(l2) + 1) {
                    return false;
                }
                if (index.get(l2) < subIndex.getMinLength() || index.get(l2) > subIndex.getMaxLength()) {
                    return false;
                }
                if (MOTableIndex.isStringSyntax(subIndex.getSmiSyntax()) && !MOTableIndex.checkIndexBytes(index, l2 + 1, (long)l2 + index.getUnsigned(l2) + 1L)) {
                    return false;
                }
                l2 = (int)((long)l2 + (index.getUnsigned(l2) + 1L));
                continue;
            }
            if (MOTableIndex.isStringSyntax(subIndex.getSmiSyntax()) && !MOTableIndex.checkIndexBytes(index, l2, l2 + subIndex.getMaxLength())) {
                return false;
            }
            l2 += subIndex.getMaxLength();
        }
        return index.size() == l2 && i2 >= this.size() && (this.validator == null || this.validator.isValidIndex(index));
    }

    private static Variable getIndexVariable(MOTableSubIndex subIndexDef, OID subIndex, boolean impliedLength) {
        switch (subIndexDef.getSmiSyntax()) {
            case 4: {
                if (impliedLength || subIndexDef.getMinLength() == subIndexDef.getMaxLength()) {
                    OctetString s2 = new OctetString(subIndex.toByteArray());
                    return s2;
                }
                OID suffix = new OID(subIndex.getValue(), 1, subIndex.size() - 1);
                return new OctetString(suffix.toByteArray());
            }
            case 6: {
                if (impliedLength || subIndexDef.getMinLength() == subIndexDef.getMaxLength()) {
                    return subIndex;
                }
                return new OID(subIndex.getValue(), 1, subIndex.size() - 1);
            }
            case 66: {
                return new Gauge32((long)subIndex.get(subIndex.size() - 1));
            }
            case 67: {
                return new TimeTicks((long)subIndex.get(subIndex.size() - 1));
            }
            case 2: {
                return new Integer32(subIndex.get(subIndex.size() - 1));
            }
            case 64: {
                return new IpAddress(subIndex.toString());
            }
        }
        return null;
    }

    public OID[] getIndexOIDs(OID index) {
        OID[] r2 = new OID[this.size()];
        int[] ind = index.getValue();
        int pos = 0;
        for (int i2 = 0; i2 < this.subindexes.length; ++i2) {
            if (i2 + 1 == this.size() && this.isImpliedLength()) {
                r2[i2] = new OID(ind, pos, index.size() - pos);
                break;
            }
            r2[i2] = this.subindexes[i2].getMinLength() != this.subindexes[i2].getMaxLength() ? new OID(ind, pos, index.get(pos) + 1) : new OID(index.getValue(), pos, this.subindexes[i2].getMaxLength());
            pos += r2[i2].size();
        }
        return r2;
    }

    public Variable[] getIndexValues(OID index) {
        OID[] oids = this.getIndexOIDs(index);
        Variable[] values = new Variable[oids.length];
        for (int i2 = 0; i2 < oids.length; ++i2) {
            boolean implied = this.isImpliedLength() && i2 + 1 == this.size();
            values[i2] = MOTableIndex.getIndexVariable(this.subindexes[i2], oids[i2], implied);
        }
        return values;
    }

    public OID getIndexOID(Variable[] indexValues) {
        if (indexValues.length != this.size()) {
            throw new IllegalArgumentException("Index value length != size()");
        }
        OID index = new OID();
        for (int i2 = 0; i2 < indexValues.length; ++i2) {
            MOTableSubIndex subIndex = this.subindexes[i2];
            if (indexValues[i2].getSyntax() != subIndex.getSmiSyntax()) {
                throw new IllegalArgumentException("Syntax of index value #" + i2 + " = " + indexValues[i2].getSyntaxString() + " does not match index definition " + AbstractVariable.getSyntaxString(this.subindexes[i2].getSmiSyntax()));
            }
            index.append(indexValues[i2].toSubIndex(i2 + 1 == indexValues.length && this.impliedLength || subIndex.getMinLength() == subIndex.getMaxLength()));
        }
        return index;
    }

    public String toString() {
        return "MOTableIndex{subindexes=" + Arrays.toString(this.subindexes) + ", impliedLength=" + this.impliedLength + ", validator=" + this.validator + "}";
    }
}

