/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.example;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.crypto.Cipher;
import org.snmp4j.MessageDispatcher;
import org.snmp4j.MessageDispatcherImpl;
import org.snmp4j.SNMP4JSettings;
import org.snmp4j.Session;
import org.snmp4j.TransportMapping;
import org.snmp4j.agent.AgentConfigManager;
import org.snmp4j.agent.DefaultMOServer;
import org.snmp4j.agent.DuplicateRegistrationException;
import org.snmp4j.agent.MOServer;
import org.snmp4j.agent.example.Modules;
import org.snmp4j.agent.example.Snmp4jDemoMib;
import org.snmp4j.agent.io.DefaultMOPersistenceProvider;
import org.snmp4j.agent.io.ImportMode;
import org.snmp4j.agent.io.MOInputFactory;
import org.snmp4j.agent.io.MOPersistenceProvider;
import org.snmp4j.agent.io.prop.PropertyMOInput;
import org.snmp4j.agent.mo.DefaultMOFactory;
import org.snmp4j.agent.mo.MOFactory;
import org.snmp4j.agent.mo.MOMutableTableRow;
import org.snmp4j.agent.mo.MOTableRowEvent;
import org.snmp4j.agent.mo.MOTableRowListener;
import org.snmp4j.agent.mo.snmp.SNMPv2MIB;
import org.snmp4j.agent.mo.snmp.TimeStamp;
import org.snmp4j.agent.mo.snmp.dh.DHKickstartParametersImpl;
import org.snmp4j.agent.mo.util.VariableProvider;
import org.snmp4j.cfg.EngineBootsCounterFile;
import org.snmp4j.cfg.EngineBootsProvider;
import org.snmp4j.log.ConsoleLogFactory;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.log.LogLevel;
import org.snmp4j.mp.CounterSupport;
import org.snmp4j.mp.MPv3;
import org.snmp4j.security.SecurityModels;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.Counter32;
import org.snmp4j.smi.GenericAddress;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.transport.TransportMappings;
import org.snmp4j.util.ArgumentParser;
import org.snmp4j.util.SnmpConfigurator;
import org.snmp4j.util.ThreadPool;

public class SampleAgent {
    public static final String COMMAND_LINE_OPTIONS = "-c[s{=SampleAgent.cfg}] -bc[s{=SampleAgent.bc}] +dhks[s] +u[s] +tls-trust-ca[s] +tls-peer-id[s] +tls-local-id[s] +tls-version[s{=TLSv1}<(TLSv1|TLSv1.1|TLSv1.2|TLSv1.3)>] +dtls-version[s{=TLSv1.2}<(TLSv1.0|TLSv1.2)>]+Djavax.net.ssl.keyStore +Djavax.net.ssl.keyStorePassword +Djavax.net.ssl.trustStore +Djavax.net.ssl.trustStorePassword +ts[s] +cfg[s] +x ";
    public static final String COMMAND_LINE_PARAMS = "#address[s<(udp|tcp|tls|dtls):.*[/[0-9]+]?>] ..";
    private static final LogAdapter logger;
    protected AgentConfigManager agent;
    protected MOServer server;
    private final String configFile;
    private final File bootCounterFile;
    protected Modules modules;
    protected Properties tableSizeLimits;

    public SampleAgent(Map<String, List<Object>> args) {
        LogFactory.getLogFactory().getRootLogger().setLogLevel(LogLevel.ALL);
        SNMP4JSettings.setReportSecurityLevelStrategy(SNMP4JSettings.ReportSecurityLevelStrategy.noAuthNoPrivIfNeeded);
        try {
            logger.info("Max supported AES key length is " + Cipher.getMaxAllowedKeyLength("AES"));
        }
        catch (NoSuchAlgorithmException e2) {
            logger.error("AES privacy not supported by this VM: ", e2);
        }
        this.server = new DefaultMOServer();
        MOServer[] moServers = new MOServer[]{this.server};
        String configFilename = null;
        if (args.containsKey("cfg")) {
            configFilename = (String)ArgumentParser.getValue(args, "cfg", 0);
        }
        this.configFile = (String)args.get("c").get(0);
        this.bootCounterFile = new File((String)args.get("bc").get(0));
        EngineBootsCounterFile engineBootsCounterFile = new EngineBootsCounterFile(this.bootCounterFile);
        OctetString ownEngineId = engineBootsCounterFile.getEngineId(new OctetString(MPv3.createLocalEngineID()));
        List<Object> tlsVersions = args.get("tls-version");
        if (tlsVersions != null && tlsVersions.size() > 0) {
            System.setProperty("org.snmp4j.arg.tlsVersion", (String)tlsVersions.get(0));
        }
        MOInputFactory configurationFactory = null;
        configurationFactory = this.createMOInputFactory(configFilename, ImportMode.restoreChanges);
        this.tableSizeLimits = SampleAgent.getTableSizeLimitsProperties(args);
        String dhKickstartInfoPath = (String)ArgumentParser.getFirstValue(args.get("dhks"));
        DefaultMOPersistenceProvider persistenceProvider = new DefaultMOPersistenceProvider(moServers, this.configFile);
        this.setupAgent(args, persistenceProvider, engineBootsCounterFile, ownEngineId, moServers, configurationFactory, args.get("address"), dhKickstartInfoPath);
    }

    protected MOInputFactory createMOInputFactory(String configFilename, ImportMode importMode) {
        InputStream configInputStream = SampleAgent.class.getResourceAsStream("SampleAgentConfig.properties");
        Properties props = new Properties();
        if (configFilename != null) {
            try {
                configInputStream = new FileInputStream(configFilename);
            }
            catch (FileNotFoundException ex1) {
                logger.error("Config file '" + configFilename + "' not found: " + ex1.getMessage(), ex1);
                throw new RuntimeException(ex1);
            }
        }
        try {
            props.load(configInputStream);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        MOInputFactory configurationFactory = () -> new PropertyMOInput(props, (VariableProvider)this.agent, importMode);
        return configurationFactory;
    }

    protected SampleAgent(Map<String, List<Object>> args, MOServer[] moServers, MOPersistenceProvider persistenceProvider, Properties tableSizeLimits, ImportMode importMode) {
        this.server = new DefaultMOServer();
        List<Object> tlsVersions = args.get("tls-version");
        if (tlsVersions != null && tlsVersions.size() > 0) {
            System.setProperty("org.snmp4j.arg.tlsVersion", (String)tlsVersions.get(0));
        }
        String configFilename = null;
        if (args.containsKey("cfg")) {
            configFilename = (String)ArgumentParser.getValue(args, "cfg", 0);
        }
        this.configFile = (String)args.get("c").get(0);
        this.tableSizeLimits = tableSizeLimits;
        String dhKickstartInfoPath = (String)ArgumentParser.getFirstValue(args.get("dhks"));
        this.bootCounterFile = new File((String)args.get("bc").get(0));
        EngineBootsCounterFile engineBootsCounterFile = new EngineBootsCounterFile(this.bootCounterFile);
        OctetString ownEngineId = engineBootsCounterFile.getEngineId(new OctetString(MPv3.createLocalEngineID()));
        this.setupAgent(args, persistenceProvider, engineBootsCounterFile, ownEngineId, moServers, this.createMOInputFactory(configFilename, importMode), args.get("address"), dhKickstartInfoPath);
    }

    protected void setupAgent(final Map<String, List<Object>> args, MOPersistenceProvider persistenceProvider, EngineBootsProvider engineBootsProvider, OctetString engineID, MOServer[] moServers, MOInputFactory configurationFactory, List<Object> listenAddress, String dhKickstartInfoPath) {
        final MessageDispatcherImpl messageDispatcher = new MessageDispatcherImpl();
        this.addListenAddresses(messageDispatcher, listenAddress);
        List<Object> dhKickstartParameters = Collections.emptyList();
        if (dhKickstartInfoPath != null) {
            File dhKickstartInfoFile = new File(dhKickstartInfoPath);
            if (dhKickstartInfoFile.canRead()) {
                try {
                    Properties kickstartProperties = new Properties();
                    FileInputStream fileInputStream = new FileInputStream(dhKickstartInfoFile);
                    kickstartProperties.load(fileInputStream);
                    fileInputStream.close();
                    dhKickstartParameters = DHKickstartParametersImpl.readFromProperties("org.snmp4j.", kickstartProperties);
                }
                catch (IOException iox) {
                    logger.error("Failed to load Diffie Hellman kickstart parameters from '" + dhKickstartInfoPath + "': " + iox.getMessage(), iox);
                }
            } else {
                logger.warn((Serializable)((Object)("Diffie Hellman kickstart parameters file cannot be read: " + dhKickstartInfoFile)));
            }
        }
        final SnmpConfigurator snmpConfigurator = new SnmpConfigurator(true);
        this.agent = new AgentConfigManager(engineID, messageDispatcher, null, moServers, ThreadPool.create("SampleAgent", 3), configurationFactory, persistenceProvider, engineBootsProvider, null, dhKickstartParameters){

            @Override
            protected Session createSnmpSession(MessageDispatcher dispatcher) {
                Session session = super.createSnmpSession(dispatcher);
                snmpConfigurator.configure(session, this.getUsm(), messageDispatcher, args);
                return session;
            }
        };
        this.agent.setContext(new SecurityModels(), new SecurityProtocols(SecurityProtocols.SecurityProtocolSet.maxCompatibility), new CounterSupport());
    }

    protected static Properties getTableSizeLimitsProperties(Map<String, List<Object>> args) {
        InputStream tableSizeLimitsInputStream = SampleAgent.class.getResourceAsStream("SampleAgentTableSizeLimits.properties");
        if (args.containsKey("ts")) {
            try {
                tableSizeLimitsInputStream = new FileInputStream((String)ArgumentParser.getValue(args, "ts", 0));
            }
            catch (FileNotFoundException ex1) {
                ex1.printStackTrace();
            }
        }
        Properties tableSizeLimits = new Properties();
        try {
            tableSizeLimits.load(tableSizeLimitsInputStream);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return tableSizeLimits;
    }

    protected void addListenAddresses(MessageDispatcher md, List<Object> addresses) {
        for (Object addressString : addresses) {
            Address address = GenericAddress.parse(addressString.toString());
            if (address == null) {
                logger.fatal("Could not parse address string '" + addressString + "'");
                return;
            }
            TransportMapping<Address> tm = TransportMappings.getInstance().createTransportMapping(address);
            if (tm != null) {
                md.addTransportMapping(tm);
                continue;
            }
            logger.warn((Serializable)((Object)("No transport mapping available for address '" + address + "'.")));
        }
    }

    public void run() {
        this.server.addContext(new OctetString("context1"));
        this.agent.initialize();
        SNMPv2MIB context1SNMPv2MIB = new SNMPv2MIB(new OctetString(), new OID(), new Integer32(0));
        try {
            context1SNMPv2MIB.registerMOs(this.server, new OctetString("context1"));
        }
        catch (DuplicateRegistrationException e2) {
            throw new RuntimeException(e2);
        }
        this.agent.setupProxyForwarder();
        this.registerMIBs();
        this.agent.setTableSizeLimits(this.tableSizeLimits);
        this.agent.registerShutdownHook();
        this.agent.run();
    }

    protected MOFactory getFactory() {
        return DefaultMOFactory.getInstance();
    }

    protected void registerMIBs() {
        if (this.modules == null) {
            this.modules = new Modules(this.getFactory());
            this.modules.getSnmp4jDemoMib().getSnmp4jDemoEntry().addMOTableRowListener(new DemoTableRowListener());
            ((TimeStamp)this.modules.getSnmp4jDemoMib().getSnmp4jDemoEntry().getColumn(3)).setSysUpTime(this.agent.getSysUpTime());
        }
        try {
            this.modules.registerMOs(this.server, null);
        }
        catch (DuplicateRegistrationException drex) {
            logger.error("Duplicate registration: " + drex.getMessage() + ". MIB object registration may be incomplete!", drex);
        }
    }

    protected static List<String[]> splitArgsForMultipleAgents(String[] args, String separatorArgs) {
        ArrayList<String[]> agentsCommandLines = new ArrayList<String[]>();
        ArrayList<String> agentArgs = new ArrayList<String>();
        for (String arg : args) {
            if ("||".equals(arg)) {
                agentsCommandLines.add(agentArgs.toArray(new String[0]));
                agentArgs.clear();
                continue;
            }
            agentArgs.add(arg);
        }
        agentsCommandLines.add(agentArgs.toArray(new String[0]));
        return agentsCommandLines;
    }

    public static void main(String[] args) {
        ArgumentParser parser = new ArgumentParser(COMMAND_LINE_OPTIONS, COMMAND_LINE_PARAMS);
        List<String[]> multiAgentArgs = SampleAgent.splitArgsForMultipleAgents(args, "||");
        for (String[] agentArgs : multiAgentArgs) {
            try {
                Map<String, List<Object>> commandLineParameters = parser.parse(agentArgs);
                if (commandLineParameters.containsKey("x")) {
                    SNMP4JSettings.setExtensibilityEnabled(true);
                }
                SampleAgent sampleAgent = new SampleAgent(commandLineParameters);
                SecurityProtocols.getInstance().addDefaultProtocols();
                sampleAgent.run();
            }
            catch (ParseException ex) {
                logger.error(ex.getMessage(), ex);
            }
        }
    }

    static {
        LogFactory.setLogFactory(new ConsoleLogFactory());
        SNMP4JSettings.setSecretLoggingEnabled(true);
        logger = LogFactory.getLogger(SampleAgent.class);
    }

    class DemoTableRowListener
    implements MOTableRowListener<Snmp4jDemoMib.Snmp4jDemoEntryRow> {
        DemoTableRowListener() {
        }

        @Override
        public void rowChanged(MOTableRowEvent<Snmp4jDemoMib.Snmp4jDemoEntryRow> event) {
            if (event.getType() == 1 || event.getType() == 4) {
                return;
            }
            Counter32 counter = (Counter32)event.getRow().getValue(2);
            if (counter == null) {
                counter = new Counter32(0L);
                ((MOMutableTableRow)event.getRow()).setValue(2, counter);
            }
            counter.increment();
            TimeStamp timestamp = (TimeStamp)event.getTable().getColumn(3);
            timestamp.update(event.getRow(), 3);
            Integer32 type = new Integer32(2);
            switch (event.getType()) {
                case 2: {
                    type.setValue(1);
                    break;
                }
                case 3: {
                    type.setValue(3);
                }
            }
            VariableBinding[] payload = new VariableBinding[2];
            OID table = event.getTable().getOID();
            OID updateCount = new OID(table);
            updateCount.append(5);
            updateCount.append(event.getRow().getIndex());
            OID modifyType = new OID(table);
            modifyType.append(9);
            modifyType.append(event.getRow().getIndex());
            payload[0] = new VariableBinding(updateCount, counter);
            payload[1] = new VariableBinding(modifyType, type);
            SampleAgent.this.modules.getSnmp4jDemoMib().snmp4jDemoEvent(SampleAgent.this.agent.getNotificationOriginator(), new OctetString(), payload);
        }
    }
}

