/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.snmp4j.agent.ContextEvent;
import org.snmp4j.agent.ContextListener;
import org.snmp4j.agent.DefaultMOContextScope;
import org.snmp4j.agent.DefaultMOQuery;
import org.snmp4j.agent.DuplicateRegistrationException;
import org.snmp4j.agent.MOContextScope;
import org.snmp4j.agent.MOQuery;
import org.snmp4j.agent.MOScope;
import org.snmp4j.agent.MOScopeComparator;
import org.snmp4j.agent.MOServer;
import org.snmp4j.agent.MOServerLookupEvent;
import org.snmp4j.agent.MOServerLookupListener;
import org.snmp4j.agent.ManagedObject;
import org.snmp4j.agent.ManagedObjectValueAccess;
import org.snmp4j.agent.RegisteredManagedObject;
import org.snmp4j.agent.UpdatableManagedObject;
import org.snmp4j.agent.UpdateStrategy;
import org.snmp4j.agent.mo.ChangeableManagedObject;
import org.snmp4j.agent.mo.MOChangeListener;
import org.snmp4j.agent.mo.MOColumn;
import org.snmp4j.agent.mo.MOFilter;
import org.snmp4j.agent.mo.MOTable;
import org.snmp4j.agent.mo.MOTableModel;
import org.snmp4j.agent.mo.MOTableRow;
import org.snmp4j.agent.mo.MOTableRowListener;
import org.snmp4j.agent.mo.lock.DefaultMOLockStrategy;
import org.snmp4j.agent.mo.lock.LockRequest;
import org.snmp4j.agent.mo.lock.MOLockStrategy;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;

public class DefaultMOServer
implements MOServer {
    private static final LogAdapter logger = LogFactory.getLogger(DefaultMOServer.class);
    private final Set<OctetString> contexts;
    private final SortedMap<MOScope, ManagedObject<?>> registry;
    private final Map<ManagedObject<?>, Lock> lockList;
    private Map<ManagedObject<?>, List<MOServerLookupListener>> lookupListener;
    private transient List<ContextListener> contextListeners;
    private UpdateStrategy updateStrategy;
    private MOLockStrategy lockStrategy = new DefaultMOLockStrategy();

    public DefaultMOServer() {
        this.registry = new TreeMap(new MOScopeComparator());
        this.contexts = new LinkedHashSet<OctetString>(10);
        this.lockList = new Hashtable(10);
    }

    public ManagedObject lookup(MOQuery query) {
        return this.lookup(query, false, null, new MOServerLookupEvent(this, null, query, MOServerLookupEvent.IntendedUse.undefined), ManagedObject.class);
    }

    @Override
    public <MO extends ManagedObject<?>> MO lookup(MOQuery query, LockRequest lockRequest, MOServerLookupEvent lookupEvent, Class<MO> managedObjectType) {
        return this.lookup(query, false, lockRequest, lookupEvent, managedObjectType);
    }

    public MOLockStrategy getLockStrategy() {
        return this.lockStrategy;
    }

    public void setLockStrategy(MOLockStrategy lockStrategy) {
        this.lockStrategy = lockStrategy;
    }

    private <MO extends ManagedObject<?>> MO lookup(MOQuery query, boolean specificRegistrationsOnly, LockRequest lockRequest, MOServerLookupEvent event, Class<MO> managedObjectType) {
        SortedMap<MOScope, ManagedObject<?>> scope = this.registry.tailMap(query);
        boolean timedOut = false;
        if (lockRequest != null) {
            lockRequest.setLockRequestStatus(LockRequest.LockStatus.notRequired);
        }
        for (Map.Entry<MOScope, ManagedObject<?>> entry : scope.entrySet()) {
            MOScope key = entry.getKey();
            if (!MOScopeComparator.isQueryContextMatching(query, key) || specificRegistrationsOnly && (!(key instanceof MOContextScope) || ((MOContextScope)key).getContext() == null)) continue;
            ManagedObject<?> managedObject = entry.getValue();
            MOScope moScope = managedObject.getScope();
            if (!managedObjectType.isInstance(managedObject) || !query.getScope().isOverlapping(moScope)) continue;
            ManagedObject mo = (ManagedObject)managedObjectType.cast(managedObject);
            event.setLookupResult(mo);
            this.fireQueryEvent(mo, event);
            if (this.lockStrategy != null && lockRequest != null && lockRequest.getLockOwner() != null && this.lockStrategy.isLockNeeded(mo, query)) {
                if (!this.lock(lockRequest.getLockOwner(), mo, lockRequest.getTimeoutMillis())) {
                    timedOut = true;
                    continue;
                }
                lockRequest.setLockRequestStatus(timedOut ? LockRequest.LockStatus.lockedAfterTimeout : LockRequest.LockStatus.locked);
            }
            if (mo instanceof UpdatableManagedObject) {
                this.checkForUpdate((UpdatableManagedObject)mo, query);
            }
            if (query.matchesQuery(mo)) {
                event.setLookupResult(mo);
                this.fireLookupEvent(mo, event);
                return (MO)mo;
            }
            if (lockRequest == null) continue;
            this.unlock(lockRequest.getLockOwner(), mo);
        }
        if (timedOut) {
            lockRequest.setLockRequestStatus(LockRequest.LockStatus.lockTimedOut);
        }
        return null;
    }

    protected void checkForUpdate(UpdatableManagedObject<?> mo, MOQuery query) {
        if (this.updateStrategy != null && this.updateStrategy.isUpdateNeeded(this, mo, query)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("Updating UpdatableManagedObject " + mo + " on behalf of query " + query)));
            }
            mo.update(query);
        }
    }

    public ManagedObject<?> getManagedObject(OID key, OctetString context, boolean fireLookupEvents) {
        DefaultMOContextScope scope = new DefaultMOContextScope(context, key, true, key, true);
        DefaultMOQuery query = new DefaultMOQuery(scope);
        SortedMap<MOScope, ManagedObject<?>> reducedScope = this.registry.tailMap(query);
        for (Map.Entry<MOScope, ManagedObject<?>> entry : reducedScope.entrySet()) {
            ManagedObject<?> mo;
            MOScope compareScope = entry.getKey();
            if (!MOScopeComparator.isQueryContextMatching(query, compareScope) || (!((mo = entry.getValue()) instanceof RegisteredManagedObject) || !((RegisteredManagedObject)mo).getID().equals(key)) && (mo instanceof RegisteredManagedObject || !key.equals(mo.getScope().getLowerBound()))) continue;
            if (fireLookupEvents) {
                MOServerLookupEvent event = new MOServerLookupEvent(this, mo, query, MOServerLookupEvent.IntendedUse.undefined);
                this.fireQueryEvent(mo, event);
                boolean locked = false;
                if (mo instanceof UpdatableManagedObject && (locked = this.lock(this, mo))) {
                    this.checkForUpdate((UpdatableManagedObject)mo, query);
                }
                this.fireLookupEvent(mo, event);
                if (locked) {
                    this.unlock(this, mo);
                }
            }
            return mo;
        }
        return null;
    }

    public ManagedObject<?> getManagedObject(OID key, OctetString context) {
        return this.getManagedObject(key, context, true);
    }

    public static Variable getValue(MOServer server, OctetString context, OID key) {
        DefaultMOContextScope scope = new DefaultMOContextScope(context, key, true, key, true);
        MOServerLookupEvent lookupEvent = new MOServerLookupEvent(server, null, new DefaultMOQuery(scope), MOServerLookupEvent.IntendedUse.get, true);
        ManagedObject<?> mo = server.lookup(lookupEvent.getQuery(), null, lookupEvent);
        if (mo instanceof ManagedObjectValueAccess) {
            Variable variable = ((ManagedObjectValueAccess)mo).getValue(key);
            lookupEvent.completedUse(variable);
            return variable;
        }
        return null;
    }

    public static boolean setValue(MOServer server, OctetString context, VariableBinding newValueAndKey) {
        OID key = newValueAndKey.getOid();
        DefaultMOContextScope scope = new DefaultMOContextScope(context, key, true, key, true);
        MOServerLookupEvent lookupEvent = new MOServerLookupEvent(server, null, new DefaultMOQuery(scope), MOServerLookupEvent.IntendedUse.update, true);
        ManagedObject<?> mo = server.lookup(lookupEvent.getQuery(), null, lookupEvent);
        if (mo instanceof ManagedObjectValueAccess) {
            boolean variableSet = ((ManagedObjectValueAccess)mo).setValue(newValueAndKey);
            if (variableSet) {
                lookupEvent.completedUse(newValueAndKey);
            } else {
                lookupEvent.completedUse(null);
            }
            return variableSet;
        }
        lookupEvent.completedUse(null);
        return false;
    }

    protected void fireLookupEvent(ManagedObject<?> mo, MOServerLookupEvent event) {
        if (this.lookupListener != null) {
            List<MOServerLookupListener> l2 = this.lookupListener.get(mo);
            if (l2 != null) {
                this.callLookupListeners(event, l2);
            }
            if ((l2 = this.lookupListener.get(null)) != null) {
                this.callLookupListeners(event, l2);
            }
        }
    }

    private void callLookupListeners(MOServerLookupEvent event, List<MOServerLookupListener> l2) {
        ArrayList<MOServerLookupListener> listCopy = new ArrayList<MOServerLookupListener>(l2);
        for (MOServerLookupListener item : listCopy) {
            item.lookupEvent(event);
        }
    }

    protected void fireQueryEvent(ManagedObject<?> mo, MOServerLookupEvent event) {
        List<MOServerLookupListener> l2;
        if (this.lookupListener != null && (l2 = this.lookupListener.get(mo)) != null) {
            l2 = new ArrayList<MOServerLookupListener>(l2);
            for (MOServerLookupListener item : l2) {
                item.queryEvent(event);
            }
        }
    }

    @Override
    public OctetString[] getContexts() {
        return this.contexts.toArray(new OctetString[0]);
    }

    @Override
    public boolean isContextSupported(OctetString context) {
        if (context == null || context.length() == 0) {
            return true;
        }
        return this.contexts.contains(context);
    }

    public SortedMap<MOScope, ManagedObject<?>> getRegistry() {
        return this.registry;
    }

    public UpdateStrategy getUpdateStrategy() {
        return this.updateStrategy;
    }

    public void setUpdateStrategy(UpdateStrategy updateStrategy) {
        this.updateStrategy = updateStrategy;
    }

    @Override
    public void register(ManagedObject<?> mo, OctetString context) throws DuplicateRegistrationException {
        if (context == null || context.length() == 0) {
            MOServerLookupEvent lookupEvent;
            DefaultMOContextScope contextScope = new DefaultMOContextScope(null, mo.getScope());
            ManagedObject<?> other = this.lookup(new DefaultMOQuery(contextScope), null, lookupEvent = new MOServerLookupEvent(this, mo, new DefaultMOQuery(contextScope), MOServerLookupEvent.IntendedUse.register));
            if (other != null) {
                throw new DuplicateRegistrationException(contextScope, other.getScope());
            }
            this.registry.put(mo.getScope(), mo);
            if (logger.isInfoEnabled()) {
                logger.info("Registered MO [" + mo.getClass().getSimpleName() + "] in default context with scope " + mo.getScope());
            }
        } else {
            DefaultMOContextScope contextScope = new DefaultMOContextScope(context, mo.getScope());
            MOServerLookupEvent lookupEvent = new MOServerLookupEvent(this, mo, new DefaultMOQuery(contextScope), MOServerLookupEvent.IntendedUse.register);
            ManagedObject other = this.lookup(lookupEvent.getQuery(), true, null, lookupEvent, ManagedObject.class);
            if (other != null) {
                throw new DuplicateRegistrationException(contextScope, other.getScope());
            }
            this.registry.put(contextScope, mo);
            if (logger.isInfoEnabled()) {
                logger.info("Registered MO [" + mo.getClass().getSimpleName() + "] in context " + context + " with scope " + contextScope);
            }
        }
    }

    @Override
    public ManagedObject<?> unregister(ManagedObject<?> mo, OctetString context) {
        MOScope key = context == null || context.length() == 0 ? mo.getScope() : new DefaultMOContextScope(context, mo.getScope());
        ManagedObject<?> r2 = (ManagedObject<?>)this.registry.remove(key);
        if (r2 == null) {
            SortedMap<MOScope, ManagedObject<?>> tailMap = this.registry.tailMap(key);
            Iterator<Map.Entry<MOScope, ManagedObject<?>>> it = tailMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<MOScope, ManagedObject<?>> entry = it.next();
                MOScope entryKey = entry.getKey();
                if (!entry.getValue().equals(mo) || context != null && (!(entryKey instanceof MOContextScope) || !context.equals(((MOContextScope)entryKey).getContext()))) continue;
                r2 = entry.getValue();
                it.remove();
                break;
            }
        }
        if (r2 != null) {
            MOServerLookupEvent event = new MOServerLookupEvent(this, r2, new DefaultMOQuery(key instanceof MOContextScope ? (MOContextScope)key : new DefaultMOContextScope(null, key)), MOServerLookupEvent.IntendedUse.unregister);
            this.fireLookupEvent(r2, event);
        }
        if (logger.isInfoEnabled()) {
            if (r2 != null) {
                logger.info("Removed registration " + r2 + " for " + mo.getScope() + " in context '" + context + "' successfully");
            } else {
                logger.warn((Serializable)((Object)("Removing registration failed for " + mo.getScope() + " in context '" + context + "'")));
            }
        }
        return r2;
    }

    @Override
    public void addContext(OctetString context) {
        this.contexts.add(context);
        this.fireContextChanged(new ContextEvent(this, 1, context));
    }

    @Override
    public void removeContext(OctetString context) {
        this.contexts.remove(context);
        this.fireContextChanged(new ContextEvent(this, 2, context));
    }

    @Override
    public synchronized boolean lock(Object owner, ManagedObject<?> managedObject) {
        return this.lock(owner, managedObject, 0L);
    }

    @Override
    public synchronized boolean lock(Object owner, ManagedObject<?> managedObject, long timeoutMillis) {
        long start = System.nanoTime();
        do {
            Lock lock;
            if ((lock = this.lockList.get(managedObject)) == null || lock.getOwner() != owner && lock.getCount() <= 0) {
                this.lockList.put(managedObject, new Lock(owner));
                if (logger.isDebugEnabled()) {
                    logger.debug((Serializable)((Object)("Acquired lock on " + managedObject + " for " + owner)));
                }
                return true;
            }
            if (lock.getOwner() != owner) {
                try {
                    while (lock.getCount() > 0 && (System.nanoTime() - start) / 1000000L < timeoutMillis) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Serializable)((Object)("Waiting for lock on " + managedObject)));
                        }
                        if (timeoutMillis <= 0L) {
                            this.wait();
                            continue;
                        }
                        this.wait(Math.max(timeoutMillis - (System.nanoTime() - start) / 1000000L, 1L));
                    }
                    continue;
                }
                catch (InterruptedException ex) {
                    logger.warn((Serializable)((Object)("Waiting for lock on " + managedObject + " has been interrupted!")));
                    break;
                }
            }
            lock.add();
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("Added lock on " + managedObject + " for " + owner)));
            }
            return true;
        } while (timeoutMillis <= 0L || (System.nanoTime() - start) / 1000000L < timeoutMillis);
        return false;
    }

    @Override
    public synchronized boolean unlock(Object owner, ManagedObject<?> managedObject) {
        Lock lock;
        if (managedObject != null && (lock = this.lockList.get(managedObject)) != null) {
            if (lock.getOwner() != owner) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Serializable)((Object)("Object '" + owner + "' is not owner of lock: " + lock)));
                }
            } else if (lock.remove()) {
                this.lockList.remove(managedObject);
                if (logger.isDebugEnabled()) {
                    logger.debug((Serializable)((Object)("Removed lock on " + managedObject + " by " + owner)));
                }
                this.notify();
                return true;
            }
        }
        return false;
    }

    @Override
    public Iterator<Map.Entry<MOScope, ManagedObject<?>>> iterator() {
        return this.iterator(new MOScopeComparator(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Iterator<Map.Entry<MOScope, ManagedObject<?>>> iterator(Comparator<MOScope> comparator, MOFilter moFilter) {
        SortedMap<MOScope, ManagedObject<?>> sortedMap = this.registry;
        synchronized (sortedMap) {
            TreeMap r2 = new TreeMap(comparator);
            if (moFilter != null) {
                for (Map.Entry<MOScope, ManagedObject<?>> entry : this.registry.entrySet()) {
                    if (!moFilter.passesFilter(entry.getValue())) continue;
                    r2.put(entry.getKey(), entry.getValue());
                }
            } else {
                r2.putAll(this.registry);
            }
            return r2.entrySet().iterator();
        }
    }

    @Override
    public synchronized void addLookupListener(MOServerLookupListener listener, ManagedObject<?> mo) {
        if (this.lookupListener == null) {
            this.lookupListener = Collections.synchronizedMap(new HashMap());
        }
        List l2 = this.lookupListener.computeIfAbsent(mo, k2 -> Collections.synchronizedList(new LinkedList()));
        l2.add(listener);
    }

    @Override
    public synchronized boolean removeLookupListener(MOServerLookupListener listener, ManagedObject<?> mo) {
        List<MOServerLookupListener> l2;
        if (this.lookupListener != null && (l2 = this.lookupListener.get(mo)) != null) {
            return l2.remove(listener);
        }
        return false;
    }

    @Override
    public synchronized void addContextListener(ContextListener l2) {
        if (this.contextListeners == null) {
            this.contextListeners = new ArrayList<ContextListener>(2);
        }
        this.contextListeners.add(l2);
    }

    @Override
    public synchronized void removeContextListener(ContextListener l2) {
        if (this.contextListeners != null) {
            this.contextListeners.remove(l2);
        }
    }

    protected void fireContextChanged(ContextEvent event) {
        if (this.contextListeners != null) {
            List<ContextListener> listeners = this.contextListeners;
            for (ContextListener listener : listeners) {
                listener.contextChanged(event);
            }
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(this.getClass().getName());
        buf.append("[contexts=");
        buf.append(this.contexts);
        buf.append("[keys={");
        Iterator<MOScope> it = this.registry.keySet().iterator();
        while (it.hasNext()) {
            MOScope scope = it.next();
            buf.append(scope.getLowerBound());
            if (scope.isLowerIncluded()) {
                buf.append("+");
            }
            buf.append("-");
            buf.append(scope.getUpperBound());
            if (scope.isUpperIncluded()) {
                buf.append("+");
            }
            if (scope instanceof MOContextScope) {
                buf.append("(").append(((MOContextScope)scope).getContext()).append(")");
            }
            if (!it.hasNext()) continue;
            buf.append(",");
        }
        buf.append("}");
        buf.append(",registry=").append(this.registry);
        buf.append(",lockList=").append(this.lockList);
        buf.append(",lookupListener=").append(this.lookupListener);
        buf.append("]");
        return buf.toString();
    }

    @Override
    public OctetString[] getRegisteredContexts(ManagedObject<?> managedObject) {
        HashSet<OctetString> contextSet = new HashSet<OctetString>();
        SortedMap<MOScope, ManagedObject<?>> scope = this.registry.tailMap(new DefaultMOContextScope(null, managedObject.getScope()));
        for (Map.Entry<MOScope, ManagedObject<?>> entry : scope.entrySet()) {
            MOScope key = entry.getKey();
            ManagedObject<?> o2 = entry.getValue();
            if (!managedObject.equals(o2)) continue;
            if (key instanceof MOContextScope) {
                contextSet.add(((MOContextScope)key).getContext());
                continue;
            }
            contextSet.add(null);
        }
        return contextSet.toArray(new OctetString[0]);
    }

    @Override
    public Map<OctetString, MOScope> getRegisteredScopes(ManagedObject<?> managedObject) {
        HashMap<OctetString, MOScope> scopes = new HashMap<OctetString, MOScope>();
        SortedMap<MOScope, ManagedObject<?>> scope = this.registry.tailMap(new DefaultMOContextScope(null, managedObject.getScope()));
        for (Map.Entry<MOScope, ManagedObject<?>> entry : scope.entrySet()) {
            MOScope key = entry.getKey();
            ManagedObject<?> o2 = entry.getValue();
            if (!managedObject.equals(o2)) continue;
            if (key instanceof MOContextScope) {
                scopes.put(((MOContextScope)key).getContext(), key);
                continue;
            }
            scopes.put(null, key);
        }
        return scopes;
    }

    public static <R extends MOTableRow, T extends MOTable<R, ? extends MOColumn, ? extends MOTableModel<R>>> void registerTableRowListener(MOServer server, MOTableRowListener<R> listener) {
        Iterator<Map.Entry<MOScope, ManagedObject<?>>> it = server.iterator();
        while (it.hasNext()) {
            ManagedObject<?> mo = it.next().getValue();
            if (!(mo instanceof MOTable)) continue;
            ((MOTable)mo).addMOTableRowListener(listener);
        }
    }

    public static <R extends MOTableRow, T extends MOTable<R, ? extends MOColumn, ? extends MOTableModel<R>>> void unregisterTableRowListener(MOServer server, MOTableRowListener<R> listener) {
        Iterator<Map.Entry<MOScope, ManagedObject<?>>> it = server.iterator();
        while (it.hasNext()) {
            ManagedObject<?> mo = it.next().getValue();
            if (!(mo instanceof MOTable)) continue;
            ((MOTable)mo).removeMOTableRowListener(listener);
        }
    }

    public static void registerChangeListener(MOServer server, MOChangeListener listener, MOFilter moFilter) {
        Iterator<Map.Entry<MOScope, ManagedObject<?>>> it = server.iterator();
        while (it.hasNext()) {
            ManagedObject<?> mo = it.next().getValue();
            if (!(mo instanceof ChangeableManagedObject) || moFilter != null && !moFilter.passesFilter(mo)) continue;
            ((ChangeableManagedObject)mo).addMOChangeListener(listener);
        }
    }

    public static void unregisterChangeListener(MOServer server, MOChangeListener listener, MOFilter moFilter) {
        Iterator<Map.Entry<MOScope, ManagedObject<?>>> it = server.iterator();
        while (it.hasNext()) {
            ManagedObject<?> mo = it.next().getValue();
            if (!(mo instanceof ChangeableManagedObject) || moFilter != null && !moFilter.passesFilter(mo)) continue;
            ((ChangeableManagedObject)mo).removeMOChangeListener(listener);
        }
    }

    static class Lock {
        private Object owner;
        private long creationTime = System.currentTimeMillis();
        private int count = 0;

        private Lock() {
        }

        Lock(Object owner) {
            this();
            this.owner = owner;
            this.count = 1;
        }

        public long getCreationTime() {
            return this.creationTime;
        }

        public int getCount() {
            return this.count;
        }

        public synchronized void add() {
            ++this.count;
        }

        public synchronized boolean remove() {
            if (--this.count <= 0) {
                if (this.count != 0) {
                    this.count = 0;
                }
                return true;
            }
            return false;
        }

        public Object getOwner() {
            return this.owner;
        }

        public String toString() {
            return "Lock[owner=" + this.owner + ", creationTime=" + this.creationTime + ", count=" + this.count + "]";
        }
    }
}

