/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.model;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.CookieParam;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.Encoded;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.HttpMethod;
import jakarta.ws.rs.MatrixParam;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.glassfish.jersey.internal.util.ReflectionHelper;

public class AnnotatedMethod
implements AnnotatedElement {
    private static final Set<Class<? extends Annotation>> METHOD_META_ANNOTATIONS = AnnotatedMethod.getSet(HttpMethod.class);
    private static final Set<Class<? extends Annotation>> METHOD_ANNOTATIONS = AnnotatedMethod.getSet(Path.class, Produces.class, Consumes.class);
    private static final Set<Class<? extends Annotation>> PARAMETER_ANNOTATIONS = AnnotatedMethod.getSet(Context.class, Encoded.class, DefaultValue.class, MatrixParam.class, QueryParam.class, CookieParam.class, HeaderParam.class, PathParam.class, FormParam.class);
    private final Method m;
    private final Method am;
    private final Annotation[] methodAnnotations;
    private final Annotation[][] parameterAnnotations;

    @SafeVarargs
    private static Set<Class<? extends Annotation>> getSet(Class<? extends Annotation> ... cs) {
        HashSet<Class<? extends Annotation>> s2 = new HashSet<Class<? extends Annotation>>();
        s2.addAll(Arrays.asList(cs));
        return s2;
    }

    public AnnotatedMethod(Method method) {
        this.m = method;
        this.am = AnnotatedMethod.findAnnotatedMethod(method);
        if (method.equals(this.am)) {
            this.methodAnnotations = method.getAnnotations();
            this.parameterAnnotations = method.getParameterAnnotations();
        } else {
            this.methodAnnotations = AnnotatedMethod.mergeMethodAnnotations(method, this.am);
            this.parameterAnnotations = AnnotatedMethod.mergeParameterAnnotations(method, this.am);
        }
    }

    public Method getMethod() {
        return this.am;
    }

    public Method getDeclaredMethod() {
        return this.m;
    }

    public Annotation[][] getParameterAnnotations() {
        return (Annotation[][])this.parameterAnnotations.clone();
    }

    public Class<?>[] getParameterTypes() {
        return this.am.getParameterTypes();
    }

    public TypeVariable<Method>[] getTypeParameters() {
        return this.am.getTypeParameters();
    }

    public Type[] getGenericParameterTypes() {
        return this.am.getGenericParameterTypes();
    }

    public <T extends Annotation> List<T> getMetaMethodAnnotations(Class<T> annotation) {
        ArrayList<T> ma = new ArrayList<T>();
        for (Annotation a2 : this.methodAnnotations) {
            T metaAnnotation = a2.annotationType().getAnnotation(annotation);
            if (metaAnnotation == null) continue;
            ma.add(metaAnnotation);
        }
        return ma;
    }

    public String toString() {
        return this.m.toString();
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        for (Annotation ma : this.methodAnnotations) {
            if (ma.annotationType() != annotationType) continue;
            return true;
        }
        return false;
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
        for (Annotation ma : this.methodAnnotations) {
            if (ma.annotationType() != annotationType) continue;
            return (T)((Annotation)annotationType.cast(ma));
        }
        return this.am.getAnnotation(annotationType);
    }

    @Override
    public Annotation[] getAnnotations() {
        return (Annotation[])this.methodAnnotations.clone();
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return this.getAnnotations();
    }

    private static Annotation[] mergeMethodAnnotations(Method m3, Method am) {
        List<Annotation> al = AnnotatedMethod.asList(m3.getAnnotations());
        for (Annotation a2 : am.getAnnotations()) {
            if (m3.isAnnotationPresent(a2.getClass())) continue;
            al.add(a2);
        }
        return al.toArray(new Annotation[al.size()]);
    }

    private static Annotation[][] mergeParameterAnnotations(Method m3, Method am) {
        Annotation[][] methodParamAnnotations = m3.getParameterAnnotations();
        Annotation[][] annotatedMethodParamAnnotations = am.getParameterAnnotations();
        ArrayList<List<Annotation>> methodParamAnnotationsList = new ArrayList<List<Annotation>>();
        for (int i2 = 0; i2 < methodParamAnnotations.length; ++i2) {
            List<Annotation> al = AnnotatedMethod.asList(methodParamAnnotations[i2]);
            for (Annotation a2 : annotatedMethodParamAnnotations[i2]) {
                if (!AnnotatedMethod.annotationNotInList(a2.getClass(), al)) continue;
                al.add(a2);
            }
            methodParamAnnotationsList.add(al);
        }
        Annotation[][] mergedAnnotations = new Annotation[methodParamAnnotations.length][];
        for (int i3 = 0; i3 < methodParamAnnotations.length; ++i3) {
            List paramAnnotations = (List)methodParamAnnotationsList.get(i3);
            mergedAnnotations[i3] = paramAnnotations.toArray(new Annotation[paramAnnotations.size()]);
        }
        return mergedAnnotations;
    }

    private static boolean annotationNotInList(Class<? extends Annotation> ca, List<Annotation> la) {
        for (Annotation a2 : la) {
            if (ca != a2.getClass()) continue;
            return false;
        }
        return true;
    }

    private static Method findAnnotatedMethod(Method m3) {
        Method am = AnnotatedMethod.findAnnotatedMethod(m3.getDeclaringClass(), m3);
        return am != null ? am : m3;
    }

    private static Method findAnnotatedMethod(Class<?> c2, Method m3) {
        Method sm;
        if (c2 == Object.class) {
            return null;
        }
        if ((m3 = AccessController.doPrivileged(ReflectionHelper.findMethodOnClassPA(c2, m3))) == null) {
            return null;
        }
        if (AnnotatedMethod.hasAnnotations(m3)) {
            return m3;
        }
        Class<?> sc = c2.getSuperclass();
        if (sc != null && sc != Object.class && (sm = AnnotatedMethod.findAnnotatedMethod(sc, m3)) != null) {
            return sm;
        }
        for (Class<?> ic : c2.getInterfaces()) {
            Method im = AnnotatedMethod.findAnnotatedMethod(ic, m3);
            if (im == null) continue;
            return im;
        }
        return null;
    }

    private static boolean hasAnnotations(Method m3) {
        return AnnotatedMethod.hasMetaMethodAnnotations(m3) || AnnotatedMethod.hasMethodAnnotations(m3) || AnnotatedMethod.hasParameterAnnotations(m3);
    }

    private static boolean hasMetaMethodAnnotations(Method m3) {
        for (Class<? extends Annotation> ac : METHOD_META_ANNOTATIONS) {
            for (Annotation a2 : m3.getAnnotations()) {
                if (a2.annotationType().getAnnotation(ac) == null) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean hasMethodAnnotations(Method m3) {
        for (Class<? extends Annotation> ac : METHOD_ANNOTATIONS) {
            if (!m3.isAnnotationPresent(ac)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasParameterAnnotations(Method m3) {
        Annotation[][] annotationArray = m3.getParameterAnnotations();
        int n2 = annotationArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Annotation[] as;
            for (Annotation a2 : as = annotationArray[i2]) {
                if (!PARAMETER_ANNOTATIONS.contains(a2.annotationType())) continue;
                return true;
            }
        }
        return false;
    }

    @SafeVarargs
    private static <T> List<T> asList(T ... ts) {
        ArrayList<T> l2 = new ArrayList<T>();
        l2.addAll(Arrays.asList(ts));
        return l2;
    }
}

