/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.message.internal;

import org.glassfish.jersey.message.internal.GrammarUtil;

public class StringBuilderUtils {
    public static void appendQuotedIfNonToken(StringBuilder b2, String value) {
        boolean quote;
        if (value == null) {
            return;
        }
        boolean bl = quote = !GrammarUtil.isTokenString(value);
        if (quote) {
            b2.append('\"');
        }
        StringBuilderUtils.appendEscapingQuotes(b2, value);
        if (quote) {
            b2.append('\"');
        }
    }

    public static void appendQuotedIfWhitespace(StringBuilder b2, String value) {
        if (value == null) {
            return;
        }
        boolean quote = GrammarUtil.containsWhiteSpace(value);
        if (quote) {
            b2.append('\"');
        }
        StringBuilderUtils.appendEscapingQuotes(b2, value);
        if (quote) {
            b2.append('\"');
        }
    }

    public static void appendQuoted(StringBuilder b2, String value) {
        b2.append('\"');
        StringBuilderUtils.appendEscapingQuotes(b2, value);
        b2.append('\"');
    }

    public static void appendEscapingQuotes(StringBuilder b2, String value) {
        for (int i2 = 0; i2 < value.length(); ++i2) {
            char c2 = value.charAt(i2);
            if (c2 == '\"') {
                b2.append('\\');
            }
            b2.append(c2);
        }
    }

    private StringBuilderUtils() {
    }
}

