/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.internal.guava;

import java.util.Comparator;
import java.util.Iterator;
import org.glassfish.jersey.internal.guava.ComparatorOrdering;
import org.glassfish.jersey.internal.guava.NaturalOrdering;
import org.glassfish.jersey.internal.guava.NullsFirstOrdering;
import org.glassfish.jersey.internal.guava.NullsLastOrdering;
import org.glassfish.jersey.internal.guava.ReverseOrdering;

public abstract class Ordering<T>
implements Comparator<T> {
    static final int LEFT_IS_GREATER = 1;
    static final int RIGHT_IS_GREATER = -1;

    Ordering() {
    }

    public static <C extends Comparable> Ordering<C> natural() {
        return NaturalOrdering.INSTANCE;
    }

    public static <T> Ordering<T> from(Comparator<T> comparator) {
        return comparator instanceof Ordering ? (Ordering<T>)comparator : new ComparatorOrdering<T>(comparator);
    }

    public <S extends T> Ordering<S> reverse() {
        return new ReverseOrdering(this);
    }

    <S extends T> Ordering<S> nullsFirst() {
        return new NullsFirstOrdering(this);
    }

    <S extends T> Ordering<S> nullsLast() {
        return new NullsLastOrdering(this);
    }

    @Override
    public abstract int compare(T var1, T var2);

    <E extends T> E min(Iterator<E> iterator) {
        E minSoFar = iterator.next();
        while (iterator.hasNext()) {
            minSoFar = this.min(minSoFar, iterator.next());
        }
        return minSoFar;
    }

    <E extends T> E min(Iterable<E> iterable) {
        return this.min(iterable.iterator());
    }

    <E extends T> E min(E a2, E b2) {
        return this.compare(a2, b2) <= 0 ? a2 : b2;
    }

    <E extends T> E min(E a2, E b2, E c2, E ... rest) {
        E minSoFar = this.min(this.min(a2, b2), c2);
        for (E r2 : rest) {
            minSoFar = this.min(minSoFar, r2);
        }
        return minSoFar;
    }

    <E extends T> E max(Iterator<E> iterator) {
        E maxSoFar = iterator.next();
        while (iterator.hasNext()) {
            maxSoFar = this.max(maxSoFar, iterator.next());
        }
        return maxSoFar;
    }

    <E extends T> E max(Iterable<E> iterable) {
        return this.max(iterable.iterator());
    }

    <E extends T> E max(E a2, E b2) {
        return this.compare(a2, b2) >= 0 ? a2 : b2;
    }

    <E extends T> E max(E a2, E b2, E c2, E ... rest) {
        E maxSoFar = this.max(this.max(a2, b2), c2);
        for (E r2 : rest) {
            maxSoFar = this.max(maxSoFar, r2);
        }
        return maxSoFar;
    }
}

