/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.wire;

import com.google.inject.ProvisionException;
import com.google.inject.TypeLiteral;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Provider;
import org.eclipse.sisu.inject.Weak;
import org.eclipse.sisu.wire.DynamicGlue;

final class GlueLoader
extends ClassLoader {
    private static final Object SYSTEM_LOADER_LOCK = new Object();
    private static final String PROVIDER_NAME = Provider.class.getName();
    private static final String GLUE_SUFFIX = "$__sisu__$";
    private static final String DYNAMIC = "dyn";
    private static final ConcurrentMap<Integer, GlueLoader> cachedGlue = Weak.concurrentValues();

    GlueLoader() {
    }

    GlueLoader(ClassLoader parent) {
        super(parent);
    }

    public static <T> T dynamicGlue(TypeLiteral<T> type, Provider<T> provider) {
        try {
            return (T)GlueLoader.dynamicGlue(type.getRawType()).getConstructor(Provider.class).newInstance(provider);
        }
        catch (Exception e2) {
            Throwable cause = e2 instanceof InvocationTargetException ? e2.getCause() : e2;
            throw new ProvisionException("Error proxying: " + type, cause);
        }
        catch (LinkageError e3) {
            throw new ProvisionException("Error proxying: " + type, (Throwable)e3);
        }
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (PROVIDER_NAME.equals(name)) {
            return Provider.class;
        }
        return super.loadClass(name, resolve);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        if (name.endsWith("$__sisu__$dyn")) {
            Class<?> facade = this.loadClass(GlueLoader.unwrap(name));
            byte[] code = DynamicGlue.generateProxyClass(name.replace('.', '/'), facade);
            return this.defineClass(name, code, 0, code.length);
        }
        throw new ClassNotFoundException(name);
    }

    private static Class<?> dynamicGlue(Class<?> facade) throws ClassNotFoundException {
        return GlueLoader.glue(facade.getClassLoader()).loadClass(GlueLoader.wrap(facade.getName(), DYNAMIC));
    }

    private static String wrap(String name, String kind) {
        StringBuilder buf = new StringBuilder();
        if (name.startsWith("java.") || name.startsWith("java/")) {
            buf.append('$');
        }
        return buf.append(name).append(GLUE_SUFFIX).append(kind).toString();
    }

    private static String unwrap(String name) {
        int head = '$' == name.charAt(0) ? 1 : 0;
        int tail = name.lastIndexOf(GLUE_SUFFIX);
        return tail > 0 ? name.substring(head, tail) : name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static GlueLoader glue(ClassLoader parent) {
        int id = System.identityHashCode(parent);
        GlueLoader result = (GlueLoader)cachedGlue.get(id);
        if (result == null || result.getParent() != parent) {
            Object object = parent != null ? parent : SYSTEM_LOADER_LOCK;
            synchronized (object) {
                GlueLoader glue = GlueLoader.createGlue(parent);
                do {
                    if ((result = cachedGlue.putIfAbsent(id++, glue)) != null) continue;
                    return glue;
                } while (result.getParent() != parent);
            }
        }
        return result;
    }

    private static GlueLoader createGlue(final ClassLoader parent) {
        return AccessController.doPrivileged(new PrivilegedAction<GlueLoader>(){

            @Override
            public GlueLoader run() {
                return parent != null ? new GlueLoader(parent) : new GlueLoader();
            }
        });
    }
}

