/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.wire;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Provider;
import org.eclipse.sisu.space.asm.ClassWriter;
import org.eclipse.sisu.space.asm.Label;
import org.eclipse.sisu.space.asm.MethodVisitor;
import org.eclipse.sisu.space.asm.Type;

final class DynamicGlue {
    private static final String PROVIDER_NAME = Type.getInternalName(Provider.class);
    private static final String PROVIDER_DESC = Type.getDescriptor(Provider.class);
    private static final String PROVIDER_HANDLE = "__sisu__";
    private static final String OBJECT_NAME = Type.getInternalName(Object.class);
    private static final String OBJECT_DESC = Type.getDescriptor(Object.class);
    private static final String ILLEGAL_STATE_NAME = Type.getInternalName(IllegalStateException.class);
    private static final Map<String, Method> OBJECT_METHOD_MAP = new HashMap<String, Method>();

    static {
        Method[] methodArray = Object.class.getMethods();
        int n2 = methodArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Method m3 = methodArray[n3];
            if (DynamicGlue.isWrappable(m3)) {
                OBJECT_METHOD_MAP.put(DynamicGlue.signatureKey(m3), m3);
            }
            ++n3;
        }
    }

    private DynamicGlue() {
    }

    public static byte[] generateProxyClass(String proxyName, Class<?> facade) {
        String[] apiNames;
        String superName;
        String facadeName = Type.getInternalName(facade);
        if (facade.isInterface()) {
            superName = OBJECT_NAME;
            apiNames = new String[]{facadeName};
        } else {
            superName = facadeName;
            apiNames = DynamicGlue.getInternalNames(facade.getInterfaces());
        }
        ClassWriter cw = new ClassWriter(1);
        cw.visit(50, 17, proxyName, null, superName, apiNames);
        DynamicGlue.init(cw, superName, proxyName);
        for (Method m3 : DynamicGlue.getWrappableMethods(facade)) {
            DynamicGlue.wrap(cw, proxyName, m3);
        }
        cw.visitEnd();
        return cw.toByteArray();
    }

    private static void init(ClassWriter cw, String superName, String proxyName) {
        cw.visitField(18, PROVIDER_HANDLE, PROVIDER_DESC, null, null).visitEnd();
        MethodVisitor v = cw.visitMethod(1, "<init>", String.valueOf('(') + PROVIDER_DESC + ")V", null, null);
        v.visitCode();
        v.visitVarInsn(25, 0);
        v.visitInsn(89);
        v.visitVarInsn(25, 1);
        v.visitFieldInsn(181, proxyName, PROVIDER_HANDLE, PROVIDER_DESC);
        v.visitMethodInsn(183, superName, "<init>", "()V", false);
        v.visitInsn(177);
        v.visitMaxs(0, 0);
        v.visitEnd();
    }

    private static void wrap(ClassWriter cw, String proxyName, Method method) {
        int n2;
        String methodName = method.getName();
        String descriptor = Type.getMethodDescriptor(method);
        String[] exceptions = DynamicGlue.getInternalNames(method.getExceptionTypes());
        Label handleNullTarget = new Label();
        int modifiers = method.getModifiers() & 0xFFFFFADF;
        MethodVisitor v = cw.visitMethod(modifiers, methodName, descriptor, null, exceptions);
        v.visitCode();
        Class<?> declaringClazz = method.getDeclaringClass();
        String declaringName = Type.getInternalName(declaringClazz);
        boolean isObjectMethod = OBJECT_METHOD_MAP.containsKey(DynamicGlue.signatureKey(method));
        if (!isObjectMethod || "toString".equals(methodName)) {
            v.visitVarInsn(25, 0);
            v.visitFieldInsn(180, proxyName, PROVIDER_HANDLE, PROVIDER_DESC);
            v.visitMethodInsn(185, PROVIDER_NAME, "get", "()" + OBJECT_DESC, true);
            v.visitInsn(89);
            v.visitJumpInsn(198, handleNullTarget);
            boolean isInterface = declaringClazz.isInterface();
            if (!isInterface && Object.class != declaringClazz) {
                v.visitTypeInsn(192, declaringName);
            }
            int slot = 1;
            Type[] typeArray = Type.getArgumentTypes(method);
            int n3 = typeArray.length;
            n2 = 0;
            while (n2 < n3) {
                Type t = typeArray[n2];
                v.visitVarInsn(t.getOpcode(21), slot);
                slot += t.getSize();
                ++n2;
            }
            int invoke = isInterface ? 185 : 182;
            v.visitMethodInsn(invoke, declaringName, methodName, descriptor, isInterface);
            v.visitInsn(Type.getReturnType(method).getOpcode(172));
            v.visitLabel(handleNullTarget);
            v.visitInsn(87);
            if (!isObjectMethod) {
                v.visitTypeInsn(187, ILLEGAL_STATE_NAME);
                v.visitInsn(89);
                v.visitMethodInsn(183, ILLEGAL_STATE_NAME, "<init>", "()V", false);
                v.visitInsn(191);
            }
        }
        if (isObjectMethod) {
            v.visitVarInsn(25, 0);
            int slot = 1;
            Type[] typeArray = Type.getArgumentTypes(method);
            n2 = typeArray.length;
            int n4 = 0;
            while (n4 < n2) {
                Type t = typeArray[n4];
                v.visitVarInsn(t.getOpcode(21), slot);
                slot += t.getSize();
                ++n4;
            }
            v.visitMethodInsn(183, declaringName, methodName, descriptor, false);
            v.visitInsn(Type.getReturnType(method).getOpcode(172));
        }
        v.visitMaxs(0, 0);
        v.visitEnd();
    }

    private static String[] getInternalNames(Class<?> ... clazzes) {
        String[] names = new String[clazzes.length];
        int i2 = 0;
        while (i2 < names.length) {
            names[i2] = Type.getInternalName(clazzes[i2]);
            ++i2;
        }
        return names;
    }

    private static Collection<Method> getWrappableMethods(Class<?> clazz) {
        HashMap<String, Method> methodMap = new HashMap<String, Method>(OBJECT_METHOD_MAP);
        Method[] methodArray = clazz.getMethods();
        int n2 = methodArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Method m3 = methodArray[n3];
            if (DynamicGlue.isWrappable(m3)) {
                methodMap.put(DynamicGlue.signatureKey(m3), m3);
            }
            ++n3;
        }
        return methodMap.values();
    }

    private static boolean isWrappable(Method method) {
        return (method.getModifiers() & 0x18) == 0;
    }

    private static String signatureKey(Method method) {
        StringBuilder buf = new StringBuilder(method.getName());
        Class<?>[] classArray = method.getParameterTypes();
        int n2 = classArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Class<?> t = classArray[n3];
            buf.append(':').append(t);
            ++n3;
        }
        return buf.toString();
    }
}

