/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.plexus;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import com.google.inject.matcher.AbstractMatcher;
import com.google.inject.matcher.Matcher;
import com.google.inject.spi.TypeConverter;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public final class PlexusDateTypeConverter
extends AbstractMatcher<TypeLiteral<?>>
implements TypeConverter,
Module {
    private static final DateFormat[] PLEXUS_DATE_FORMATS;
    private static final String CONVERSION_ERROR = "Cannot convert: \"%s\" to: %s";

    static {
        DateFormat[] dateFormatArray = PLEXUS_DATE_FORMATS = new DateFormat[]{new SimpleDateFormat("yyyy-MM-dd hh:mm:ss.S a", Locale.US), new SimpleDateFormat("yyyy-MM-dd hh:mm:ssa", Locale.US), new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S", Locale.US), new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.US)};
        int n2 = PLEXUS_DATE_FORMATS.length;
        int n3 = 0;
        while (n3 < n2) {
            DateFormat f2 = dateFormatArray[n3];
            f2.setLenient(false);
            ++n3;
        }
    }

    public void configure(Binder binder) {
        binder.convertToTypes((Matcher)this, (TypeConverter)this);
    }

    public boolean matches(TypeLiteral<?> type) {
        return Date.class == type.getRawType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object convert(String value, TypeLiteral<?> toType) {
        DateFormat[] dateFormatArray = PLEXUS_DATE_FORMATS;
        int n2 = PLEXUS_DATE_FORMATS.length;
        int n3 = 0;
        while (n3 < n2) {
            DateFormat f2 = dateFormatArray[n3];
            try {
                DateFormat dateFormat = f2;
                synchronized (dateFormat) {
                    return f2.parse(value);
                }
            }
            catch (ParseException parseException) {
                ++n3;
            }
        }
        throw new IllegalArgumentException(String.format(CONVERSION_ERROR, value, Date.class));
    }
}

