/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.plexus;

import com.google.inject.Injector;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.codehaus.plexus.classworlds.ClassWorldListener;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.eclipse.sisu.inject.MutableBeanLocator;
import org.eclipse.sisu.inject.Weak;

public final class ClassRealmManager
implements ClassWorldListener {
    private static final boolean GET_IMPORT_REALMS_SUPPORTED;
    private static final ConcurrentMap<ClassRealm, Set<String>> visibility;
    private final ConcurrentMap<ClassRealm, Injector> injectors = new ConcurrentHashMap<ClassRealm, Injector>();
    private final MutableBeanLocator beanLocator;

    static {
        boolean getImportRealmsSupported = true;
        try {
            ClassRealm.class.getDeclaredMethod("getImportRealms", new Class[0]);
        }
        catch (Exception exception) {
            getImportRealmsSupported = false;
        }
        catch (LinkageError linkageError) {
            getImportRealmsSupported = false;
        }
        GET_IMPORT_REALMS_SUPPORTED = getImportRealmsSupported;
        visibility = Weak.concurrentKeys();
    }

    public ClassRealmManager(MutableBeanLocator beanLocator) {
        this.beanLocator = beanLocator;
    }

    public static ClassRealm contextRealm() {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        while (tccl != null) {
            if (tccl instanceof ClassRealm) {
                return (ClassRealm)tccl;
            }
            tccl = tccl.getParent();
        }
        return null;
    }

    public static Set<String> visibleRealmNames(ClassRealm contextRealm) {
        if (GET_IMPORT_REALMS_SUPPORTED && contextRealm != null) {
            Set<String> names = (Set<String>)visibility.get(contextRealm);
            if (names == null) {
                names = ClassRealmManager.computeVisibleNames(contextRealm);
                visibility.putIfAbsent(contextRealm, names);
            }
            return names;
        }
        return null;
    }

    public boolean isManaged(ClassRealm realm) {
        return this.injectors.containsKey(realm);
    }

    public void manage(ClassRealm realm, Injector injector) {
        this.injectors.putIfAbsent(realm, injector);
    }

    @Override
    public void realmCreated(ClassRealm realm) {
    }

    @Override
    public void realmDisposed(ClassRealm realm) {
        visibility.remove(realm);
        Injector injector = (Injector)this.injectors.remove(realm);
        if (injector != null) {
            this.beanLocator.remove(injector);
        }
    }

    private static Set<String> computeVisibleNames(ClassRealm forRealm) {
        HashSet<String> visibleRealmNames = new HashSet<String>();
        ArrayList<ClassRealm> searchRealms = new ArrayList<ClassRealm>();
        searchRealms.add(forRealm);
        int i2 = 0;
        while (i2 < searchRealms.size()) {
            ClassRealm realm = (ClassRealm)searchRealms.get(i2);
            if (visibleRealmNames.add(realm.toString())) {
                searchRealms.addAll(realm.getImportRealms());
                ClassRealm parent = realm.getParentRealm();
                if (parent != null) {
                    searchRealms.add(parent);
                }
            }
            ++i2;
        }
        return visibleRealmNames;
    }
}

