/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.tree;

import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.dom4j.IllegalAddException;
import org.dom4j.Node;
import org.dom4j.tree.AbstractBranch;

public class ContentListFacade<T extends Node>
extends AbstractList<T> {
    private List<T> branchContent;
    private AbstractBranch branch;

    public ContentListFacade(AbstractBranch branch, List<T> branchContent) {
        this.branch = branch;
        this.branchContent = branchContent;
    }

    @Override
    public boolean add(T node) {
        this.branch.childAdded((Node)node);
        return this.branchContent.add(node);
    }

    @Override
    public void add(int index, T node) {
        this.branch.childAdded((Node)node);
        this.branchContent.add(index, node);
    }

    @Override
    public T set(int index, T node) {
        this.branch.childAdded((Node)node);
        return (T)((Node)this.branchContent.set(index, node));
    }

    @Override
    public boolean remove(Object object) {
        this.branch.childRemoved(this.asNode(object));
        return this.branchContent.remove(object);
    }

    @Override
    public T remove(int index) {
        Node node = (Node)this.branchContent.remove(index);
        if (node != null) {
            this.branch.childRemoved(node);
        }
        return (T)node;
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        int count = this.branchContent.size();
        Iterator<T> iter = collection.iterator();
        while (iter.hasNext()) {
            this.add((T)((Node)iter.next()));
            ++count;
        }
        return count == this.branchContent.size();
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> collection) {
        int count = this.branchContent.size();
        Iterator<T> iter = collection.iterator();
        while (iter.hasNext()) {
            this.add(index++, (T)((Node)iter.next()));
            --count;
        }
        return count == this.branchContent.size();
    }

    @Override
    public void clear() {
        for (Node node : this) {
            this.branch.childRemoved(node);
        }
        this.branchContent.clear();
    }

    @Override
    public boolean removeAll(Collection<?> c2) {
        for (Object object : c2) {
            this.branch.childRemoved(this.asNode(object));
        }
        return this.branchContent.removeAll(c2);
    }

    @Override
    public int size() {
        return this.branchContent.size();
    }

    @Override
    public boolean isEmpty() {
        return this.branchContent.isEmpty();
    }

    @Override
    public boolean contains(Object o2) {
        return this.branchContent.contains(o2);
    }

    @Override
    public Object[] toArray() {
        return this.branchContent.toArray();
    }

    @Override
    public Object[] toArray(Object[] a2) {
        return this.branchContent.toArray(a2);
    }

    @Override
    public boolean containsAll(Collection<?> c2) {
        return this.branchContent.containsAll(c2);
    }

    @Override
    public T get(int index) {
        return (T)((Node)this.branchContent.get(index));
    }

    @Override
    public int indexOf(Object o2) {
        return this.branchContent.indexOf(o2);
    }

    @Override
    public int lastIndexOf(Object o2) {
        return this.branchContent.lastIndexOf(o2);
    }

    protected Node asNode(Object object) {
        if (object instanceof Node) {
            return (Node)object;
        }
        throw new IllegalAddException("This list must contain instances of Node. Invalid type: " + object);
    }

    protected List<T> getBackingList() {
        return this.branchContent;
    }
}

